(function() {
  var Model, nextInstanceId;

  nextInstanceId = 1;

  module.exports = Model = (function() {
    Model.resetNextInstanceId = function() {
      return nextInstanceId = 1;
    };

    Model.prototype.alive = true;

    function Model(params) {
      this.assignId(params != null ? params.id : void 0);
    }

    Model.prototype.assignId = function(id) {
      if (this.id == null) {
        this.id = id != null ? id : nextInstanceId++;
      }
      if (id >= nextInstanceId) {
        return nextInstanceId = id + 1;
      }
    };

    Model.prototype.destroy = function() {
      if (!this.isAlive()) {
        return;
      }
      this.alive = false;
      return typeof this.destroyed === "function" ? this.destroyed() : void 0;
    };

    Model.prototype.isAlive = function() {
      return this.alive;
    };

    Model.prototype.isDestroyed = function() {
      return !this.isAlive();
    };

    return Model;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9zcmMvbW9kZWwuY29mZmVlIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQUEsTUFBQTs7RUFBQSxjQUFBLEdBQWlCOztFQUVqQixNQUFNLENBQUMsT0FBUCxHQUNNO0lBQ0osS0FBQyxDQUFBLG1CQUFELEdBQXNCLFNBQUE7YUFBRyxjQUFBLEdBQWlCO0lBQXBCOztvQkFFdEIsS0FBQSxHQUFPOztJQUVNLGVBQUMsTUFBRDtNQUNYLElBQUMsQ0FBQSxRQUFELGtCQUFVLE1BQU0sQ0FBRSxXQUFsQjtJQURXOztvQkFHYixRQUFBLEdBQVUsU0FBQyxFQUFEOztRQUNSLElBQUMsQ0FBQSxrQkFBTSxLQUFLLGNBQUE7O01BQ1osSUFBMkIsRUFBQSxJQUFNLGNBQWpDO2VBQUEsY0FBQSxHQUFpQixFQUFBLEdBQUssRUFBdEI7O0lBRlE7O29CQUlWLE9BQUEsR0FBUyxTQUFBO01BQ1AsSUFBQSxDQUFjLElBQUMsQ0FBQSxPQUFELENBQUEsQ0FBZDtBQUFBLGVBQUE7O01BQ0EsSUFBQyxDQUFBLEtBQUQsR0FBUztvREFDVCxJQUFDLENBQUE7SUFITTs7b0JBS1QsT0FBQSxHQUFTLFNBQUE7YUFBRyxJQUFDLENBQUE7SUFBSjs7b0JBRVQsV0FBQSxHQUFhLFNBQUE7YUFBRyxDQUFJLElBQUMsQ0FBQSxPQUFELENBQUE7SUFBUDs7Ozs7QUF0QmYiLCJzb3VyY2VzQ29udGVudCI6WyJuZXh0SW5zdGFuY2VJZCA9IDFcblxubW9kdWxlLmV4cG9ydHMgPVxuY2xhc3MgTW9kZWxcbiAgQHJlc2V0TmV4dEluc3RhbmNlSWQ6IC0+IG5leHRJbnN0YW5jZUlkID0gMVxuXG4gIGFsaXZlOiB0cnVlXG5cbiAgY29uc3RydWN0b3I6IChwYXJhbXMpIC0+XG4gICAgQGFzc2lnbklkKHBhcmFtcz8uaWQpXG5cbiAgYXNzaWduSWQ6IChpZCkgLT5cbiAgICBAaWQgPz0gaWQgPyBuZXh0SW5zdGFuY2VJZCsrXG4gICAgbmV4dEluc3RhbmNlSWQgPSBpZCArIDEgaWYgaWQgPj0gbmV4dEluc3RhbmNlSWRcblxuICBkZXN0cm95OiAtPlxuICAgIHJldHVybiB1bmxlc3MgQGlzQWxpdmUoKVxuICAgIEBhbGl2ZSA9IGZhbHNlXG4gICAgQGRlc3Ryb3llZD8oKVxuXG4gIGlzQWxpdmU6IC0+IEBhbGl2ZVxuXG4gIGlzRGVzdHJveWVkOiAtPiBub3QgQGlzQWxpdmUoKVxuIl19
