(function() {
  var LayerDecoration, idCounter, nextId;

  idCounter = 0;

  nextId = function() {
    return idCounter++;
  };

  module.exports = LayerDecoration = (function() {
    function LayerDecoration(markerLayer, decorationManager, properties1) {
      this.markerLayer = markerLayer;
      this.decorationManager = decorationManager;
      this.properties = properties1;
      this.id = nextId();
      this.destroyed = false;
      this.markerLayerDestroyedDisposable = this.markerLayer.onDidDestroy((function(_this) {
        return function() {
          return _this.destroy();
        };
      })(this));
      this.overridePropertiesByMarker = null;
    }

    LayerDecoration.prototype.destroy = function() {
      if (this.destroyed) {
        return;
      }
      this.markerLayerDestroyedDisposable.dispose();
      this.markerLayerDestroyedDisposable = null;
      this.destroyed = true;
      return this.decorationManager.didDestroyLayerDecoration(this);
    };

    LayerDecoration.prototype.isDestroyed = function() {
      return this.destroyed;
    };

    LayerDecoration.prototype.getId = function() {
      return this.id;
    };

    LayerDecoration.prototype.getMarkerLayer = function() {
      return this.markerLayer;
    };

    LayerDecoration.prototype.getProperties = function() {
      return this.properties;
    };

    LayerDecoration.prototype.setProperties = function(newProperties) {
      if (this.destroyed) {
        return;
      }
      this.properties = newProperties;
      return this.decorationManager.emitDidUpdateDecorations();
    };

    LayerDecoration.prototype.setPropertiesForMarker = function(marker, properties) {
      if (this.destroyed) {
        return;
      }
      if (this.overridePropertiesByMarker == null) {
        this.overridePropertiesByMarker = new Map();
      }
      marker = this.markerLayer.getMarker(marker.id);
      if (properties != null) {
        this.overridePropertiesByMarker.set(marker, properties);
      } else {
        this.overridePropertiesByMarker["delete"](marker);
      }
      return this.decorationManager.emitDidUpdateDecorations();
    };

    LayerDecoration.prototype.getPropertiesForMarker = function(marker) {
      var ref;
      return (ref = this.overridePropertiesByMarker) != null ? ref.get(marker) : void 0;
    };

    return LayerDecoration;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
