(function() {
  var CSON, KeymapManager, bundledKeymaps, fs, path, ref;

  fs = require('fs-plus');

  path = require('path');

  KeymapManager = require('atom-keymap');

  CSON = require('season');

  bundledKeymaps = (ref = require('../package.json')) != null ? ref._atomKeymaps : void 0;

  KeymapManager.prototype.onDidLoadBundledKeymaps = function(callback) {
    return this.emitter.on('did-load-bundled-keymaps', callback);
  };

  KeymapManager.prototype.onDidLoadUserKeymap = function(callback) {
    return this.emitter.on('did-load-user-keymap', callback);
  };

  KeymapManager.prototype.canLoadBundledKeymapsFromMemory = function() {
    return bundledKeymaps != null;
  };

  KeymapManager.prototype.loadBundledKeymaps = function() {
    var keymap, keymapName, keymapPath, keymapsPath, ref1;
    if (bundledKeymaps != null) {
      for (keymapName in bundledKeymaps) {
        keymap = bundledKeymaps[keymapName];
        keymapPath = "core:" + keymapName;
        this.add(keymapPath, keymap, 0, (ref1 = this.devMode) != null ? ref1 : false);
      }
    } else {
      keymapsPath = path.join(this.resourcePath, 'keymaps');
      this.loadKeymap(keymapsPath);
    }
    return this.emitter.emit('did-load-bundled-keymaps');
  };

  KeymapManager.prototype.getUserKeymapPath = function() {
    var userKeymapPath;
    if (this.configDirPath == null) {
      return "";
    }
    if (userKeymapPath = CSON.resolve(path.join(this.configDirPath, 'keymap'))) {
      return userKeymapPath;
    } else {
      return path.join(this.configDirPath, 'keymap.cson');
    }
  };

  KeymapManager.prototype.loadUserKeymap = function() {
    var detail, error, message, stack, userKeymapPath;
    userKeymapPath = this.getUserKeymapPath();
    if (!fs.isFileSync(userKeymapPath)) {
      return;
    }
    try {
      this.loadKeymap(userKeymapPath, {
        watch: true,
        suppressErrors: true,
        priority: 100
      });
    } catch (error1) {
      error = error1;
      if (error.message.indexOf('Unable to watch path') > -1) {
        message = "Unable to watch path: `" + (path.basename(userKeymapPath)) + "`. Make sure you\nhave permission to read `" + userKeymapPath + "`.\n\nOn linux there are currently problems with watch sizes. See\n[this document][watches] for more info.\n[watches]:https://github.com/atom/atom/blob/master/docs/build-instructions/linux.md#typeerror-unable-to-watch-path";
        this.notificationManager.addError(message, {
          dismissable: true
        });
      } else {
        detail = error.path;
        stack = error.stack;
        this.notificationManager.addFatalError(error.message, {
          detail: detail,
          stack: stack,
          dismissable: true
        });
      }
    }
    return this.emitter.emit('did-load-user-keymap');
  };

  KeymapManager.prototype.subscribeToFileReadFailure = function() {
    return this.onDidFailToReadFile((function(_this) {
      return function(error) {
        var detail, message, userKeymapPath;
        userKeymapPath = _this.getUserKeymapPath();
        message = "Failed to load `" + userKeymapPath + "`";
        detail = error.location != null ? error.stack : error.message;
        return _this.notificationManager.addError(message, {
          detail: detail,
          dismissable: true
        });
      };
    })(this));
  };

  module.exports = KeymapManager;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
