(function() {
  var cloneObject, ipcHelpers,
    slice = [].slice;

  ipcHelpers = require('./ipc-helpers');

  cloneObject = function(object) {
    var clone, key, value;
    clone = {};
    for (key in object) {
      value = object[key];
      clone[key] = value;
    }
    return clone;
  };

  module.exports = function(arg) {
    var ApplicationDelegate, AtomEnvironment, Clipboard, CompileCache, FindParentDir, TextEditor, blobStore, buildAtomEnvironment, buildDefaultApplicationDelegate, clipboard, env, error, exitWithStatusCode, exportsPath, getWindowLoadSettings, handleKeydown, headless, ipcRenderer, legacyTestRunner, legacyTestRunnerPath, logFile, packageMetadata, packageRoot, path, promise, ref, ref1, remote, testPaths, testRunner, testRunnerPath, updateProcessEnv, util;
    blobStore = arg.blobStore;
    remote = require('electron').remote;
    exitWithStatusCode = function(status) {
      remote.app.emit('will-quit');
      return remote.process.exit(status);
    };
    try {
      path = require('path');
      ipcRenderer = require('electron').ipcRenderer;
      getWindowLoadSettings = require('./get-window-load-settings');
      CompileCache = require('./compile-cache');
      AtomEnvironment = require('../src/atom-environment');
      ApplicationDelegate = require('../src/application-delegate');
      Clipboard = require('../src/clipboard');
      TextEditor = require('../src/text-editor');
      updateProcessEnv = require('./update-process-env').updateProcessEnv;
      require('./electron-shims');
      ipcRenderer.on('environment', function(event, env) {
        return updateProcessEnv(env);
      });
      ref = getWindowLoadSettings(), testRunnerPath = ref.testRunnerPath, legacyTestRunnerPath = ref.legacyTestRunnerPath, headless = ref.headless, logFile = ref.logFile, testPaths = ref.testPaths, env = ref.env;
      if (headless) {
        util = require('util');
        Object.defineProperties(process, {
          stdout: {
            value: remote.process.stdout
          },
          stderr: {
            value: remote.process.stderr
          }
        });
        console.log = function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          return process.stdout.write((util.format.apply(util, args)) + "\n");
        };
        console.error = function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          return process.stderr.write((util.format.apply(util, args)) + "\n");
        };
      } else {
        remote.getCurrentWindow().show();
      }
      handleKeydown = function(event) {
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 82) {
          ipcHelpers.call('window-method', 'reload');
        }
        if (event.keyCode === 73 && ((process.platform === 'darwin' && event.metaKey && event.altKey) || (process.platform !== 'darwin' && event.ctrlKey && event.shiftKey))) {
          ipcHelpers.call('window-method', 'toggleDevTools');
        }
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 87) {
          ipcHelpers.call('window-method', 'close');
        }
        if ((event.metaKey || event.ctrlKey) && event.keyCode === 67) {
          return ipcHelpers.call('window-method', 'copy');
        }
      };
      window.addEventListener('keydown', handleKeydown, true);
      exportsPath = path.join(getWindowLoadSettings().resourcePath, 'exports');
      require('module').globalPaths.push(exportsPath);
      process.env.NODE_PATH = exportsPath;
      updateProcessEnv(env);
      FindParentDir = require('find-parent-dir');
      if (packageRoot = FindParentDir.sync(testPaths[0], 'package.json')) {
        packageMetadata = require(path.join(packageRoot, 'package.json'));
        if (packageMetadata.atomTranspilers) {
          CompileCache.addTranspilerConfigForPath(packageRoot, packageMetadata.name, packageMetadata, packageMetadata.atomTranspilers);
        }
      }
      document.title = "Spec Suite";
      clipboard = new Clipboard;
      TextEditor.setClipboard(clipboard);
      TextEditor.viewForItem = function(item) {
        return atom.views.getView(item);
      };
      testRunner = require(testRunnerPath);
      legacyTestRunner = require(legacyTestRunnerPath);
      buildDefaultApplicationDelegate = function() {
        return new ApplicationDelegate();
      };
      buildAtomEnvironment = function(params) {
        var atomEnvironment;
        params = cloneObject(params);
        if (!params.hasOwnProperty("clipboard")) {
          params.clipboard = clipboard;
        }
        if (!params.hasOwnProperty("blobStore")) {
          params.blobStore = blobStore;
        }
        if (!params.hasOwnProperty("onlyLoadBaseStyleSheets")) {
          params.onlyLoadBaseStyleSheets = true;
        }
        atomEnvironment = new AtomEnvironment(params);
        atomEnvironment.initialize(params);
        TextEditor.setScheduler(atomEnvironment.views);
        return atomEnvironment;
      };
      promise = testRunner({
        logFile: logFile,
        headless: headless,
        testPaths: testPaths,
        buildAtomEnvironment: buildAtomEnvironment,
        buildDefaultApplicationDelegate: buildDefaultApplicationDelegate,
        legacyTestRunner: legacyTestRunner
      });
      return promise.then(function(statusCode) {
        if (getWindowLoadSettings().headless) {
          return exitWithStatusCode(statusCode);
        }
      });
    } catch (error1) {
      error = error1;
      if (getWindowLoadSettings().headless) {
        console.error((ref1 = error.stack) != null ? ref1 : error);
        return exitWithStatusCode(1);
      } else {
        throw error;
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
