(function() {
  var Grim, asyncifyJasmineFn, buildReporter, buildTerminalReporter, disableFocusMethods, fs, ipcRenderer, path, requireSpecs, setSpecDirectory, setSpecField, setSpecType, temp, waitsForPromise,
    slice = [].slice;

  Grim = require('grim');

  fs = require('fs-plus');

  temp = require('temp');

  path = require('path');

  ipcRenderer = require('electron').ipcRenderer;

  temp.track();

  module.exports = function(arg) {
    var ApplicationDelegate, JasmineJUnitReporter, applicationDelegate, atomHome, buildAtomEnvironment, documentTitle, fileBase, headless, i, j, jasmineContent, jasmineEnv, key, len, len1, loadablePack, logFile, outputDir, packName, promise, ref, resolveWithExitCode, testPackages, testPath, testPaths, userHome, userPack, value;
    logFile = arg.logFile, headless = arg.headless, testPaths = arg.testPaths, buildAtomEnvironment = arg.buildAtomEnvironment;
    ref = require('../vendor/jasmine');
    for (key in ref) {
      value = ref[key];
      window[key] = value;
    }
    require('jasmine-tagged');
    global.it = asyncifyJasmineFn(global.it, 1);
    global.fit = asyncifyJasmineFn(global.fit, 1);
    global.ffit = asyncifyJasmineFn(global.ffit, 1);
    global.fffit = asyncifyJasmineFn(global.fffit, 1);
    global.beforeEach = asyncifyJasmineFn(global.beforeEach, 0);
    global.afterEach = asyncifyJasmineFn(global.afterEach, 0);
    documentTitle = null;
    Object.defineProperty(document, 'title', {
      get: function() {
        return documentTitle;
      },
      set: function(title) {
        return documentTitle = title;
      }
    });
    userHome = process.env.ATOM_HOME || path.join(fs.getHomeDirectory(), '.atom');
    atomHome = temp.mkdirSync({
      prefix: 'atom-test-home-'
    });
    if (process.env.APM_TEST_PACKAGES) {
      testPackages = process.env.APM_TEST_PACKAGES.split(/\s+/);
      fs.makeTreeSync(path.join(atomHome, 'packages'));
      for (i = 0, len = testPackages.length; i < len; i++) {
        packName = testPackages[i];
        userPack = path.join(userHome, 'packages', packName);
        loadablePack = path.join(atomHome, 'packages', packName);
        try {
          fs.symlinkSync(userPack, loadablePack, 'dir');
        } catch (error1) {
          fs.copySync(userPack, loadablePack);
        }
      }
    }
    ApplicationDelegate = require('../src/application-delegate');
    applicationDelegate = new ApplicationDelegate();
    applicationDelegate.setRepresentedFilename = function() {};
    applicationDelegate.setWindowDocumentEdited = function() {};
    window.atom = buildAtomEnvironment({
      applicationDelegate: applicationDelegate,
      window: window,
      document: document,
      configDirPath: atomHome,
      enablePersistence: false
    });
    require('./spec-helper');
    if (process.env.JANKY_SHA1 || process.env.CI) {
      disableFocusMethods();
    }
    for (j = 0, len1 = testPaths.length; j < len1; j++) {
      testPath = testPaths[j];
      requireSpecs(testPath);
    }
    setSpecType('user');
    resolveWithExitCode = null;
    promise = new Promise(function(resolve, reject) {
      return resolveWithExitCode = resolve;
    });
    jasmineEnv = jasmine.getEnv();
    jasmineEnv.addReporter(buildReporter({
      logFile: logFile,
      headless: headless,
      resolveWithExitCode: resolveWithExitCode
    }));
    if (process.env.TEST_JUNIT_XML_PATH) {
      JasmineJUnitReporter = require('./jasmine-junit-reporter').JasmineJUnitReporter;
      process.stdout.write("Outputting JUnit XML to <" + process.env.TEST_JUNIT_XML_PATH + ">\n");
      outputDir = path.dirname(process.env.TEST_JUNIT_XML_PATH);
      fileBase = path.basename(process.env.TEST_JUNIT_XML_PATH, '.xml');
      jasmineEnv.addReporter(new JasmineJUnitReporter(outputDir, true, false, fileBase, true));
    }
    jasmineEnv.setIncludedTags([process.platform]);
    jasmineContent = document.createElement('div');
    jasmineContent.setAttribute('id', 'jasmine-content');
    document.body.appendChild(jasmineContent);
    jasmineEnv.execute();
    return promise;
  };

  asyncifyJasmineFn = function(fn, callbackPosition) {
    return function() {
      var args, callback;
      args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
      if (typeof args[callbackPosition] === 'function') {
        callback = args[callbackPosition];
        args[callbackPosition] = function() {
          var args, result;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          result = callback.apply(this, args);
          if (result instanceof Promise) {
            return waitsForPromise(function() {
              return result;
            });
          }
        };
      }
      return fn.apply(this, args);
    };
  };

  waitsForPromise = function(fn) {
    var promise;
    promise = fn();
    return global.waitsFor('spec promise to resolve', function(done) {
      return promise.then(done, function(error) {
        jasmine.getEnv().currentSpec.fail(error);
        return done();
      });
    });
  };

  disableFocusMethods = function() {
    return ['fdescribe', 'ffdescribe', 'fffdescribe', 'fit', 'ffit', 'fffit'].forEach(function(methodName) {
      var focusMethod;
      focusMethod = window[methodName];
      return window[methodName] = function(description) {
        var error;
        error = new Error('Focused spec is running on CI');
        return focusMethod(description, function() {
          throw error;
        });
      };
    });
  };

  requireSpecs = function(testPath, specType) {
    var i, len, ref, results, testFilePath;
    if (fs.isDirectorySync(testPath)) {
      ref = fs.listTreeSync(testPath);
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        testFilePath = ref[i];
        if (!(/-spec\.(coffee|js)$/.test(testFilePath))) {
          continue;
        }
        require(testFilePath);
        results.push(setSpecDirectory(testPath));
      }
      return results;
    } else {
      require(testPath);
      return setSpecDirectory(path.dirname(testPath));
    }
  };

  setSpecField = function(name, value) {
    var i, index, ref, results, specs;
    specs = jasmine.getEnv().currentRunner().specs();
    if (specs.length === 0) {
      return;
    }
    results = [];
    for (index = i = ref = specs.length - 1; ref <= 0 ? i <= 0 : i >= 0; index = ref <= 0 ? ++i : --i) {
      if (specs[index][name] != null) {
        break;
      }
      results.push(specs[index][name] = value);
    }
    return results;
  };

  setSpecType = function(specType) {
    return setSpecField('specType', specType);
  };

  setSpecDirectory = function(specDirectory) {
    return setSpecField('specDirectory', specDirectory);
  };

  buildReporter = function(arg) {
    var AtomReporter, headless, logFile, reporter, resolveWithExitCode;
    logFile = arg.logFile, headless = arg.headless, resolveWithExitCode = arg.resolveWithExitCode;
    if (headless) {
      return buildTerminalReporter(logFile, resolveWithExitCode);
    } else {
      AtomReporter = require('./atom-reporter');
      return reporter = new AtomReporter();
    }
  };

  buildTerminalReporter = function(logFile, resolveWithExitCode) {
    var JasmineListReporter, TerminalReporter, log, logStream, options;
    if (logFile != null) {
      logStream = fs.openSync(logFile, 'w');
    }
    log = function(str) {
      if (logStream != null) {
        return fs.writeSync(logStream, str);
      } else {
        return ipcRenderer.send('write-to-stderr', str);
      }
    };
    options = {
      print: function(str) {
        return log(str);
      },
      onComplete: function(runner) {
        if (logStream != null) {
          fs.closeSync(logStream);
        }
        if (Grim.getDeprecationsLength() > 0) {
          Grim.logDeprecations();
          resolveWithExitCode(1);
          return;
        }
        if (runner.results().failedCount > 0) {
          return resolveWithExitCode(1);
        } else {
          return resolveWithExitCode(0);
        }
      }
    };
    if (process.env.ATOM_JASMINE_REPORTER === 'list') {
      JasmineListReporter = require('./jasmine-list-reporter').JasmineListReporter;
      return new JasmineListReporter(options);
    } else {
      TerminalReporter = require('jasmine-tagged').TerminalReporter;
      return new TerminalReporter(options);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
