Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom **/

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var WelcomeView = (function () {
  function WelcomeView(props) {
    var _this = this;

    _classCallCheck(this, WelcomeView);

    this.props = props;
    _etch2['default'].initialize(this);

    this.element.addEventListener('click', function (event) {
      var link = event.target.closest('a');
      if (link && link.dataset.event) {
        _this.props.reporterProxy.sendEvent('clicked-welcome-' + link.dataset.event + '-link');
      }
    });
  }

  _createClass(WelcomeView, [{
    key: 'didChangeShowOnStartup',
    value: function didChangeShowOnStartup() {
      atom.config.set('welcome.showOnStartup', this.checked);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: 'WelcomeView',
        uri: this.props.uri
      };
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'welcome' },
        _etch2['default'].dom(
          'div',
          { className: 'welcome-container' },
          _etch2['default'].dom(
            'header',
            { className: 'welcome-header' },
            _etch2['default'].dom(
              'a',
              { href: 'https://atom.io/' },
              _etch2['default'].dom(
                'svg',
                {
                  className: 'welcome-logo',
                  width: '330px',
                  height: '68px',
                  viewBox: '0 0 330 68',
                  version: '1.1'
                },
                _etch2['default'].dom(
                  'g',
                  {
                    stroke: 'none',
                    'stroke-width': '1',
                    fill: 'none',
                    'fill-rule': 'evenodd'
                  },
                  _etch2['default'].dom(
                    'g',
                    { transform: 'translate(2.000000, 1.000000)' },
                    _etch2['default'].dom(
                      'g',
                      {
                        transform: 'translate(96.000000, 8.000000)',
                        fill: 'currentColor'
                      },
                      _etch2['default'].dom('path', { d: 'M185.498,3.399 C185.498,2.417 186.34,1.573 187.324,1.573 L187.674,1.573 C188.447,1.573 189.01,1.995 189.5,2.628 L208.676,30.862 L227.852,2.628 C228.272,1.995 228.905,1.573 229.676,1.573 L230.028,1.573 C231.01,1.573 231.854,2.417 231.854,3.399 L231.854,49.403 C231.854,50.387 231.01,51.231 230.028,51.231 C229.044,51.231 228.202,50.387 228.202,49.403 L228.202,8.246 L210.151,34.515 C209.729,35.148 209.237,35.428 208.606,35.428 C207.973,35.428 207.481,35.148 207.061,34.515 L189.01,8.246 L189.01,49.475 C189.01,50.457 188.237,51.231 187.254,51.231 C186.27,51.231 185.498,50.458 185.498,49.475 L185.498,3.399 L185.498,3.399 Z' }),
                      _etch2['default'].dom('path', { d: 'M113.086,26.507 L113.086,26.367 C113.086,12.952 122.99,0.941 137.881,0.941 C152.77,0.941 162.533,12.811 162.533,26.225 L162.533,26.367 C162.533,39.782 152.629,51.792 137.74,51.792 C122.85,51.792 113.086,39.923 113.086,26.507 M158.74,26.507 L158.74,26.367 C158.74,14.216 149.89,4.242 137.74,4.242 C125.588,4.242 116.879,14.075 116.879,26.225 L116.879,26.367 C116.879,38.518 125.729,48.491 137.881,48.491 C150.031,48.491 158.74,38.658 158.74,26.507' }),
                      _etch2['default'].dom('path', { d: 'M76.705,5.155 L60.972,5.155 C60.06,5.155 59.287,4.384 59.287,3.469 C59.287,2.556 60.059,1.783 60.972,1.783 L96.092,1.783 C97.004,1.783 97.778,2.555 97.778,3.469 C97.778,4.383 97.005,5.155 96.092,5.155 L80.358,5.155 L80.358,49.405 C80.358,50.387 79.516,51.231 78.532,51.231 C77.55,51.231 76.706,50.387 76.706,49.405 L76.706,5.155 L76.705,5.155 Z' }),
                      _etch2['default'].dom('path', { d: 'M0.291,48.562 L21.291,3.05 C21.783,1.995 22.485,1.292 23.75,1.292 L23.891,1.292 C25.155,1.292 25.858,1.995 26.348,3.05 L47.279,48.421 C47.49,48.843 47.56,49.194 47.56,49.546 C47.56,50.458 46.788,51.231 45.803,51.231 C44.961,51.231 44.329,50.599 43.978,49.826 L38.219,37.183 L9.21,37.183 L3.45,49.897 C3.099,50.739 2.538,51.231 1.694,51.231 C0.781,51.231 0.008,50.529 0.008,49.685 C0.009,49.404 0.08,48.983 0.291,48.562 L0.291,48.562 Z M36.673,33.882 L23.749,5.437 L10.755,33.882 L36.673,33.882 L36.673,33.882 Z' })
                    ),
                    _etch2['default'].dom(
                      'g',
                      null,
                      _etch2['default'].dom('path', {
                        d: 'M40.363,32.075 C40.874,34.44 39.371,36.77 37.006,37.282 C34.641,37.793 32.311,36.29 31.799,33.925 C31.289,31.56 32.791,29.23 35.156,28.718 C37.521,28.207 39.851,29.71 40.363,32.075',
                        fill: 'currentColor'
                      }),
                      _etch2['default'].dom('path', {
                        d: 'M48.578,28.615 C56.851,45.587 58.558,61.581 52.288,64.778 C45.822,68.076 33.326,56.521 24.375,38.969 C15.424,21.418 13.409,4.518 19.874,1.221 C22.689,-0.216 26.648,1.166 30.959,4.629',
                        stroke: 'currentColor',
                        'stroke-width': '3.08',
                        'stroke-linecap': 'round'
                      }),
                      _etch2['default'].dom('path', {
                        d: 'M7.64,39.45 C2.806,36.94 -0.009,33.915 0.154,30.79 C0.531,23.542 16.787,18.497 36.462,19.52 C56.137,20.544 71.781,27.249 71.404,34.497 C71.241,37.622 68.127,40.338 63.06,42.333',
                        stroke: 'currentColor',
                        'stroke-width': '3.08',
                        'stroke-linecap': 'round'
                      }),
                      _etch2['default'].dom('path', {
                        d: 'M28.828,59.354 C23.545,63.168 18.843,64.561 15.902,62.653 C9.814,58.702 13.572,42.102 24.296,25.575 C35.02,9.048 48.649,-1.149 54.736,2.803 C57.566,4.639 58.269,9.208 57.133,15.232',
                        stroke: 'currentColor',
                        'stroke-width': '3.08',
                        'stroke-linecap': 'round'
                      })
                    )
                  )
                )
              ),
              _etch2['default'].dom(
                'h1',
                { className: 'welcome-title' },
                'A hackable text editor for the 21',
                _etch2['default'].dom(
                  'sup',
                  null,
                  'st'
                ),
                ' Century'
              )
            )
          ),
          _etch2['default'].dom(
            'section',
            { className: 'welcome-panel' },
            _etch2['default'].dom(
              'p',
              null,
              'For help, please visit'
            ),
            _etch2['default'].dom(
              'ul',
              null,
              _etch2['default'].dom(
                'li',
                null,
                'The',
                ' ',
                _etch2['default'].dom(
                  'a',
                  {
                    href: 'https://www.atom.io/docs',
                    dataset: { event: 'atom-docs' }
                  },
                  'Atom docs'
                ),
                ' ',
                'for Guides and the API reference.'
              ),
              _etch2['default'].dom(
                'li',
                null,
                'The Atom forum at',
                ' ',
                _etch2['default'].dom(
                  'a',
                  { href: 'http://discuss.atom.io', dataset: { event: 'discuss' } },
                  'discuss.atom.io'
                )
              ),
              _etch2['default'].dom(
                'li',
                null,
                'The',
                ' ',
                _etch2['default'].dom(
                  'a',
                  {
                    href: 'https://github.com/atom',
                    dataset: { event: 'atom-org' }
                  },
                  'Atom org'
                ),
                '. This is where all GitHub-created Atom packages can be found.'
              )
            )
          ),
          _etch2['default'].dom(
            'section',
            { className: 'welcome-panel' },
            _etch2['default'].dom(
              'label',
              null,
              _etch2['default'].dom('input', {
                className: 'input-checkbox',
                type: 'checkbox',
                checked: atom.config.get('welcome.showOnStartup'),
                onchange: this.didChangeShowOnStartup
              }),
              'Show Welcome Guide when opening Atom'
            )
          ),
          _etch2['default'].dom(
            'footer',
            { className: 'welcome-footer' },
            _etch2['default'].dom(
              'a',
              { href: 'https://atom.io/', dataset: { event: 'footer-atom-io' } },
              'atom.io'
            ),
            ' ',
            _etch2['default'].dom(
              'span',
              { className: 'text-subtle' },
              '×'
            ),
            ' ',
            _etch2['default'].dom('a', {
              className: 'icon icon-octoface',
              href: 'https://github.com/',
              dataset: { event: 'footer-octocat' }
            })
          )
        )
      );
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.props.uri;
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Welcome';
    }
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      return other instanceof WelcomeView;
    }
  }]);

  return WelcomeView;
})();

exports['default'] = WelcomeView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3dlbGNvbWUvbGliL3dlbGNvbWUtdmlldy5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7O29CQUdpQixNQUFNOzs7O0lBRUYsV0FBVztBQUNuQixXQURRLFdBQVcsQ0FDbEIsS0FBSyxFQUFFOzs7MEJBREEsV0FBVzs7QUFFNUIsUUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7QUFDbkIsc0JBQUssVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDOztBQUV0QixRQUFJLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxVQUFBLEtBQUssRUFBSTtBQUM5QyxVQUFNLElBQUksR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQztBQUN2QyxVQUFJLElBQUksSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRTtBQUM5QixjQUFLLEtBQUssQ0FBQyxhQUFhLENBQUMsU0FBUyxzQkFDYixJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssV0FDdEMsQ0FBQztPQUNIO0tBQ0YsQ0FBQyxDQUFDO0dBQ0o7O2VBYmtCLFdBQVc7O1dBZVIsa0NBQUc7QUFDdkIsVUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0tBQ3hEOzs7V0FFSyxrQkFBRyxFQUFFOzs7V0FFRixxQkFBRztBQUNWLGFBQU87QUFDTCxvQkFBWSxFQUFFLGFBQWE7QUFDM0IsV0FBRyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRztPQUNwQixDQUFDO0tBQ0g7OztXQUVLLGtCQUFHO0FBQ1AsYUFDRTs7VUFBSyxTQUFTLEVBQUMsU0FBUztRQUN0Qjs7WUFBSyxTQUFTLEVBQUMsbUJBQW1CO1VBQ2hDOztjQUFRLFNBQVMsRUFBQyxnQkFBZ0I7WUFDaEM7O2dCQUFHLElBQUksRUFBQyxrQkFBa0I7Y0FDeEI7OztBQUNFLDJCQUFTLEVBQUMsY0FBYztBQUN4Qix1QkFBSyxFQUFDLE9BQU87QUFDYix3QkFBTSxFQUFDLE1BQU07QUFDYix5QkFBTyxFQUFDLFlBQVk7QUFDcEIseUJBQU8sRUFBQyxLQUFLOztnQkFFYjs7O0FBQ0UsMEJBQU0sRUFBQyxNQUFNO0FBQ2Isb0NBQWEsR0FBRztBQUNoQix3QkFBSSxFQUFDLE1BQU07QUFDWCxpQ0FBVSxTQUFTOztrQkFFbkI7O3NCQUFHLFNBQVMsRUFBQywrQkFBK0I7b0JBQzFDOzs7QUFDRSxpQ0FBUyxFQUFDLGdDQUFnQztBQUMxQyw0QkFBSSxFQUFDLGNBQWM7O3NCQUVuQixnQ0FBTSxDQUFDLEVBQUMsaW5CQUFpbkIsR0FBRztzQkFDNW5CLGdDQUFNLENBQUMsRUFBQyxnY0FBZ2MsR0FBRztzQkFDM2MsZ0NBQU0sQ0FBQyxFQUFDLDBWQUEwVixHQUFHO3NCQUNyVyxnQ0FBTSxDQUFDLEVBQUMsZ2dCQUFnZ0IsR0FBRztxQkFDemdCO29CQUNKOzs7c0JBQ0U7QUFDRSx5QkFBQyxFQUFDLHNMQUFzTDtBQUN4TCw0QkFBSSxFQUFDLGNBQWM7d0JBQ25CO3NCQUNGO0FBQ0UseUJBQUMsRUFBQyx3TEFBd0w7QUFDMUwsOEJBQU0sRUFBQyxjQUFjO0FBQ3JCLHdDQUFhLE1BQU07QUFDbkIsMENBQWUsT0FBTzt3QkFDdEI7c0JBQ0Y7QUFDRSx5QkFBQyxFQUFDLGtMQUFrTDtBQUNwTCw4QkFBTSxFQUFDLGNBQWM7QUFDckIsd0NBQWEsTUFBTTtBQUNuQiwwQ0FBZSxPQUFPO3dCQUN0QjtzQkFDRjtBQUNFLHlCQUFDLEVBQUMsc0xBQXNMO0FBQ3hMLDhCQUFNLEVBQUMsY0FBYztBQUNyQix3Q0FBYSxNQUFNO0FBQ25CLDBDQUFlLE9BQU87d0JBQ3RCO3FCQUNBO21CQUNGO2lCQUNGO2VBQ0E7Y0FDTjs7a0JBQUksU0FBUyxFQUFDLGVBQWU7O2dCQUNNOzs7O2lCQUFhOztlQUMzQzthQUNIO1dBQ0c7VUFFVDs7Y0FBUyxTQUFTLEVBQUMsZUFBZTtZQUNoQzs7OzthQUE2QjtZQUM3Qjs7O2NBQ0U7Ozs7Z0JBQ00sR0FBRztnQkFDUDs7O0FBQ0Usd0JBQUksRUFBQywwQkFBMEI7QUFDL0IsMkJBQU8sRUFBRSxFQUFFLEtBQUssRUFBRSxXQUFXLEVBQUUsQUFBQzs7O2lCQUc5QjtnQkFBQyxHQUFHOztlQUVMO2NBQ0w7Ozs7Z0JBQ29CLEdBQUc7Z0JBQ3JCOztvQkFBRyxJQUFJLEVBQUMsd0JBQXdCLEVBQUMsT0FBTyxFQUFFLEVBQUUsS0FBSyxFQUFFLFNBQVMsRUFBRSxBQUFDOztpQkFFM0Q7ZUFDRDtjQUNMOzs7O2dCQUNNLEdBQUc7Z0JBQ1A7OztBQUNFLHdCQUFJLEVBQUMseUJBQXlCO0FBQzlCLDJCQUFPLEVBQUUsRUFBRSxLQUFLLEVBQUUsVUFBVSxFQUFFLEFBQUM7OztpQkFHN0I7O2VBRUQ7YUFDRjtXQUNHO1VBRVY7O2NBQVMsU0FBUyxFQUFDLGVBQWU7WUFDaEM7OztjQUNFO0FBQ0UseUJBQVMsRUFBQyxnQkFBZ0I7QUFDMUIsb0JBQUksRUFBQyxVQUFVO0FBQ2YsdUJBQU8sRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyx1QkFBdUIsQ0FBQyxBQUFDO0FBQ2xELHdCQUFRLEVBQUUsSUFBSSxDQUFDLHNCQUFzQixBQUFDO2dCQUN0Qzs7YUFFSTtXQUNBO1VBRVY7O2NBQVEsU0FBUyxFQUFDLGdCQUFnQjtZQUNoQzs7Z0JBQUcsSUFBSSxFQUFDLGtCQUFrQixFQUFDLE9BQU8sRUFBRSxFQUFFLEtBQUssRUFBRSxnQkFBZ0IsRUFBRSxBQUFDOzthQUU1RDtZQUFDLEdBQUc7WUFDUjs7Z0JBQU0sU0FBUyxFQUFDLGFBQWE7O2FBQVM7WUFBQyxHQUFHO1lBQzFDO0FBQ0UsdUJBQVMsRUFBQyxvQkFBb0I7QUFDOUIsa0JBQUksRUFBQyxxQkFBcUI7QUFDMUIscUJBQU8sRUFBRSxFQUFFLEtBQUssRUFBRSxnQkFBZ0IsRUFBRSxBQUFDO2NBQ3JDO1dBQ0s7U0FDTDtPQUNGLENBQ047S0FDSDs7O1dBRUssa0JBQUc7QUFDUCxhQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDO0tBQ3ZCOzs7V0FFTyxvQkFBRztBQUNULGFBQU8sU0FBUyxDQUFDO0tBQ2xCOzs7V0FFTSxpQkFBQyxLQUFLLEVBQUU7QUFDYixhQUFPLEtBQUssWUFBWSxXQUFXLENBQUM7S0FDckM7OztTQWhLa0IsV0FBVzs7O3FCQUFYLFdBQVciLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvd2VsY29tZS9saWIvd2VsY29tZS12aWV3LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBiYWJlbCAqL1xuLyoqIEBqc3ggZXRjaC5kb20gKiovXG5cbmltcG9ydCBldGNoIGZyb20gJ2V0Y2gnO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBXZWxjb21lVmlldyB7XG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICAgIGV0Y2guaW5pdGlhbGl6ZSh0aGlzKTtcblxuICAgIHRoaXMuZWxlbWVudC5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIGV2ZW50ID0+IHtcbiAgICAgIGNvbnN0IGxpbmsgPSBldmVudC50YXJnZXQuY2xvc2VzdCgnYScpO1xuICAgICAgaWYgKGxpbmsgJiYgbGluay5kYXRhc2V0LmV2ZW50KSB7XG4gICAgICAgIHRoaXMucHJvcHMucmVwb3J0ZXJQcm94eS5zZW5kRXZlbnQoXG4gICAgICAgICAgYGNsaWNrZWQtd2VsY29tZS0ke2xpbmsuZGF0YXNldC5ldmVudH0tbGlua2BcbiAgICAgICAgKTtcbiAgICAgIH1cbiAgICB9KTtcbiAgfVxuXG4gIGRpZENoYW5nZVNob3dPblN0YXJ0dXAoKSB7XG4gICAgYXRvbS5jb25maWcuc2V0KCd3ZWxjb21lLnNob3dPblN0YXJ0dXAnLCB0aGlzLmNoZWNrZWQpO1xuICB9XG5cbiAgdXBkYXRlKCkge31cblxuICBzZXJpYWxpemUoKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGRlc2VyaWFsaXplcjogJ1dlbGNvbWVWaWV3JyxcbiAgICAgIHVyaTogdGhpcy5wcm9wcy51cmlcbiAgICB9O1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cIndlbGNvbWVcIj5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJ3ZWxjb21lLWNvbnRhaW5lclwiPlxuICAgICAgICAgIDxoZWFkZXIgY2xhc3NOYW1lPVwid2VsY29tZS1oZWFkZXJcIj5cbiAgICAgICAgICAgIDxhIGhyZWY9XCJodHRwczovL2F0b20uaW8vXCI+XG4gICAgICAgICAgICAgIDxzdmdcbiAgICAgICAgICAgICAgICBjbGFzc05hbWU9XCJ3ZWxjb21lLWxvZ29cIlxuICAgICAgICAgICAgICAgIHdpZHRoPVwiMzMwcHhcIlxuICAgICAgICAgICAgICAgIGhlaWdodD1cIjY4cHhcIlxuICAgICAgICAgICAgICAgIHZpZXdCb3g9XCIwIDAgMzMwIDY4XCJcbiAgICAgICAgICAgICAgICB2ZXJzaW9uPVwiMS4xXCJcbiAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICAgIDxnXG4gICAgICAgICAgICAgICAgICBzdHJva2U9XCJub25lXCJcbiAgICAgICAgICAgICAgICAgIHN0cm9rZS13aWR0aD1cIjFcIlxuICAgICAgICAgICAgICAgICAgZmlsbD1cIm5vbmVcIlxuICAgICAgICAgICAgICAgICAgZmlsbC1ydWxlPVwiZXZlbm9kZFwiXG4gICAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICAgICAgPGcgdHJhbnNmb3JtPVwidHJhbnNsYXRlKDIuMDAwMDAwLCAxLjAwMDAwMClcIj5cbiAgICAgICAgICAgICAgICAgICAgPGdcbiAgICAgICAgICAgICAgICAgICAgICB0cmFuc2Zvcm09XCJ0cmFuc2xhdGUoOTYuMDAwMDAwLCA4LjAwMDAwMClcIlxuICAgICAgICAgICAgICAgICAgICAgIGZpbGw9XCJjdXJyZW50Q29sb3JcIlxuICAgICAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgICAgICAgPHBhdGggZD1cIk0xODUuNDk4LDMuMzk5IEMxODUuNDk4LDIuNDE3IDE4Ni4zNCwxLjU3MyAxODcuMzI0LDEuNTczIEwxODcuNjc0LDEuNTczIEMxODguNDQ3LDEuNTczIDE4OS4wMSwxLjk5NSAxODkuNSwyLjYyOCBMMjA4LjY3NiwzMC44NjIgTDIyNy44NTIsMi42MjggQzIyOC4yNzIsMS45OTUgMjI4LjkwNSwxLjU3MyAyMjkuNjc2LDEuNTczIEwyMzAuMDI4LDEuNTczIEMyMzEuMDEsMS41NzMgMjMxLjg1NCwyLjQxNyAyMzEuODU0LDMuMzk5IEwyMzEuODU0LDQ5LjQwMyBDMjMxLjg1NCw1MC4zODcgMjMxLjAxLDUxLjIzMSAyMzAuMDI4LDUxLjIzMSBDMjI5LjA0NCw1MS4yMzEgMjI4LjIwMiw1MC4zODcgMjI4LjIwMiw0OS40MDMgTDIyOC4yMDIsOC4yNDYgTDIxMC4xNTEsMzQuNTE1IEMyMDkuNzI5LDM1LjE0OCAyMDkuMjM3LDM1LjQyOCAyMDguNjA2LDM1LjQyOCBDMjA3Ljk3MywzNS40MjggMjA3LjQ4MSwzNS4xNDggMjA3LjA2MSwzNC41MTUgTDE4OS4wMSw4LjI0NiBMMTg5LjAxLDQ5LjQ3NSBDMTg5LjAxLDUwLjQ1NyAxODguMjM3LDUxLjIzMSAxODcuMjU0LDUxLjIzMSBDMTg2LjI3LDUxLjIzMSAxODUuNDk4LDUwLjQ1OCAxODUuNDk4LDQ5LjQ3NSBMMTg1LjQ5OCwzLjM5OSBMMTg1LjQ5OCwzLjM5OSBaXCIgLz5cbiAgICAgICAgICAgICAgICAgICAgICA8cGF0aCBkPVwiTTExMy4wODYsMjYuNTA3IEwxMTMuMDg2LDI2LjM2NyBDMTEzLjA4NiwxMi45NTIgMTIyLjk5LDAuOTQxIDEzNy44ODEsMC45NDEgQzE1Mi43NywwLjk0MSAxNjIuNTMzLDEyLjgxMSAxNjIuNTMzLDI2LjIyNSBMMTYyLjUzMywyNi4zNjcgQzE2Mi41MzMsMzkuNzgyIDE1Mi42MjksNTEuNzkyIDEzNy43NCw1MS43OTIgQzEyMi44NSw1MS43OTIgMTEzLjA4NiwzOS45MjMgMTEzLjA4NiwyNi41MDcgTTE1OC43NCwyNi41MDcgTDE1OC43NCwyNi4zNjcgQzE1OC43NCwxNC4yMTYgMTQ5Ljg5LDQuMjQyIDEzNy43NCw0LjI0MiBDMTI1LjU4OCw0LjI0MiAxMTYuODc5LDE0LjA3NSAxMTYuODc5LDI2LjIyNSBMMTE2Ljg3OSwyNi4zNjcgQzExNi44NzksMzguNTE4IDEyNS43MjksNDguNDkxIDEzNy44ODEsNDguNDkxIEMxNTAuMDMxLDQ4LjQ5MSAxNTguNzQsMzguNjU4IDE1OC43NCwyNi41MDdcIiAvPlxuICAgICAgICAgICAgICAgICAgICAgIDxwYXRoIGQ9XCJNNzYuNzA1LDUuMTU1IEw2MC45NzIsNS4xNTUgQzYwLjA2LDUuMTU1IDU5LjI4Nyw0LjM4NCA1OS4yODcsMy40NjkgQzU5LjI4NywyLjU1NiA2MC4wNTksMS43ODMgNjAuOTcyLDEuNzgzIEw5Ni4wOTIsMS43ODMgQzk3LjAwNCwxLjc4MyA5Ny43NzgsMi41NTUgOTcuNzc4LDMuNDY5IEM5Ny43NzgsNC4zODMgOTcuMDA1LDUuMTU1IDk2LjA5Miw1LjE1NSBMODAuMzU4LDUuMTU1IEw4MC4zNTgsNDkuNDA1IEM4MC4zNTgsNTAuMzg3IDc5LjUxNiw1MS4yMzEgNzguNTMyLDUxLjIzMSBDNzcuNTUsNTEuMjMxIDc2LjcwNiw1MC4zODcgNzYuNzA2LDQ5LjQwNSBMNzYuNzA2LDUuMTU1IEw3Ni43MDUsNS4xNTUgWlwiIC8+XG4gICAgICAgICAgICAgICAgICAgICAgPHBhdGggZD1cIk0wLjI5MSw0OC41NjIgTDIxLjI5MSwzLjA1IEMyMS43ODMsMS45OTUgMjIuNDg1LDEuMjkyIDIzLjc1LDEuMjkyIEwyMy44OTEsMS4yOTIgQzI1LjE1NSwxLjI5MiAyNS44NTgsMS45OTUgMjYuMzQ4LDMuMDUgTDQ3LjI3OSw0OC40MjEgQzQ3LjQ5LDQ4Ljg0MyA0Ny41Niw0OS4xOTQgNDcuNTYsNDkuNTQ2IEM0Ny41Niw1MC40NTggNDYuNzg4LDUxLjIzMSA0NS44MDMsNTEuMjMxIEM0NC45NjEsNTEuMjMxIDQ0LjMyOSw1MC41OTkgNDMuOTc4LDQ5LjgyNiBMMzguMjE5LDM3LjE4MyBMOS4yMSwzNy4xODMgTDMuNDUsNDkuODk3IEMzLjA5OSw1MC43MzkgMi41MzgsNTEuMjMxIDEuNjk0LDUxLjIzMSBDMC43ODEsNTEuMjMxIDAuMDA4LDUwLjUyOSAwLjAwOCw0OS42ODUgQzAuMDA5LDQ5LjQwNCAwLjA4LDQ4Ljk4MyAwLjI5MSw0OC41NjIgTDAuMjkxLDQ4LjU2MiBaIE0zNi42NzMsMzMuODgyIEwyMy43NDksNS40MzcgTDEwLjc1NSwzMy44ODIgTDM2LjY3MywzMy44ODIgTDM2LjY3MywzMy44ODIgWlwiIC8+XG4gICAgICAgICAgICAgICAgICAgIDwvZz5cbiAgICAgICAgICAgICAgICAgICAgPGc+XG4gICAgICAgICAgICAgICAgICAgICAgPHBhdGhcbiAgICAgICAgICAgICAgICAgICAgICAgIGQ9XCJNNDAuMzYzLDMyLjA3NSBDNDAuODc0LDM0LjQ0IDM5LjM3MSwzNi43NyAzNy4wMDYsMzcuMjgyIEMzNC42NDEsMzcuNzkzIDMyLjMxMSwzNi4yOSAzMS43OTksMzMuOTI1IEMzMS4yODksMzEuNTYgMzIuNzkxLDI5LjIzIDM1LjE1NiwyOC43MTggQzM3LjUyMSwyOC4yMDcgMzkuODUxLDI5LjcxIDQwLjM2MywzMi4wNzVcIlxuICAgICAgICAgICAgICAgICAgICAgICAgZmlsbD1cImN1cnJlbnRDb2xvclwiXG4gICAgICAgICAgICAgICAgICAgICAgLz5cbiAgICAgICAgICAgICAgICAgICAgICA8cGF0aFxuICAgICAgICAgICAgICAgICAgICAgICAgZD1cIk00OC41NzgsMjguNjE1IEM1Ni44NTEsNDUuNTg3IDU4LjU1OCw2MS41ODEgNTIuMjg4LDY0Ljc3OCBDNDUuODIyLDY4LjA3NiAzMy4zMjYsNTYuNTIxIDI0LjM3NSwzOC45NjkgQzE1LjQyNCwyMS40MTggMTMuNDA5LDQuNTE4IDE5Ljg3NCwxLjIyMSBDMjIuNjg5LC0wLjIxNiAyNi42NDgsMS4xNjYgMzAuOTU5LDQuNjI5XCJcbiAgICAgICAgICAgICAgICAgICAgICAgIHN0cm9rZT1cImN1cnJlbnRDb2xvclwiXG4gICAgICAgICAgICAgICAgICAgICAgICBzdHJva2Utd2lkdGg9XCIzLjA4XCJcbiAgICAgICAgICAgICAgICAgICAgICAgIHN0cm9rZS1saW5lY2FwPVwicm91bmRcIlxuICAgICAgICAgICAgICAgICAgICAgIC8+XG4gICAgICAgICAgICAgICAgICAgICAgPHBhdGhcbiAgICAgICAgICAgICAgICAgICAgICAgIGQ9XCJNNy42NCwzOS40NSBDMi44MDYsMzYuOTQgLTAuMDA5LDMzLjkxNSAwLjE1NCwzMC43OSBDMC41MzEsMjMuNTQyIDE2Ljc4NywxOC40OTcgMzYuNDYyLDE5LjUyIEM1Ni4xMzcsMjAuNTQ0IDcxLjc4MSwyNy4yNDkgNzEuNDA0LDM0LjQ5NyBDNzEuMjQxLDM3LjYyMiA2OC4xMjcsNDAuMzM4IDYzLjA2LDQyLjMzM1wiXG4gICAgICAgICAgICAgICAgICAgICAgICBzdHJva2U9XCJjdXJyZW50Q29sb3JcIlxuICAgICAgICAgICAgICAgICAgICAgICAgc3Ryb2tlLXdpZHRoPVwiMy4wOFwiXG4gICAgICAgICAgICAgICAgICAgICAgICBzdHJva2UtbGluZWNhcD1cInJvdW5kXCJcbiAgICAgICAgICAgICAgICAgICAgICAvPlxuICAgICAgICAgICAgICAgICAgICAgIDxwYXRoXG4gICAgICAgICAgICAgICAgICAgICAgICBkPVwiTTI4LjgyOCw1OS4zNTQgQzIzLjU0NSw2My4xNjggMTguODQzLDY0LjU2MSAxNS45MDIsNjIuNjUzIEM5LjgxNCw1OC43MDIgMTMuNTcyLDQyLjEwMiAyNC4yOTYsMjUuNTc1IEMzNS4wMiw5LjA0OCA0OC42NDksLTEuMTQ5IDU0LjczNiwyLjgwMyBDNTcuNTY2LDQuNjM5IDU4LjI2OSw5LjIwOCA1Ny4xMzMsMTUuMjMyXCJcbiAgICAgICAgICAgICAgICAgICAgICAgIHN0cm9rZT1cImN1cnJlbnRDb2xvclwiXG4gICAgICAgICAgICAgICAgICAgICAgICBzdHJva2Utd2lkdGg9XCIzLjA4XCJcbiAgICAgICAgICAgICAgICAgICAgICAgIHN0cm9rZS1saW5lY2FwPVwicm91bmRcIlxuICAgICAgICAgICAgICAgICAgICAgIC8+XG4gICAgICAgICAgICAgICAgICAgIDwvZz5cbiAgICAgICAgICAgICAgICAgIDwvZz5cbiAgICAgICAgICAgICAgICA8L2c+XG4gICAgICAgICAgICAgIDwvc3ZnPlxuICAgICAgICAgICAgICA8aDEgY2xhc3NOYW1lPVwid2VsY29tZS10aXRsZVwiPlxuICAgICAgICAgICAgICAgIEEgaGFja2FibGUgdGV4dCBlZGl0b3IgZm9yIHRoZSAyMTxzdXA+c3Q8L3N1cD4gQ2VudHVyeVxuICAgICAgICAgICAgICA8L2gxPlxuICAgICAgICAgICAgPC9hPlxuICAgICAgICAgIDwvaGVhZGVyPlxuXG4gICAgICAgICAgPHNlY3Rpb24gY2xhc3NOYW1lPVwid2VsY29tZS1wYW5lbFwiPlxuICAgICAgICAgICAgPHA+Rm9yIGhlbHAsIHBsZWFzZSB2aXNpdDwvcD5cbiAgICAgICAgICAgIDx1bD5cbiAgICAgICAgICAgICAgPGxpPlxuICAgICAgICAgICAgICAgIFRoZXsnICd9XG4gICAgICAgICAgICAgICAgPGFcbiAgICAgICAgICAgICAgICAgIGhyZWY9XCJodHRwczovL3d3dy5hdG9tLmlvL2RvY3NcIlxuICAgICAgICAgICAgICAgICAgZGF0YXNldD17eyBldmVudDogJ2F0b20tZG9jcycgfX1cbiAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgICBBdG9tIGRvY3NcbiAgICAgICAgICAgICAgICA8L2E+eycgJ31cbiAgICAgICAgICAgICAgICBmb3IgR3VpZGVzIGFuZCB0aGUgQVBJIHJlZmVyZW5jZS5cbiAgICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgICAgPGxpPlxuICAgICAgICAgICAgICAgIFRoZSBBdG9tIGZvcnVtIGF0eycgJ31cbiAgICAgICAgICAgICAgICA8YSBocmVmPVwiaHR0cDovL2Rpc2N1c3MuYXRvbS5pb1wiIGRhdGFzZXQ9e3sgZXZlbnQ6ICdkaXNjdXNzJyB9fT5cbiAgICAgICAgICAgICAgICAgIGRpc2N1c3MuYXRvbS5pb1xuICAgICAgICAgICAgICAgIDwvYT5cbiAgICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgICAgPGxpPlxuICAgICAgICAgICAgICAgIFRoZXsnICd9XG4gICAgICAgICAgICAgICAgPGFcbiAgICAgICAgICAgICAgICAgIGhyZWY9XCJodHRwczovL2dpdGh1Yi5jb20vYXRvbVwiXG4gICAgICAgICAgICAgICAgICBkYXRhc2V0PXt7IGV2ZW50OiAnYXRvbS1vcmcnIH19XG4gICAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICAgICAgQXRvbSBvcmdcbiAgICAgICAgICAgICAgICA8L2E+XG4gICAgICAgICAgICAgICAgLiBUaGlzIGlzIHdoZXJlIGFsbCBHaXRIdWItY3JlYXRlZCBBdG9tIHBhY2thZ2VzIGNhbiBiZSBmb3VuZC5cbiAgICAgICAgICAgICAgPC9saT5cbiAgICAgICAgICAgIDwvdWw+XG4gICAgICAgICAgPC9zZWN0aW9uPlxuXG4gICAgICAgICAgPHNlY3Rpb24gY2xhc3NOYW1lPVwid2VsY29tZS1wYW5lbFwiPlxuICAgICAgICAgICAgPGxhYmVsPlxuICAgICAgICAgICAgICA8aW5wdXRcbiAgICAgICAgICAgICAgICBjbGFzc05hbWU9XCJpbnB1dC1jaGVja2JveFwiXG4gICAgICAgICAgICAgICAgdHlwZT1cImNoZWNrYm94XCJcbiAgICAgICAgICAgICAgICBjaGVja2VkPXthdG9tLmNvbmZpZy5nZXQoJ3dlbGNvbWUuc2hvd09uU3RhcnR1cCcpfVxuICAgICAgICAgICAgICAgIG9uY2hhbmdlPXt0aGlzLmRpZENoYW5nZVNob3dPblN0YXJ0dXB9XG4gICAgICAgICAgICAgIC8+XG4gICAgICAgICAgICAgIFNob3cgV2VsY29tZSBHdWlkZSB3aGVuIG9wZW5pbmcgQXRvbVxuICAgICAgICAgICAgPC9sYWJlbD5cbiAgICAgICAgICA8L3NlY3Rpb24+XG5cbiAgICAgICAgICA8Zm9vdGVyIGNsYXNzTmFtZT1cIndlbGNvbWUtZm9vdGVyXCI+XG4gICAgICAgICAgICA8YSBocmVmPVwiaHR0cHM6Ly9hdG9tLmlvL1wiIGRhdGFzZXQ9e3sgZXZlbnQ6ICdmb290ZXItYXRvbS1pbycgfX0+XG4gICAgICAgICAgICAgIGF0b20uaW9cbiAgICAgICAgICAgIDwvYT57JyAnfVxuICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwidGV4dC1zdWJ0bGVcIj7Dlzwvc3Bhbj57JyAnfVxuICAgICAgICAgICAgPGFcbiAgICAgICAgICAgICAgY2xhc3NOYW1lPVwiaWNvbiBpY29uLW9jdG9mYWNlXCJcbiAgICAgICAgICAgICAgaHJlZj1cImh0dHBzOi8vZ2l0aHViLmNvbS9cIlxuICAgICAgICAgICAgICBkYXRhc2V0PXt7IGV2ZW50OiAnZm9vdGVyLW9jdG9jYXQnIH19XG4gICAgICAgICAgICAvPlxuICAgICAgICAgIDwvZm9vdGVyPlxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICBnZXRVUkkoKSB7XG4gICAgcmV0dXJuIHRoaXMucHJvcHMudXJpO1xuICB9XG5cbiAgZ2V0VGl0bGUoKSB7XG4gICAgcmV0dXJuICdXZWxjb21lJztcbiAgfVxuXG4gIGlzRXF1YWwob3RoZXIpIHtcbiAgICByZXR1cm4gb3RoZXIgaW5zdGFuY2VvZiBXZWxjb21lVmlldztcbiAgfVxufVxuIl19