Object.defineProperty(exports, '__esModule', {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _reporterProxy = require('./reporter-proxy');

var _reporterProxy2 = _interopRequireDefault(_reporterProxy);

var WelcomeView = undefined,
    GuideView = undefined,
    ConsentView = undefined;

var WELCOME_URI = 'atom://welcome/welcome';
var GUIDE_URI = 'atom://welcome/guide';
var CONSENT_URI = 'atom://welcome/consent';

var WelcomePackage = (function () {
  function WelcomePackage() {
    _classCallCheck(this, WelcomePackage);

    this.reporterProxy = new _reporterProxy2['default']();
  }

  _createClass(WelcomePackage, [{
    key: 'activate',
    value: _asyncToGenerator(function* () {
      var _this = this;

      this.subscriptions = new _atom.CompositeDisposable();

      this.subscriptions.add(atom.workspace.addOpener(function (filePath) {
        if (filePath === WELCOME_URI) {
          return _this.createWelcomeView({ uri: WELCOME_URI });
        }
      }));

      this.subscriptions.add(atom.workspace.addOpener(function (filePath) {
        if (filePath === GUIDE_URI) {
          return _this.createGuideView({ uri: GUIDE_URI });
        }
      }));

      this.subscriptions.add(atom.workspace.addOpener(function (filePath) {
        if (filePath === CONSENT_URI) {
          return _this.createConsentView({ uri: CONSENT_URI });
        }
      }));

      this.subscriptions.add(atom.commands.add('atom-workspace', 'welcome:show', function () {
        return _this.show();
      }));

      if (atom.config.get('core.telemetryConsent') === 'undecided') {
        yield atom.workspace.open(CONSENT_URI);
      }

      if (atom.config.get('welcome.showOnStartup')) {
        yield this.show();
        this.reporterProxy.sendEvent('show-on-initial-load');
      }
    })
  }, {
    key: 'show',
    value: function show() {
      return Promise.all([atom.workspace.open(WELCOME_URI, { split: 'left' }), atom.workspace.open(GUIDE_URI, { split: 'right' })]);
    }
  }, {
    key: 'consumeReporter',
    value: function consumeReporter(reporter) {
      return this.reporterProxy.setReporter(reporter);
    }
  }, {
    key: 'deactivate',
    value: function deactivate() {
      this.subscriptions.dispose();
    }
  }, {
    key: 'createWelcomeView',
    value: function createWelcomeView(state) {
      if (WelcomeView == null) WelcomeView = require('./welcome-view');
      return new WelcomeView(_extends({ reporterProxy: this.reporterProxy }, state));
    }
  }, {
    key: 'createGuideView',
    value: function createGuideView(state) {
      if (GuideView == null) GuideView = require('./guide-view');
      return new GuideView(_extends({ reporterProxy: this.reporterProxy }, state));
    }
  }, {
    key: 'createConsentView',
    value: function createConsentView(state) {
      if (ConsentView == null) ConsentView = require('./consent-view');
      return new ConsentView(_extends({ reporterProxy: this.reporterProxy }, state));
    }
  }]);

  return WelcomePackage;
})();

exports['default'] = WelcomePackage;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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