(function() {
  var CopyDialog, Dialog, fs, path, repoForPath,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  path = require('path');

  fs = require('fs-plus');

  Dialog = require('./dialog');

  repoForPath = require("./helpers").repoForPath;

  module.exports = CopyDialog = (function(superClass) {
    extend(CopyDialog, superClass);

    function CopyDialog(initialPath, arg) {
      this.initialPath = initialPath;
      this.onCopy = arg.onCopy;
      CopyDialog.__super__.constructor.call(this, {
        prompt: 'Enter the new path for the duplicate.',
        initialPath: atom.project.relativize(this.initialPath),
        select: true,
        iconClass: 'icon-arrow-right'
      });
    }

    CopyDialog.prototype.onConfirm = function(newPath) {
      var activeEditor, error, repo, rootPath;
      newPath = newPath.replace(/\s+$/, '');
      if (!path.isAbsolute(newPath)) {
        rootPath = atom.project.relativizePath(this.initialPath)[0];
        newPath = path.join(rootPath, newPath);
        if (!newPath) {
          return;
        }
      }
      if (this.initialPath === newPath) {
        this.close();
        return;
      }
      if (!this.isNewPathValid(newPath)) {
        this.showError("'" + newPath + "' already exists.");
        return;
      }
      activeEditor = atom.workspace.getActiveTextEditor();
      if ((activeEditor != null ? activeEditor.getPath() : void 0) !== this.initialPath) {
        activeEditor = null;
      }
      try {
        if (fs.isDirectorySync(this.initialPath)) {
          fs.copySync(this.initialPath, newPath);
          if (typeof this.onCopy === "function") {
            this.onCopy({
              initialPath: this.initialPath,
              newPath: newPath
            });
          }
        } else {
          fs.copy(this.initialPath, newPath, (function(_this) {
            return function() {
              if (typeof _this.onCopy === "function") {
                _this.onCopy({
                  initialPath: _this.initialPath,
                  newPath: newPath
                });
              }
              return atom.workspace.open(newPath, {
                activatePane: true,
                initialLine: activeEditor != null ? activeEditor.getLastCursor().getBufferRow() : void 0,
                initialColumn: activeEditor != null ? activeEditor.getLastCursor().getBufferColumn() : void 0
              });
            };
          })(this));
        }
        if (repo = repoForPath(newPath)) {
          repo.getPathStatus(this.initialPath);
          repo.getPathStatus(newPath);
        }
        return this.close();
      } catch (error1) {
        error = error1;
        return this.showError(error.message + ".");
      }
    };

    CopyDialog.prototype.isNewPathValid = function(newPath) {
      var newStat, oldStat;
      try {
        oldStat = fs.statSync(this.initialPath);
        newStat = fs.statSync(newPath);
        return this.initialPath.toLowerCase() === newPath.toLowerCase() && oldStat.dev === newStat.dev && oldStat.ino === newStat.ino;
      } catch (error1) {
        return true;
      }
    };

    return CopyDialog;

  })(Dialog);

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
