Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var PackagePanelView = (function () {
  function PackagePanelView(_ref) {
    var _this = this;

    var title = _ref.title;

    _classCallCheck(this, PackagePanelView);

    this.title = title;
    _etch2['default'].initialize(this);

    var clickHandler = function clickHandler(event) {
      var target = event.target.closest('a.package');
      if (target) {
        atom.workspace.open('atom://config/packages/' + target.dataset['package']);
      }
    };
    this.element.addEventListener('click', clickHandler);
    this.disposable = new _atom.Disposable(function () {
      _this.element.removeEventListener('click', clickHandler);
    });
  }

  _createClass(PackagePanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposable.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            this.title
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom(
              'div',
              { className: 'text-info', ref: 'summary' },
              'Loading…'
            ),
            _etch2['default'].dom('ul', { className: 'list-group', ref: 'list' })
          )
        )
      );
    }
  }, {
    key: 'addPackages',
    value: function addPackages(packages, timeKey) {
      for (var pack of packages) {
        this.addPackage(pack, timeKey);
      }
    }
  }, {
    key: 'addPackage',
    value: function addPackage(pack, timeKey) {
      var li = document.createElement('div');
      li.classList.add('list-item');

      var a = document.createElement('a');
      a.classList.add('inline-block', 'package');
      a.dataset['package'] = pack.name;
      a.textContent = pack.name;
      li.appendChild(a);

      var line = document.createElement('span');
      line.classList.add('timecop-line');
      li.appendChild(line);

      var timeSpan = document.createElement('span');
      timeSpan.classList.add('inline-block', pack[timeKey] > 25 ? 'highlight-error' : 'highlight-warning');
      timeSpan.textContent = pack[timeKey] + 'ms';
      li.appendChild(timeSpan);

      this.refs.list.appendChild(li);
    }
  }]);

  return PackagePanelView;
})();

exports['default'] = PackagePanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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