Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _humanizePlus = require('humanize-plus');

var _humanizePlus2 = _interopRequireDefault(_humanizePlus);

var _symbolsView = require('./symbols-view');

var _symbolsView2 = _interopRequireDefault(_symbolsView);

var _tagReader = require('./tag-reader');

var _tagReader2 = _interopRequireDefault(_tagReader);

var _getTagsFile = require('./get-tags-file');

var _getTagsFile2 = _interopRequireDefault(_getTagsFile);

var ProjectView = (function (_SymbolsView) {
  _inherits(ProjectView, _SymbolsView);

  function ProjectView(stack) {
    _classCallCheck(this, ProjectView);

    _get(Object.getPrototypeOf(ProjectView.prototype), 'constructor', this).call(this, stack, 'Project has no tags file or it is empty', 10);
    this.reloadTags = true;
  }

  _createClass(ProjectView, [{
    key: 'destroy',
    value: function destroy() {
      this.stopTask();
      this.unwatchTagsFiles();
      return _get(Object.getPrototypeOf(ProjectView.prototype), 'destroy', this).call(this);
    }
  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.panel.isVisible()) {
        this.cancel();
      } else {
        this.populate();
        this.attach();
      }
    }
  }, {
    key: 'populate',
    value: _asyncToGenerator(function* () {
      var _this = this;

      if (this.tags) {
        yield this.selectListView.update({ items: this.tags });
      }

      if (this.reloadTags) {
        this.reloadTags = false;
        this.startTask();

        if (this.tags) {
          yield this.selectListView.update({
            loadingMessage: 'Reloading project symbols…'
          });
        } else {
          yield* (function* () {
            yield _this.selectListView.update({
              loadingMessage: 'Loading project symbols…',
              loadingBadge: 0
            });
            var tagsRead = 0;
            _this.loadTagsTask.on('tags', function (tags) {
              tagsRead += tags.length;
              _this.selectListView.update({ loadingBadge: _humanizePlus2['default'].intComma(tagsRead) });
            });
          })();
        }
      }
    })
  }, {
    key: 'stopTask',
    value: function stopTask() {
      if (this.loadTagsTask) {
        this.loadTagsTask.terminate();
      }
    }
  }, {
    key: 'startTask',
    value: function startTask() {
      var _this2 = this;

      this.stopTask();

      this.loadTagsTask = _tagReader2['default'].getAllTags(function (tags) {
        _this2.tags = tags;
        _this2.reloadTags = _this2.tags.length === 0;
        _this2.selectListView.update({
          loadingMessage: null,
          loadingBadge: null,
          items: _this2.tags
        });
      });

      this.watchTagsFiles();
    }
  }, {
    key: 'watchTagsFiles',
    value: function watchTagsFiles() {
      var _this3 = this;

      this.unwatchTagsFiles();

      this.tagsFileSubscriptions = new _atom.CompositeDisposable();
      var reloadTags = function reloadTags() {
        _this3.reloadTags = true;
        _this3.watchTagsFiles();
      };

      for (var projectPath of Array.from(atom.project.getPaths())) {
        var tagsFilePath = (0, _getTagsFile2['default'])(projectPath);
        if (tagsFilePath) {
          var tagsFile = new _atom.File(tagsFilePath);
          this.tagsFileSubscriptions.add(tagsFile.onDidChange(reloadTags));
          this.tagsFileSubscriptions.add(tagsFile.onDidDelete(reloadTags));
          this.tagsFileSubscriptions.add(tagsFile.onDidRename(reloadTags));
        }
      }
    }
  }, {
    key: 'unwatchTagsFiles',
    value: function unwatchTagsFiles() {
      if (this.tagsFileSubscriptions) {
        this.tagsFileSubscriptions.dispose();
      }
      this.tagsFileSubscriptions = null;
    }
  }]);

  return ProjectView;
})(_symbolsView2['default']);

exports['default'] = ProjectView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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