Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _symbolsView = require('./symbols-view');

var _symbolsView2 = _interopRequireDefault(_symbolsView);

var _tagGenerator = require('./tag-generator');

var _tagGenerator2 = _interopRequireDefault(_tagGenerator);

var _fuzzaldrin = require('fuzzaldrin');

var FileView = (function (_SymbolsView) {
  _inherits(FileView, _SymbolsView);

  function FileView(stack) {
    var _this = this;

    _classCallCheck(this, FileView);

    _get(Object.getPrototypeOf(FileView.prototype), 'constructor', this).call(this, stack);
    this.cachedTags = {};
    this.watchedEditors = new WeakSet();

    this.editorsSubscription = atom.workspace.observeTextEditors(function (editor) {
      if (_this.watchedEditors.has(editor)) return;

      var removeFromCache = function removeFromCache() {
        delete _this.cachedTags[editor.getPath()];
      };
      var editorSubscriptions = new _atom.CompositeDisposable();
      editorSubscriptions.add(editor.onDidChangeGrammar(removeFromCache));
      editorSubscriptions.add(editor.onDidSave(removeFromCache));
      editorSubscriptions.add(editor.onDidChangePath(removeFromCache));
      editorSubscriptions.add(editor.getBuffer().onDidReload(removeFromCache));
      editorSubscriptions.add(editor.getBuffer().onDidDestroy(removeFromCache));
      editor.onDidDestroy(function () {
        _this.watchedEditors['delete'](editor);
        editorSubscriptions.dispose();
      });

      _this.watchedEditors.add(editor);
    });
  }

  _createClass(FileView, [{
    key: 'destroy',
    value: function destroy() {
      this.editorsSubscription.dispose();
      return _get(Object.getPrototypeOf(FileView.prototype), 'destroy', this).call(this);
    }
  }, {
    key: 'elementForItem',
    value: function elementForItem(_ref) {
      var position = _ref.position;
      var name = _ref.name;

      // Style matched characters in search results
      var matches = (0, _fuzzaldrin.match)(name, this.selectListView.getFilterQuery());

      var li = document.createElement('li');
      li.classList.add('two-lines');

      var primaryLine = document.createElement('div');
      primaryLine.classList.add('primary-line');
      primaryLine.appendChild(_symbolsView2['default'].highlightMatches(this, name, matches));
      li.appendChild(primaryLine);

      var secondaryLine = document.createElement('div');
      secondaryLine.classList.add('secondary-line');
      secondaryLine.textContent = 'Line ' + (position.row + 1);
      li.appendChild(secondaryLine);

      return li;
    }
  }, {
    key: 'didChangeSelection',
    value: function didChangeSelection(item) {
      if (atom.config.get('symbols-view.quickJumpToFileSymbol') && item) {
        this.openTag(item);
      }
    }
  }, {
    key: 'didCancelSelection',
    value: _asyncToGenerator(function* () {
      yield this.cancel();
      var editor = this.getEditor();
      if (this.initialState && editor) {
        this.deserializeEditorState(editor, this.initialState);
      }
      this.initialState = null;
    })
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      if (this.panel.isVisible()) {
        yield this.cancel();
      }
      var filePath = this.getPath();
      if (filePath) {
        var editor = this.getEditor();
        if (atom.config.get('symbols-view.quickJumpToFileSymbol') && editor) {
          this.initialState = this.serializeEditorState(editor);
        }
        this.populate(filePath);
        this.attach();
      }
    })
  }, {
    key: 'serializeEditorState',
    value: function serializeEditorState(editor) {
      var editorElement = atom.views.getView(editor);
      var scrollTop = editorElement.getScrollTop();

      return {
        bufferRanges: editor.getSelectedBufferRanges(),
        scrollTop: scrollTop
      };
    }
  }, {
    key: 'deserializeEditorState',
    value: function deserializeEditorState(editor, _ref2) {
      var bufferRanges = _ref2.bufferRanges;
      var scrollTop = _ref2.scrollTop;

      var editorElement = atom.views.getView(editor);

      editor.setSelectedBufferRanges(bufferRanges);
      editorElement.setScrollTop(scrollTop);
    }
  }, {
    key: 'getEditor',
    value: function getEditor() {
      return atom.workspace.getActiveTextEditor();
    }
  }, {
    key: 'getPath',
    value: function getPath() {
      if (this.getEditor()) {
        return this.getEditor().getPath();
      }
      return undefined;
    }
  }, {
    key: 'getScopeName',
    value: function getScopeName() {
      if (this.getEditor() && this.getEditor().getGrammar()) {
        return this.getEditor().getGrammar().scopeName;
      }
      return undefined;
    }
  }, {
    key: 'populate',
    value: _asyncToGenerator(function* (filePath) {
      var tags = this.cachedTags[filePath];
      if (tags) {
        yield this.selectListView.update({ items: tags });
      } else {
        yield this.selectListView.update({
          items: [],
          loadingMessage: 'Generating symbols…'
        });
        yield this.selectListView.update({
          items: yield this.generateTags(filePath),
          loadingMessage: null
        });
      }
    })
  }, {
    key: 'generateTags',
    value: _asyncToGenerator(function* (filePath) {
      var generator = new _tagGenerator2['default'](filePath, this.getScopeName());
      this.cachedTags[filePath] = yield generator.generate();
      return this.cachedTags[filePath];
    })
  }]);

  return FileView;
})(_symbolsView2['default']);

exports['default'] = FileView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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