Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var StyleguideSection = (function () {
  function StyleguideSection(props, children) {
    _classCallCheck(this, StyleguideSection);

    this.collapsed = props.collapsed;
    this.title = props.title;
    this.name = props.name;
    this.children = children;
    _etch2['default'].initialize(this);
    if (props.onDidInitialize) {
      props.onDidInitialize(this);
    }
  }

  _createClass(StyleguideSection, [{
    key: 'render',
    value: function render() {
      var _this = this;

      if (this.loaded) {
        var className = 'bordered';
        if (this.collapsed) {
          className += ' collapsed';
        }
        return _etch2['default'].dom(
          'section',
          { className: className, dataset: { name: this.name } },
          _etch2['default'].dom(
            'h1',
            { className: 'section-heading', onclick: function () {
                return _this.toggle();
              } },
            this.title
          ),
          this.children
        );
      } else {
        return _etch2['default'].dom(
          'section',
          { className: 'bordered collapsed', dataset: { name: this.name } },
          _etch2['default'].dom(
            'h1',
            { className: 'section-heading', onclick: function () {
                return _this.toggle();
              } },
            this.title
          )
        );
      }
    }
  }, {
    key: 'update',
    value: function update(props, children) {
      if (props.title) {
        this.title = props.title;
      }

      if (props.name) {
        this.name = props.name;
      }

      if (children) {
        this.children = children;
      }

      if (props.didExpandOrCollapseSection) {
        this.didExpandOrCollapseSection = props.onDidExpandOrCollapseSection;
      }

      return _etch2['default'].update(this);
    }
  }, {
    key: 'toggle',
    value: function toggle() {
      return this.collapsed ? this.expand() : this.collapse();
    }
  }, {
    key: 'expand',
    value: function expand() {
      this.collapsed = false;
      this.loaded = true;
      return _etch2['default'].update(this);
    }
  }, {
    key: 'collapse',
    value: function collapse() {
      this.collapsed = true;
      return _etch2['default'].update(this);
    }
  }]);

  return StyleguideSection;
})();

exports['default'] = StyleguideSection;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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