(function() {
  var SystemChecker, pathspec, spellchecker;

  spellchecker = require('spellchecker');

  pathspec = require('atom-pathspec');

  SystemChecker = (function() {
    SystemChecker.prototype.spellchecker = null;

    SystemChecker.prototype.locale = null;

    SystemChecker.prototype.enabled = true;

    SystemChecker.prototype.reason = null;

    SystemChecker.prototype.paths = null;

    function SystemChecker(locale, paths) {
      this.locale = locale;
      this.paths = paths;
    }

    SystemChecker.prototype.deactivate = function() {};

    SystemChecker.prototype.getId = function() {
      return "spell-check:" + this.locale.toLowerCase().replace("_", "-");
    };

    SystemChecker.prototype.getName = function() {
      return "System Dictionary (" + this.locale + ")";
    };

    SystemChecker.prototype.getPriority = function() {
      return 100;
    };

    SystemChecker.prototype.isEnabled = function() {
      return this.enabled;
    };

    SystemChecker.prototype.getStatus = function() {
      if (this.enabled) {
        return "Working correctly.";
      } else {
        return this.reason;
      }
    };

    SystemChecker.prototype.providesSpelling = function(args) {
      return true;
    };

    SystemChecker.prototype.providesSuggestions = function(args) {
      return true;
    };

    SystemChecker.prototype.providesAdding = function(args) {
      return false;
    };

    SystemChecker.prototype.check = function(args, text) {
      this.deferredInit();
      return this.spellchecker.checkSpellingAsync(text).then(function(incorrect) {
        return {
          invertIncorrectAsCorrect: true,
          incorrect: incorrect
        };
      });
    };

    SystemChecker.prototype.suggest = function(args, word) {
      this.deferredInit();
      return this.spellchecker.getCorrectionsForMisspelling(word);
    };

    SystemChecker.prototype.deferredInit = function() {
      var i, j, len, len1, message, noticesMode, path, ref, searchPaths, searches;
      if (this.spellchecker) {
        return;
      }
      this.spellchecker = new spellchecker.Spellchecker;
      searchPaths = [];
      if (/win32/.test(process.platform)) {
        searchPaths.push("C:\\");
      }
      ref = this.paths;
      for (i = 0, len = ref.length; i < len; i++) {
        path = ref[i];
        searchPaths.push(pathspec.getPath(path));
      }
      if (/linux/.test(process.platform)) {
        searchPaths.push("/usr/share/hunspell");
        searchPaths.push("/usr/share/myspell");
        searchPaths.push("/usr/share/myspell/dicts");
      }
      if (/darwin/.test(process.platform)) {
        searchPaths.push("/");
        searchPaths.push("/System/Library/Spelling");
      }
      searchPaths.push(spellchecker.getDictionaryPath());
      for (j = 0, len1 = searchPaths.length; j < len1; j++) {
        path = searchPaths[j];
        if (this.spellchecker.setDictionary(this.locale, path)) {
          return;
        }
      }
      this.enabled = false;
      this.reason = "Cannot load the system dictionary for `" + this.locale + "`.";
      message = "The package `spell-check` cannot load the " + "system dictionary for `" + this.locale + "`." + " See the settings for ways of changing the languages used, " + " resolving missing dictionaries, or hiding this warning.";
      searches = "\n\nThe plugin checked the following paths for dictionary files:\n* " + searchPaths.join("\n* ");
      if (/(win32|darwin)/.test(process.platform && !process.env.SPELLCHECKER_PREFER_HUNSPELL)) {
        searches = "\n\nThe plugin tried to use the system dictionaries to find the locale.";
      }
      noticesMode = atom.config.get('spell-check.noticesMode');
      if (noticesMode === "console" || noticesMode === "both") {
        console.log(this.getId(), message + searches);
      }
      if (noticesMode === "popup" || noticesMode === "both") {
        return atom.notifications.addWarning(message, {
          buttons: [
            {
              className: "btn",
              onDidClick: function() {
                return atom.workspace.open("atom://config/packages/spell-check");
              },
              text: "Settings"
            }
          ]
        });
      }
    };

    return SystemChecker;

  })();

  module.exports = SystemChecker;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
