(function() {
  var CompositeDisposable, LARGE_FILE_SIZE, SpellCheckView, spellCheckViews,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  CompositeDisposable = require('atom').CompositeDisposable;

  SpellCheckView = null;

  spellCheckViews = {};

  LARGE_FILE_SIZE = 2 * 1024 * 1024;

  module.exports = {
    activate: function() {
      var manager;
      this.subs = new CompositeDisposable;
      this.globalArgs = {
        locales: atom.config.get('spell-check.locales'),
        localePaths: atom.config.get('spell-check.localePaths'),
        useLocales: atom.config.get('spell-check.useLocales'),
        knownWords: atom.config.get('spell-check.knownWords'),
        addKnownWords: atom.config.get('spell-check.addKnownWords'),
        checkerPaths: []
      };
      manager = this.getInstance(this.globalArgs);
      this.excludedScopeRegexLists = [];
      this.subs.add(atom.config.observe('spell-check.excludedScopes', (function(_this) {
        return function(excludedScopes) {
          _this.excludedScopeRegexLists = excludedScopes.map(function(excludedScope) {
            var className, i, len, ref, results;
            ref = excludedScope.split(/\s+/)[0].split('.');
            results = [];
            for (i = 0, len = ref.length; i < len; i++) {
              className = ref[i];
              if (className) {
                results.push(new RegExp("\\b" + className + "\\b"));
              }
            }
            return results;
          });
          return _this.updateViews();
        };
      })(this)));
      this.subs.add(atom.config.onDidChange('spell-check.locales', (function(_this) {
        return function(arg) {
          var newValue, oldValue;
          newValue = arg.newValue, oldValue = arg.oldValue;
          _this.globalArgs.locales = newValue;
          return manager.setGlobalArgs(_this.globalArgs);
        };
      })(this)));
      this.subs.add(atom.config.onDidChange('spell-check.localePaths', (function(_this) {
        return function(arg) {
          var newValue, oldValue;
          newValue = arg.newValue, oldValue = arg.oldValue;
          _this.globalArgs.localePaths = newValue;
          return manager.setGlobalArgs(_this.globalArgs);
        };
      })(this)));
      this.subs.add(atom.config.onDidChange('spell-check.useLocales', (function(_this) {
        return function(arg) {
          var newValue, oldValue;
          newValue = arg.newValue, oldValue = arg.oldValue;
          _this.globalArgs.useLocales = newValue;
          return manager.setGlobalArgs(_this.globalArgs);
        };
      })(this)));
      this.subs.add(atom.config.onDidChange('spell-check.knownWords', (function(_this) {
        return function(arg) {
          var newValue, oldValue;
          newValue = arg.newValue, oldValue = arg.oldValue;
          _this.globalArgs.knownWords = newValue;
          return manager.setGlobalArgs(_this.globalArgs);
        };
      })(this)));
      this.subs.add(atom.config.onDidChange('spell-check.addKnownWords', (function(_this) {
        return function(arg) {
          var newValue, oldValue;
          newValue = arg.newValue, oldValue = arg.oldValue;
          _this.globalArgs.addKnownWords = newValue;
          return manager.setGlobalArgs(_this.globalArgs);
        };
      })(this)));
      this.subs.add(atom.commands.add('atom-workspace', {
        'spell-check:toggle': (function(_this) {
          return function() {
            return _this.toggle();
          };
        })(this)
      }));
      this.viewsByEditor = new WeakMap;
      this.contextMenuEntries = [];
      return this.subs.add(atom.workspace.observeTextEditors((function(_this) {
        return function(editor) {
          var destroySub, editorId, spellCheckView;
          if (_this.viewsByEditor.has(editor)) {
            return;
          }
          if (editor.getBuffer().getLength() > LARGE_FILE_SIZE) {
            return;
          }
          if (SpellCheckView == null) {
            SpellCheckView = require('./spell-check-view');
          }
          spellCheckView = new SpellCheckView(editor, _this, manager);
          editorId = editor.id;
          spellCheckViews[editorId] = {
            view: spellCheckView,
            active: true,
            editor: editor
          };
          destroySub = editor.onDidDestroy(function() {
            spellCheckView.destroy();
            delete spellCheckViews[editorId];
            return _this.subs.remove(destroySub);
          });
          _this.subs.add(destroySub);
          return _this.viewsByEditor.set(editor, spellCheckView);
        };
      })(this)));
    },
    deactivate: function() {
      var editorId, ref, view;
      if ((ref = this.instance) != null) {
        ref.deactivate();
      }
      this.instance = null;
      for (editorId in spellCheckViews) {
        view = spellCheckViews[editorId].view;
        view.destroy();
      }
      spellCheckViews = {};
      this.viewsByEditor = new WeakMap;
      return this.subs.dispose();
    },
    consumeSpellCheckers: function(checkerPaths) {
      var checkerPath, i, len, ref, results;
      if (!(checkerPaths instanceof Array)) {
        checkerPaths = [checkerPaths];
      }
      results = [];
      for (i = 0, len = checkerPaths.length; i < len; i++) {
        checkerPath = checkerPaths[i];
        if (indexOf.call(this.globalArgs.checkerPaths, checkerPath) < 0) {
          if ((ref = this.instance) != null) {
            ref.addCheckerPath(checkerPath);
          }
          results.push(this.globalArgs.checkerPaths.push(checkerPath));
        } else {
          results.push(void 0);
        }
      }
      return results;
    },
    misspellingMarkersForEditor: function(editor) {
      return this.viewsByEditor.get(editor).markerLayer.getMarkers();
    },
    updateViews: function() {
      var editorId, results, view;
      results = [];
      for (editorId in spellCheckViews) {
        view = spellCheckViews[editorId];
        if (view['active']) {
          results.push(view['view'].updateMisspellings());
        } else {
          results.push(void 0);
        }
      }
      return results;
    },
    getInstance: function(globalArgs) {
      var SpellCheckerManager, checkerPath, i, len, ref;
      if (!this.instance) {
        SpellCheckerManager = require('./spell-check-manager');
        this.instance = SpellCheckerManager;
        this.instance.setGlobalArgs(globalArgs);
        ref = globalArgs.checkerPaths;
        for (i = 0, len = ref.length; i < len; i++) {
          checkerPath = ref[i];
          this.instance.addCheckerPath(checkerPath);
        }
      }
      return this.instance;
    },
    toggle: function() {
      var editorId;
      if (!atom.workspace.getActiveTextEditor()) {
        return;
      }
      editorId = atom.workspace.getActiveTextEditor().id;
      if (!spellCheckViews.hasOwnProperty(editorId)) {
        return;
      }
      if (spellCheckViews[editorId]['active']) {
        spellCheckViews[editorId]['active'] = false;
        return spellCheckViews[editorId]['view'].unsubscribeFromBuffer();
      } else {
        spellCheckViews[editorId]['active'] = true;
        return spellCheckViews[editorId]['view'].subscribeToBuffer();
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
