(function() {
  var KnownWordsChecker;

  KnownWordsChecker = (function() {
    KnownWordsChecker.prototype.enableAdd = false;

    KnownWordsChecker.prototype.spelling = null;

    KnownWordsChecker.prototype.checker = null;

    function KnownWordsChecker(knownWords) {
      var spellingManager;
      spellingManager = require("spelling-manager");
      this.spelling = new spellingManager.TokenSpellingManager;
      this.checker = new spellingManager.BufferSpellingChecker(this.spelling);
      this.setKnownWords(knownWords);
    }

    KnownWordsChecker.prototype.deactivate = function() {};

    KnownWordsChecker.prototype.getId = function() {
      return "spell-check:known-words";
    };

    KnownWordsChecker.prototype.getName = function() {
      return "Known Words";
    };

    KnownWordsChecker.prototype.getPriority = function() {
      return 10;
    };

    KnownWordsChecker.prototype.isEnabled = function() {
      return this.spelling.sensitive || this.spelling.insensitive;
    };

    KnownWordsChecker.prototype.getStatus = function() {
      return "Working correctly.";
    };

    KnownWordsChecker.prototype.providesSpelling = function(args) {
      return true;
    };

    KnownWordsChecker.prototype.providesSuggestions = function(args) {
      return true;
    };

    KnownWordsChecker.prototype.providesAdding = function(args) {
      return this.enableAdd;
    };

    KnownWordsChecker.prototype.check = function(args, text) {
      var checked, i, len, ranges, token;
      ranges = [];
      checked = this.checker.check(text);
      for (i = 0, len = checked.length; i < len; i++) {
        token = checked[i];
        if (token.status === 1) {
          ranges.push({
            start: token.start,
            end: token.end
          });
        }
      }
      return {
        correct: ranges
      };
    };

    KnownWordsChecker.prototype.suggest = function(args, word) {
      return this.spelling.suggest(word);
    };

    KnownWordsChecker.prototype.getAddingTargets = function(args) {
      if (this.enableAdd) {
        return [
          {
            sensitive: false,
            label: "Add to " + this.getName()
          }
        ];
      } else {
        return [];
      }
    };

    KnownWordsChecker.prototype.add = function(args, target) {
      var c;
      c = atom.config.get('spell-check.knownWords');
      c.push(target.word);
      return atom.config.set('spell-check.knownWords', c);
    };

    KnownWordsChecker.prototype.setAddKnownWords = function(newValue) {
      return this.enableAdd = newValue;
    };

    KnownWordsChecker.prototype.setKnownWords = function(knownWords) {
      var i, ignore, len, results;
      this.spelling.sensitive = {};
      this.spelling.insensitive = {};
      if (knownWords) {
        results = [];
        for (i = 0, len = knownWords.length; i < len; i++) {
          ignore = knownWords[i];
          results.push(this.spelling.add(ignore));
        }
        return results;
      }
    };

    return KnownWordsChecker;

  })();

  module.exports = KnownWordsChecker;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
