Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var CorrectionsView = (function () {
  function CorrectionsView(editor, corrections, marker, updateTarget, updateCallback) {
    var _this = this;

    _classCallCheck(this, CorrectionsView);

    this.editor = editor;
    this.corrections = corrections;
    this.marker = marker;
    this.updateTarget = updateTarget;
    this.updateCallback = updateCallback;
    this.selectListView = new _atomSelectList2['default']({
      emptyMessage: 'No corrections',
      items: this.corrections,
      filterKeyForItem: function filterKeyForItem(item) {
        return item.label;
      },
      elementForItem: function elementForItem(item) {
        var element = document.createElement('li');
        if (item.isSuggestion) {
          // This is a word replacement suggestion.
          element.textContent = item.label;
        } else {
          // This is an operation such as add word.
          var em = document.createElement('em');
          em.textContent = item.label;
          element.appendChild(em);
        }
        return element;
      },
      didConfirmSelection: function didConfirmSelection(item) {
        _this.editor.transact(function () {
          if (item.isSuggestion) {
            // Update the buffer with the correction.
            _this.editor.setSelectedBufferRange(_this.marker.getBufferRange());
            _this.editor.insertText(item.suggestion);
          } else {
            // Build up the arguments object for this buffer and text.
            var projectPath = null;
            var relativePath = null;
            if (_this.editor && _this.editor.buffer && _this.editor.buffer.file && _this.editor.buffer.file.path) {
              var _atom$project$relativizePath = atom.project.relativizePath(_this.editor.buffer.file.path);

              var _atom$project$relativizePath2 = _slicedToArray(_atom$project$relativizePath, 2);

              projectPath = _atom$project$relativizePath2[0];
              relativePath = _atom$project$relativizePath2[1];
            }

            var args = { id: _this.id, projectPath: projectPath, relativePath: relativePath };
            // Send the "add" request to the plugin.
            item.plugin.add(args, item);
            // Update the buffer to handle the corrections.
            _this.updateCallback.bind(_this.updateTarget)();
          }
        });
        _this.destroy();
      },
      didConfirmEmptySelection: function didConfirmEmptySelection() {
        _this.destroy();
      },
      didCancelSelection: function didCancelSelection() {
        _this.destroy();
      }
    });
    this.selectListView.element.classList.add('spell-check-corrections', 'corrections', 'popover-list');
  }

  _createClass(CorrectionsView, [{
    key: 'attach',
    value: function attach() {
      var _this2 = this;

      this.previouslyFocusedElement = document.activeElement;
      this.overlayDecoration = this.editor.decorateMarker(this.marker, { type: 'overlay', item: this.selectListView });
      process.nextTick(function () {
        atom.views.readDocument(function () {
          _this2.selectListView.focus();
        });
      });
    }
  }, {
    key: 'destroy',
    value: _asyncToGenerator(function* () {
      if (!this.destroyed) {
        this.destroyed = true;
        this.overlayDecoration.destroy();
        yield this.selectListView.destroy();
        if (this.previouslyFocusedElement) {
          this.previouslyFocusedElement.focus();
          this.previouslyFocusedElement = null;
        }
      }
    })
  }]);

  return CorrectionsView;
})();

exports['default'] = CorrectionsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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