Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var SnippetsAvailable = (function () {
  function SnippetsAvailable(snippets) {
    var _this = this;

    _classCallCheck(this, SnippetsAvailable);

    this.panel = null;
    this.snippets = snippets;
    this.selectListView = new _atomSelectList2['default']({
      items: [],
      filterKeyForItem: function filterKeyForItem(snippet) {
        return snippet.searchText;
      },
      elementForItem: function elementForItem(snippet) {
        var li = document.createElement('li');
        li.classList.add('two-lines');

        var primaryLine = document.createElement('div');
        primaryLine.classList.add('primary-line');
        primaryLine.textContent = snippet.prefix;
        li.appendChild(primaryLine);

        var secondaryLine = document.createElement('div');
        secondaryLine.classList.add('secondary-line');
        secondaryLine.textContent = snippet.name;
        li.appendChild(secondaryLine);

        return li;
      },
      didConfirmSelection: function didConfirmSelection(snippet) {
        for (var cursor of _this.editor.getCursors()) {
          _this.snippets.insert(snippet.bodyText, _this.editor, cursor);
        }
        _this.cancel();
      },
      didConfirmEmptySelection: function didConfirmEmptySelection() {
        _this.cancel();
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('available-snippets');
    this.element = this.selectListView.element;
  }

  _createClass(SnippetsAvailable, [{
    key: 'toggle',
    value: _asyncToGenerator(function* (editor) {
      this.editor = editor;
      if (this.panel != null) {
        this.cancel();
      } else {
        this.selectListView.reset();
        yield this.populate();
        this.attach();
      }
    })
  }, {
    key: 'cancel',
    value: function cancel() {
      this.editor = null;

      if (this.panel != null) {
        this.panel.destroy();
        this.panel = null;
      }

      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'populate',
    value: function populate() {
      var snippets = Object.values(this.snippets.getSnippets(this.editor));
      for (var snippet of snippets) {
        snippet.searchText = _underscorePlus2['default'].compact([snippet.prefix, snippet.name]).join(' ');
      }
      return this.selectListView.update({ items: snippets });
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      this.panel = atom.workspace.addModalPanel({ item: this });
      this.selectListView.focus();
    }
  }]);

  return SnippetsAvailable;
})();

exports['default'] = SnippetsAvailable;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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