Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

function isSupported() {
  return ['win32', 'darwin'].includes(process.platform);
}

function isDefaultProtocolClient() {
  return require('electron').remote.app.isDefaultProtocolClient('atom', process.execPath, ['--uri-handler', '--']);
}

function setAsDefaultProtocolClient() {
  // This Electron API is only available on Windows and macOS. There might be some
  // hacks to make it work on Linux; see https://github.com/electron/electron/issues/6440
  return isSupported() && require('electron').remote.app.setAsDefaultProtocolClient('atom', process.execPath, ['--uri-handler', '--']);
}

var UriHandlerPanel = (function () {
  function UriHandlerPanel() {
    var _this = this;

    _classCallCheck(this, UriHandlerPanel);

    this.handleChange = this.handleChange.bind(this);
    this.handleBecomeProtocolClient = this.handleBecomeProtocolClient.bind(this);
    this.isDefaultProtocolClient = isDefaultProtocolClient();
    this.uriHistory = [];
    _etch2['default'].initialize(this);

    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }), atom.uriHandlerRegistry.onHistoryChange(function () {
      _this.uriHistory = atom.uriHandlerRegistry.getRecentlyHandledURIs();
      _etch2['default'].update(_this);
    }));
  }

  _createClass(UriHandlerPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      var schema = atom.config.getSchema('core.uriHandlerRegistration');

      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '0' },
        _etch2['default'].dom(
          'form',
          { className: 'general-panel section' },
          _etch2['default'].dom(
            'div',
            { className: 'settings-panel' },
            _etch2['default'].dom(
              'div',
              { className: 'section-container' },
              _etch2['default'].dom(
                'div',
                { className: 'block section-heading icon icon-device-desktop' },
                'URI Handling'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'text icon icon-question' },
                'These settings determine how Atom handles atom:// URIs.'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'section-body' },
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'label',
                      { className: 'control-label' },
                      _etch2['default'].dom(
                        'div',
                        { className: 'setting-title' },
                        'URI Handler Registration'
                      ),
                      _etch2['default'].dom(
                        'div',
                        { className: 'setting-description' },
                        this.renderRegistrationDescription()
                      )
                    ),
                    _etch2['default'].dom(
                      'button',
                      {
                        className: 'btn btn-primary',
                        disabled: !isSupported() || this.isDefaultProtocolClient,
                        style: { fontSize: '1.25em', display: 'block' },
                        onClick: this.handleBecomeProtocolClient
                      },
                      'Register as default atom:// protocol handler'
                    )
                  )
                ),
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'label',
                      { className: 'control-label' },
                      _etch2['default'].dom(
                        'div',
                        { className: 'setting-title' },
                        'Default Registration'
                      ),
                      _etch2['default'].dom(
                        'div',
                        { className: 'setting-description' },
                        schema.description
                      )
                    ),
                    _etch2['default'].dom(
                      'select',
                      {
                        id: 'core.uriHandlerRegistration',
                        className: 'form-control',
                        onChange: this.handleChange,
                        value: atom.config.get('core.uriHandlerRegistration')
                      },
                      schema['enum'].map(function (_ref) {
                        var description = _ref.description;
                        var value = _ref.value;
                        return _etch2['default'].dom(
                          'option',
                          { value: value },
                          description
                        );
                      })
                    )
                  )
                ),
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'label',
                      { className: 'controls-label' },
                      _etch2['default'].dom(
                        'div',
                        { className: 'setting-title' },
                        'Recent URIs'
                      )
                    ),
                    _etch2['default'].dom(
                      'table',
                      { className: 'uri-history' },
                      _etch2['default'].dom(
                        'tr',
                        null,
                        _etch2['default'].dom(
                          'th',
                          null,
                          'URI'
                        ),
                        _etch2['default'].dom(
                          'th',
                          null,
                          'Handled By'
                        )
                      ),
                      this.uriHistory.map(this.renderHistoryRow.bind(this))
                    )
                  )
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'renderHistoryRow',
    value: function renderHistoryRow(item, idx) {
      return _etch2['default'].dom(
        'tr',
        {
          key: item.id,
          className: ''
        },
        _etch2['default'].dom(
          'td',
          null,
          item.uri
        ),
        _etch2['default'].dom(
          'td',
          null,
          item.handled ? this.renderItem(item) : _etch2['default'].dom(
            'em',
            null,
            'not handled'
          )
        )
      );
    }
  }, {
    key: 'renderItem',
    value: function renderItem(item) {
      if (item.host === 'core') {
        return _etch2['default'].dom(
          'em',
          null,
          'core'
        );
      } else {
        return _etch2['default'].dom(
          'a',
          { href: 'atom://config/packages/' + item.host, onClick: this.handlePackageLinkClicked },
          item.host
        );
      }
    }
  }, {
    key: 'handlePackageLinkClicked',
    value: function handlePackageLinkClicked(evt) {
      evt.preventDefault();
      atom.workspace.open(evt.target.getAttribute('href'));
    }
  }, {
    key: 'renderRegistrationDescription',
    value: function renderRegistrationDescription() {
      if (this.isDefaultProtocolClient) {
        return 'Atom is already the default handler for atom:// URIs.';
      } else if (isSupported()) {
        return 'Register Atom as the default handler for atom:// URIs.';
      } else {
        return 'Registration as the default handler for atom:// URIs is only supported on Windows and macOS.';
      }
    }
  }, {
    key: 'handleChange',
    value: function handleChange(evt) {
      atom.config.set('core.uriHandlerRegistration', evt.target.value);
    }
  }, {
    key: 'handleBecomeProtocolClient',
    value: function handleBecomeProtocolClient(evt) {
      evt.preventDefault();
      if (setAsDefaultProtocolClient()) {
        this.isDefaultProtocolClient = isDefaultProtocolClient();
        _etch2['default'].update(this);
      } else {
        atom.notifications.addError('Could not become default protocol client');
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return UriHandlerPanel;
})();

exports['default'] = UriHandlerPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3NldHRpbmdzLXZpZXcvbGliL3VyaS1oYW5kbGVyLXBhbmVsLmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7b0JBR2tDLE1BQU07O29CQUN2QixNQUFNOzs7O0FBRXZCLFNBQVMsV0FBVyxHQUFJO0FBQ3RCLFNBQU8sQ0FBQyxPQUFPLEVBQUUsUUFBUSxDQUFDLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQTtDQUN0RDs7QUFFRCxTQUFTLHVCQUF1QixHQUFJO0FBQ2xDLFNBQU8sT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsdUJBQXVCLENBQUMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxRQUFRLEVBQUUsQ0FBQyxlQUFlLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQTtDQUNqSDs7QUFFRCxTQUFTLDBCQUEwQixHQUFJOzs7QUFHckMsU0FBTyxXQUFXLEVBQUUsSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQywwQkFBMEIsQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDLFFBQVEsRUFBRSxDQUFDLGVBQWUsRUFBRSxJQUFJLENBQUMsQ0FBQyxDQUFBO0NBQ3JJOztJQUVvQixlQUFlO0FBQ3RCLFdBRE8sZUFBZSxHQUNuQjs7OzBCQURJLGVBQWU7O0FBRWhDLFFBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7QUFDaEQsUUFBSSxDQUFDLDBCQUEwQixHQUFHLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7QUFDNUUsUUFBSSxDQUFDLHVCQUF1QixHQUFHLHVCQUF1QixFQUFFLENBQUE7QUFDeEQsUUFBSSxDQUFDLFVBQVUsR0FBRyxFQUFFLENBQUE7QUFDcEIsc0JBQUssVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFBOztBQUVyQixRQUFJLENBQUMsYUFBYSxHQUFHLCtCQUF5QixDQUFBO0FBQzlDLFFBQUksQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUNwQixJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFO0FBQzlCLG9CQUFjLEVBQUUsc0JBQU07QUFBRSxjQUFLLFFBQVEsRUFBRSxDQUFBO09BQUU7QUFDekMsc0JBQWdCLEVBQUUsd0JBQU07QUFBRSxjQUFLLFVBQVUsRUFBRSxDQUFBO09BQUU7QUFDN0Msb0JBQWMsRUFBRSxzQkFBTTtBQUFFLGNBQUssTUFBTSxFQUFFLENBQUE7T0FBRTtBQUN2QyxzQkFBZ0IsRUFBRSx3QkFBTTtBQUFFLGNBQUssUUFBUSxFQUFFLENBQUE7T0FBRTtBQUMzQyx3QkFBa0IsRUFBRSx5QkFBTTtBQUFFLGNBQUssV0FBVyxFQUFFLENBQUE7T0FBRTtBQUNoRCwyQkFBcUIsRUFBRSw0QkFBTTtBQUFFLGNBQUssY0FBYyxFQUFFLENBQUE7T0FBRTtLQUN2RCxDQUFDLEVBQ0YsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxZQUFNO0FBQzVDLFlBQUssVUFBVSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxzQkFBc0IsRUFBRSxDQUFBO0FBQ2xFLHdCQUFLLE1BQU0sT0FBTSxDQUFBO0tBQ2xCLENBQUMsQ0FDSCxDQUFBO0dBQ0Y7O2VBdkJrQixlQUFlOztXQXlCMUIsbUJBQUc7QUFDVCxVQUFJLENBQUMsYUFBYSxDQUFDLE9BQU8sRUFBRSxDQUFBO0FBQzVCLGFBQU8sa0JBQUssT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQzFCOzs7V0FFTSxrQkFBRyxFQUFFOzs7V0FFTCxrQkFBRztBQUNSLFVBQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLDZCQUE2QixDQUFDLENBQUE7O0FBRW5FLGFBQ0U7O1VBQUssU0FBUyxFQUFDLGFBQWEsRUFBQyxRQUFRLEVBQUMsR0FBRztRQUN2Qzs7WUFBTSxTQUFTLEVBQUMsdUJBQXVCO1VBQ3JDOztjQUFLLFNBQVMsRUFBQyxnQkFBZ0I7WUFDN0I7O2dCQUFLLFNBQVMsRUFBQyxtQkFBbUI7Y0FDaEM7O2tCQUFLLFNBQVMsRUFBQyxnREFBZ0Q7O2VBQW1CO2NBQ2xGOztrQkFBSyxTQUFTLEVBQUMseUJBQXlCOztlQUE4RDtjQUN0Rzs7a0JBQUssU0FBUyxFQUFDLGNBQWM7Z0JBQzNCOztvQkFBSyxTQUFTLEVBQUMsZUFBZTtrQkFDNUI7O3NCQUFLLFNBQVMsRUFBQyxVQUFVO29CQUN2Qjs7d0JBQU8sU0FBUyxFQUFDLGVBQWU7c0JBQzlCOzswQkFBSyxTQUFTLEVBQUMsZUFBZTs7dUJBQStCO3NCQUM3RDs7MEJBQUssU0FBUyxFQUFDLHFCQUFxQjt3QkFDakMsSUFBSSxDQUFDLDZCQUE2QixFQUFFO3VCQUNqQztxQkFDQTtvQkFDUjs7O0FBQ0UsaUNBQVMsRUFBQyxpQkFBaUI7QUFDM0IsZ0NBQVEsRUFBRSxDQUFDLFdBQVcsRUFBRSxJQUFJLElBQUksQ0FBQyx1QkFBdUIsQUFBQztBQUN6RCw2QkFBSyxFQUFFLEVBQUMsUUFBUSxFQUFFLFFBQVEsRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFDLEFBQUM7QUFDOUMsK0JBQU8sRUFBRSxJQUFJLENBQUMsMEJBQTBCLEFBQUM7OztxQkFHbEM7bUJBQ0w7aUJBQ0Y7Z0JBRU47O29CQUFLLFNBQVMsRUFBQyxlQUFlO2tCQUM1Qjs7c0JBQUssU0FBUyxFQUFDLFVBQVU7b0JBQ3ZCOzt3QkFBTyxTQUFTLEVBQUMsZUFBZTtzQkFDOUI7OzBCQUFLLFNBQVMsRUFBQyxlQUFlOzt1QkFBMkI7c0JBQ3pEOzswQkFBSyxTQUFTLEVBQUMscUJBQXFCO3dCQUNqQyxNQUFNLENBQUMsV0FBVzt1QkFDZjtxQkFDQTtvQkFDUjs7O0FBQ0UsMEJBQUUsRUFBQyw2QkFBNkI7QUFDaEMsaUNBQVMsRUFBQyxjQUFjO0FBQ3hCLGdDQUFRLEVBQUUsSUFBSSxDQUFDLFlBQVksQUFBQztBQUM1Qiw2QkFBSyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLDZCQUE2QixDQUFDLEFBQUM7O3NCQUVyRCxNQUFNLFFBQUssQ0FBQyxHQUFHLENBQUMsVUFBQyxJQUFvQjs0QkFBbkIsV0FBVyxHQUFaLElBQW9CLENBQW5CLFdBQVc7NEJBQUUsS0FBSyxHQUFuQixJQUFvQixDQUFOLEtBQUs7K0JBQ25DOzs0QkFBUSxLQUFLLEVBQUUsS0FBSyxBQUFDOzBCQUFFLFdBQVc7eUJBQVU7dUJBQzdDLENBQUM7cUJBQ0s7bUJBQ0w7aUJBQ0Y7Z0JBRU47O29CQUFLLFNBQVMsRUFBQyxlQUFlO2tCQUM1Qjs7c0JBQUssU0FBUyxFQUFDLFVBQVU7b0JBQ3ZCOzt3QkFBTyxTQUFTLEVBQUMsZ0JBQWdCO3NCQUMvQjs7MEJBQUssU0FBUyxFQUFDLGVBQWU7O3VCQUFrQjtxQkFDMUM7b0JBQ1I7O3dCQUFPLFNBQVMsRUFBQyxhQUFhO3NCQUM1Qjs7O3dCQUNFOzs7O3lCQUFZO3dCQUNaOzs7O3lCQUFtQjt1QkFDaEI7c0JBQ0osSUFBSSxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztxQkFDaEQ7bUJBQ0o7aUJBQ0Y7ZUFDRjthQUNGO1dBQ0Y7U0FDRDtPQUNILENBQ1A7S0FDRjs7O1dBRWdCLDBCQUFDLElBQUksRUFBRSxHQUFHLEVBQUU7QUFDM0IsYUFDRTs7O0FBQ0UsYUFBRyxFQUFFLElBQUksQ0FBQyxFQUFFLEFBQUM7QUFDYixtQkFBUyxFQUFDLEVBQUU7O1FBRVo7OztVQUFLLElBQUksQ0FBQyxHQUFHO1NBQU07UUFDbkI7OztVQUNHLElBQUksQ0FBQyxPQUFPLEdBQ1QsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsR0FDckI7Ozs7V0FBb0I7U0FDbEI7T0FDTCxDQUNOO0tBQ0Y7OztXQUVVLG9CQUFDLElBQUksRUFBRTtBQUNoQixVQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxFQUFFO0FBQ3hCLGVBQU87Ozs7U0FBYSxDQUFBO09BQ3JCLE1BQU07QUFDTCxlQUFPOztZQUFHLElBQUksOEJBQTRCLElBQUksQ0FBQyxJQUFJLEFBQUcsRUFBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLHdCQUF3QixBQUFDO1VBQUUsSUFBSSxDQUFDLElBQUk7U0FBSyxDQUFBO09BQy9HO0tBQ0Y7OztXQUV3QixrQ0FBQyxHQUFHLEVBQUU7QUFDN0IsU0FBRyxDQUFDLGNBQWMsRUFBRSxDQUFBO0FBQ3BCLFVBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUE7S0FDckQ7OztXQUU2Qix5Q0FBRztBQUMvQixVQUFJLElBQUksQ0FBQyx1QkFBdUIsRUFBRTtBQUNoQyxlQUFPLHVEQUF1RCxDQUFBO09BQy9ELE1BQU0sSUFBSSxXQUFXLEVBQUUsRUFBRTtBQUN4QixlQUFPLHdEQUF3RCxDQUFBO09BQ2hFLE1BQU07QUFDTCxlQUFPLDhGQUE4RixDQUFBO09BQ3RHO0tBQ0Y7OztXQUVZLHNCQUFDLEdBQUcsRUFBRTtBQUNqQixVQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyw2QkFBNkIsRUFBRSxHQUFHLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFBO0tBQ2pFOzs7V0FFMEIsb0NBQUMsR0FBRyxFQUFFO0FBQy9CLFNBQUcsQ0FBQyxjQUFjLEVBQUUsQ0FBQTtBQUNwQixVQUFJLDBCQUEwQixFQUFFLEVBQUU7QUFDaEMsWUFBSSxDQUFDLHVCQUF1QixHQUFHLHVCQUF1QixFQUFFLENBQUE7QUFDeEQsMEJBQUssTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFBO09BQ2xCLE1BQU07QUFDTCxZQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQywwQ0FBMEMsQ0FBQyxDQUFBO09BQ3hFO0tBQ0Y7OztXQUVLLGlCQUFHO0FBQ1AsVUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsQ0FBQTtLQUNyQjs7O1dBRUksZ0JBQUc7QUFDTixVQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO0tBQ2hDOzs7V0FFUSxvQkFBRztBQUNWLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxJQUFJLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBWSxHQUFHLEVBQUUsQ0FBQTtLQUMxRDs7O1dBRVUsc0JBQUc7QUFDWixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxRQUFRLENBQUMsSUFBSSxDQUFDLFlBQVksR0FBRyxFQUFFLENBQUE7S0FDMUQ7OztXQUVNLGtCQUFHO0FBQ1IsVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUE7S0FDcEQ7OztXQUVRLG9CQUFHO0FBQ1YsVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUE7S0FDcEQ7OztXQUVXLHVCQUFHO0FBQ2IsVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLEdBQUcsQ0FBQyxDQUFBO0tBQzNCOzs7V0FFYywwQkFBRztBQUNoQixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQTtLQUNuRDs7O1NBNUxrQixlQUFlOzs7cUJBQWYsZUFBZSIsImZpbGUiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9zZXR0aW5ncy12aWV3L2xpYi91cmktaGFuZGxlci1wYW5lbC5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAYmFiZWwgKi9cbi8qKiBAanN4IGV0Y2guZG9tICovXG5cbmltcG9ydCB7Q29tcG9zaXRlRGlzcG9zYWJsZX0gZnJvbSAnYXRvbSdcbmltcG9ydCBldGNoIGZyb20gJ2V0Y2gnXG5cbmZ1bmN0aW9uIGlzU3VwcG9ydGVkICgpIHtcbiAgcmV0dXJuIFsnd2luMzInLCAnZGFyd2luJ10uaW5jbHVkZXMocHJvY2Vzcy5wbGF0Zm9ybSlcbn1cblxuZnVuY3Rpb24gaXNEZWZhdWx0UHJvdG9jb2xDbGllbnQgKCkge1xuICByZXR1cm4gcmVxdWlyZSgnZWxlY3Ryb24nKS5yZW1vdGUuYXBwLmlzRGVmYXVsdFByb3RvY29sQ2xpZW50KCdhdG9tJywgcHJvY2Vzcy5leGVjUGF0aCwgWyctLXVyaS1oYW5kbGVyJywgJy0tJ10pXG59XG5cbmZ1bmN0aW9uIHNldEFzRGVmYXVsdFByb3RvY29sQ2xpZW50ICgpIHtcbiAgLy8gVGhpcyBFbGVjdHJvbiBBUEkgaXMgb25seSBhdmFpbGFibGUgb24gV2luZG93cyBhbmQgbWFjT1MuIFRoZXJlIG1pZ2h0IGJlIHNvbWVcbiAgLy8gaGFja3MgdG8gbWFrZSBpdCB3b3JrIG9uIExpbnV4OyBzZWUgaHR0cHM6Ly9naXRodWIuY29tL2VsZWN0cm9uL2VsZWN0cm9uL2lzc3Vlcy82NDQwXG4gIHJldHVybiBpc1N1cHBvcnRlZCgpICYmIHJlcXVpcmUoJ2VsZWN0cm9uJykucmVtb3RlLmFwcC5zZXRBc0RlZmF1bHRQcm90b2NvbENsaWVudCgnYXRvbScsIHByb2Nlc3MuZXhlY1BhdGgsIFsnLS11cmktaGFuZGxlcicsICctLSddKVxufVxuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBVcmlIYW5kbGVyUGFuZWwge1xuICBjb25zdHJ1Y3RvciAoKSB7XG4gICAgdGhpcy5oYW5kbGVDaGFuZ2UgPSB0aGlzLmhhbmRsZUNoYW5nZS5iaW5kKHRoaXMpXG4gICAgdGhpcy5oYW5kbGVCZWNvbWVQcm90b2NvbENsaWVudCA9IHRoaXMuaGFuZGxlQmVjb21lUHJvdG9jb2xDbGllbnQuYmluZCh0aGlzKVxuICAgIHRoaXMuaXNEZWZhdWx0UHJvdG9jb2xDbGllbnQgPSBpc0RlZmF1bHRQcm90b2NvbENsaWVudCgpXG4gICAgdGhpcy51cmlIaXN0b3J5ID0gW11cbiAgICBldGNoLmluaXRpYWxpemUodGhpcylcblxuICAgIHRoaXMuc3Vic2NyaXB0aW9ucyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlKClcbiAgICB0aGlzLnN1YnNjcmlwdGlvbnMuYWRkKFxuICAgICAgYXRvbS5jb21tYW5kcy5hZGQodGhpcy5lbGVtZW50LCB7XG4gICAgICAgICdjb3JlOm1vdmUtdXAnOiAoKSA9PiB7IHRoaXMuc2Nyb2xsVXAoKSB9LFxuICAgICAgICAnY29yZTptb3ZlLWRvd24nOiAoKSA9PiB7IHRoaXMuc2Nyb2xsRG93bigpIH0sXG4gICAgICAgICdjb3JlOnBhZ2UtdXAnOiAoKSA9PiB7IHRoaXMucGFnZVVwKCkgfSxcbiAgICAgICAgJ2NvcmU6cGFnZS1kb3duJzogKCkgPT4geyB0aGlzLnBhZ2VEb3duKCkgfSxcbiAgICAgICAgJ2NvcmU6bW92ZS10by10b3AnOiAoKSA9PiB7IHRoaXMuc2Nyb2xsVG9Ub3AoKSB9LFxuICAgICAgICAnY29yZTptb3ZlLXRvLWJvdHRvbSc6ICgpID0+IHsgdGhpcy5zY3JvbGxUb0JvdHRvbSgpIH1cbiAgICAgIH0pLFxuICAgICAgYXRvbS51cmlIYW5kbGVyUmVnaXN0cnkub25IaXN0b3J5Q2hhbmdlKCgpID0+IHtcbiAgICAgICAgdGhpcy51cmlIaXN0b3J5ID0gYXRvbS51cmlIYW5kbGVyUmVnaXN0cnkuZ2V0UmVjZW50bHlIYW5kbGVkVVJJcygpXG4gICAgICAgIGV0Y2gudXBkYXRlKHRoaXMpXG4gICAgICB9KVxuICAgIClcbiAgfVxuXG4gIGRlc3Ryb3kgKCkge1xuICAgIHRoaXMuc3Vic2NyaXB0aW9ucy5kaXNwb3NlKClcbiAgICByZXR1cm4gZXRjaC5kZXN0cm95KHRoaXMpXG4gIH1cblxuICB1cGRhdGUgKCkge31cblxuICByZW5kZXIgKCkge1xuICAgIGNvbnN0IHNjaGVtYSA9IGF0b20uY29uZmlnLmdldFNjaGVtYSgnY29yZS51cmlIYW5kbGVyUmVnaXN0cmF0aW9uJylcblxuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT0ncGFuZWxzLWl0ZW0nIHRhYkluZGV4PScwJz5cbiAgICAgICAgPGZvcm0gY2xhc3NOYW1lPSdnZW5lcmFsLXBhbmVsIHNlY3Rpb24nPlxuICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdzZXR0aW5ncy1wYW5lbCc+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2VjdGlvbi1jb250YWluZXInPlxuICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nYmxvY2sgc2VjdGlvbi1oZWFkaW5nIGljb24gaWNvbi1kZXZpY2UtZGVza3RvcCc+VVJJIEhhbmRsaW5nPC9kaXY+XG4gICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSd0ZXh0IGljb24gaWNvbi1xdWVzdGlvbic+VGhlc2Ugc2V0dGluZ3MgZGV0ZXJtaW5lIGhvdyBBdG9tIGhhbmRsZXMgYXRvbTovLyBVUklzLjwvZGl2PlxuICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2VjdGlvbi1ib2R5Jz5cbiAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY29udHJvbC1ncm91cCc+XG4gICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY29udHJvbHMnPlxuICAgICAgICAgICAgICAgICAgICA8bGFiZWwgY2xhc3NOYW1lPSdjb250cm9sLWxhYmVsJz5cbiAgICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2V0dGluZy10aXRsZSc+VVJJIEhhbmRsZXIgUmVnaXN0cmF0aW9uPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3NldHRpbmctZGVzY3JpcHRpb24nPlxuICAgICAgICAgICAgICAgICAgICAgICAge3RoaXMucmVuZGVyUmVnaXN0cmF0aW9uRGVzY3JpcHRpb24oKX1cbiAgICAgICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICAgICAgPC9sYWJlbD5cbiAgICAgICAgICAgICAgICAgICAgPGJ1dHRvblxuICAgICAgICAgICAgICAgICAgICAgIGNsYXNzTmFtZT0nYnRuIGJ0bi1wcmltYXJ5J1xuICAgICAgICAgICAgICAgICAgICAgIGRpc2FibGVkPXshaXNTdXBwb3J0ZWQoKSB8fCB0aGlzLmlzRGVmYXVsdFByb3RvY29sQ2xpZW50fVxuICAgICAgICAgICAgICAgICAgICAgIHN0eWxlPXt7Zm9udFNpemU6ICcxLjI1ZW0nLCBkaXNwbGF5OiAnYmxvY2snfX1cbiAgICAgICAgICAgICAgICAgICAgICBvbkNsaWNrPXt0aGlzLmhhbmRsZUJlY29tZVByb3RvY29sQ2xpZW50fVxuICAgICAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgICAgICAgUmVnaXN0ZXIgYXMgZGVmYXVsdCBhdG9tOi8vIHByb3RvY29sIGhhbmRsZXJcbiAgICAgICAgICAgICAgICAgICAgPC9idXR0b24+XG4gICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8L2Rpdj5cblxuICAgICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdjb250cm9sLWdyb3VwJz5cbiAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdjb250cm9scyc+XG4gICAgICAgICAgICAgICAgICAgIDxsYWJlbCBjbGFzc05hbWU9J2NvbnRyb2wtbGFiZWwnPlxuICAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdzZXR0aW5nLXRpdGxlJz5EZWZhdWx0IFJlZ2lzdHJhdGlvbjwvZGl2PlxuICAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdzZXR0aW5nLWRlc2NyaXB0aW9uJz5cbiAgICAgICAgICAgICAgICAgICAgICAgIHtzY2hlbWEuZGVzY3JpcHRpb259XG4gICAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgIDwvbGFiZWw+XG4gICAgICAgICAgICAgICAgICAgIDxzZWxlY3RcbiAgICAgICAgICAgICAgICAgICAgICBpZD0nY29yZS51cmlIYW5kbGVyUmVnaXN0cmF0aW9uJ1xuICAgICAgICAgICAgICAgICAgICAgIGNsYXNzTmFtZT0nZm9ybS1jb250cm9sJ1xuICAgICAgICAgICAgICAgICAgICAgIG9uQ2hhbmdlPXt0aGlzLmhhbmRsZUNoYW5nZX1cbiAgICAgICAgICAgICAgICAgICAgICB2YWx1ZT17YXRvbS5jb25maWcuZ2V0KCdjb3JlLnVyaUhhbmRsZXJSZWdpc3RyYXRpb24nKX1cbiAgICAgICAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICAgICAgICAgIHtzY2hlbWEuZW51bS5tYXAoKHtkZXNjcmlwdGlvbiwgdmFsdWV9KSA9PiAoXG4gICAgICAgICAgICAgICAgICAgICAgICA8b3B0aW9uIHZhbHVlPXt2YWx1ZX0+e2Rlc2NyaXB0aW9ufTwvb3B0aW9uPlxuICAgICAgICAgICAgICAgICAgICAgICkpfVxuICAgICAgICAgICAgICAgICAgICA8L3NlbGVjdD5cbiAgICAgICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgICAgIDwvZGl2PlxuXG4gICAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J2NvbnRyb2wtZ3JvdXAnPlxuICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J2NvbnRyb2xzJz5cbiAgICAgICAgICAgICAgICAgICAgPGxhYmVsIGNsYXNzTmFtZT0nY29udHJvbHMtbGFiZWwnPlxuICAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdzZXR0aW5nLXRpdGxlJz5SZWNlbnQgVVJJczwvZGl2PlxuICAgICAgICAgICAgICAgICAgICA8L2xhYmVsPlxuICAgICAgICAgICAgICAgICAgICA8dGFibGUgY2xhc3NOYW1lPSd1cmktaGlzdG9yeSc+XG4gICAgICAgICAgICAgICAgICAgICAgPHRyPlxuICAgICAgICAgICAgICAgICAgICAgICAgPHRoPlVSSTwvdGg+XG4gICAgICAgICAgICAgICAgICAgICAgICA8dGg+SGFuZGxlZCBCeTwvdGg+XG4gICAgICAgICAgICAgICAgICAgICAgPC90cj5cbiAgICAgICAgICAgICAgICAgICAgICB7dGhpcy51cmlIaXN0b3J5Lm1hcCh0aGlzLnJlbmRlckhpc3RvcnlSb3cuYmluZCh0aGlzKSl9XG4gICAgICAgICAgICAgICAgICAgIDwvdGFibGU+XG4gICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgPC9mb3JtPlxuICAgICAgPC9kaXY+XG4gICAgKVxuICB9XG5cbiAgcmVuZGVySGlzdG9yeVJvdyAoaXRlbSwgaWR4KSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDx0clxuICAgICAgICBrZXk9e2l0ZW0uaWR9XG4gICAgICAgIGNsYXNzTmFtZT0nJ1xuICAgICAgPlxuICAgICAgICA8dGQ+e2l0ZW0udXJpfTwvdGQ+XG4gICAgICAgIDx0ZD5cbiAgICAgICAgICB7aXRlbS5oYW5kbGVkXG4gICAgICAgICAgICA/IHRoaXMucmVuZGVySXRlbShpdGVtKVxuICAgICAgICAgICAgOiA8ZW0+bm90IGhhbmRsZWQ8L2VtPlxuICAgICAgICAgIH08L3RkPlxuICAgICAgPC90cj5cbiAgICApXG4gIH1cblxuICByZW5kZXJJdGVtIChpdGVtKSB7XG4gICAgaWYgKGl0ZW0uaG9zdCA9PT0gJ2NvcmUnKSB7XG4gICAgICByZXR1cm4gPGVtPmNvcmU8L2VtPlxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gPGEgaHJlZj17YGF0b206Ly9jb25maWcvcGFja2FnZXMvJHtpdGVtLmhvc3R9YH0gb25DbGljaz17dGhpcy5oYW5kbGVQYWNrYWdlTGlua0NsaWNrZWR9PntpdGVtLmhvc3R9PC9hPlxuICAgIH1cbiAgfVxuXG4gIGhhbmRsZVBhY2thZ2VMaW5rQ2xpY2tlZCAoZXZ0KSB7XG4gICAgZXZ0LnByZXZlbnREZWZhdWx0KClcbiAgICBhdG9tLndvcmtzcGFjZS5vcGVuKGV2dC50YXJnZXQuZ2V0QXR0cmlidXRlKCdocmVmJykpXG4gIH1cblxuICByZW5kZXJSZWdpc3RyYXRpb25EZXNjcmlwdGlvbiAoKSB7XG4gICAgaWYgKHRoaXMuaXNEZWZhdWx0UHJvdG9jb2xDbGllbnQpIHtcbiAgICAgIHJldHVybiAnQXRvbSBpcyBhbHJlYWR5IHRoZSBkZWZhdWx0IGhhbmRsZXIgZm9yIGF0b206Ly8gVVJJcy4nXG4gICAgfSBlbHNlIGlmIChpc1N1cHBvcnRlZCgpKSB7XG4gICAgICByZXR1cm4gJ1JlZ2lzdGVyIEF0b20gYXMgdGhlIGRlZmF1bHQgaGFuZGxlciBmb3IgYXRvbTovLyBVUklzLidcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuICdSZWdpc3RyYXRpb24gYXMgdGhlIGRlZmF1bHQgaGFuZGxlciBmb3IgYXRvbTovLyBVUklzIGlzIG9ubHkgc3VwcG9ydGVkIG9uIFdpbmRvd3MgYW5kIG1hY09TLidcbiAgICB9XG4gIH1cblxuICBoYW5kbGVDaGFuZ2UgKGV2dCkge1xuICAgIGF0b20uY29uZmlnLnNldCgnY29yZS51cmlIYW5kbGVyUmVnaXN0cmF0aW9uJywgZXZ0LnRhcmdldC52YWx1ZSlcbiAgfVxuXG4gIGhhbmRsZUJlY29tZVByb3RvY29sQ2xpZW50IChldnQpIHtcbiAgICBldnQucHJldmVudERlZmF1bHQoKVxuICAgIGlmIChzZXRBc0RlZmF1bHRQcm90b2NvbENsaWVudCgpKSB7XG4gICAgICB0aGlzLmlzRGVmYXVsdFByb3RvY29sQ2xpZW50ID0gaXNEZWZhdWx0UHJvdG9jb2xDbGllbnQoKVxuICAgICAgZXRjaC51cGRhdGUodGhpcylcbiAgICB9IGVsc2Uge1xuICAgICAgYXRvbS5ub3RpZmljYXRpb25zLmFkZEVycm9yKCdDb3VsZCBub3QgYmVjb21lIGRlZmF1bHQgcHJvdG9jb2wgY2xpZW50JylcbiAgICB9XG4gIH1cblxuICBmb2N1cyAoKSB7XG4gICAgdGhpcy5lbGVtZW50LmZvY3VzKClcbiAgfVxuXG4gIHNob3cgKCkge1xuICAgIHRoaXMuZWxlbWVudC5zdHlsZS5kaXNwbGF5ID0gJydcbiAgfVxuXG4gIHNjcm9sbFVwICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wIC09IGRvY3VtZW50LmJvZHkub2Zmc2V0SGVpZ2h0IC8gMjBcbiAgfVxuXG4gIHNjcm9sbERvd24gKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgKz0gZG9jdW1lbnQuYm9keS5vZmZzZXRIZWlnaHQgLyAyMFxuICB9XG5cbiAgcGFnZVVwICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wIC09IHRoaXMuZWxlbWVudC5vZmZzZXRIZWlnaHRcbiAgfVxuXG4gIHBhZ2VEb3duICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wICs9IHRoaXMuZWxlbWVudC5vZmZzZXRIZWlnaHRcbiAgfVxuXG4gIHNjcm9sbFRvVG9wICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wID0gMFxuICB9XG5cbiAgc2Nyb2xsVG9Cb3R0b20gKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgPSB0aGlzLmVsZW1lbnQuc2Nyb2xsSGVpZ2h0XG4gIH1cbn1cbiJdfQ==