Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var SystemPanel = (function () {
  function SystemPanel() {
    var _this = this;

    _classCallCheck(this, SystemPanel);

    _etch2['default'].initialize(this);
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    _atom.WinShell.fileHandler.isRegistered(function (i) {
      _this.refs.fileHandlerCheckbox.checked = i;
    });
    _atom.WinShell.fileContextMenu.isRegistered(function (i) {
      _this.refs.fileContextMenuCheckbox.checked = i;
    });
    _atom.WinShell.folderContextMenu.isRegistered(function (i) {
      _this.refs.folderContextMenuCheckbox.checked = i;
    });
  }

  _createClass(SystemPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '0' },
        _etch2['default'].dom(
          'form',
          { className: 'general-panel section' },
          _etch2['default'].dom(
            'div',
            { className: 'settings-panel' },
            _etch2['default'].dom(
              'div',
              { className: 'section-container' },
              _etch2['default'].dom(
                'div',
                { className: 'block section-heading icon icon-device-desktop' },
                'System Settings'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'text icon icon-question' },
                'These settings determine how Atom integrates with your operating system.'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'section-body' },
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'checkbox' },
                      _etch2['default'].dom(
                        'label',
                        { 'for': 'system.windows.file-handler' },
                        _etch2['default'].dom('input', {
                          ref: 'fileHandlerCheckbox',
                          id: 'system.windows.file-handler',
                          className: 'input-checkbox',
                          type: 'checkbox',
                          onclick: function (e) {
                            _this2.setRegistration(_atom.WinShell.fileHandler, e.target.checked);
                          } }),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-title' },
                          'Register as file handler'
                        ),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-description' },
                          'Show ',
                          _atom.WinShell.appName,
                          ' in the "Open with" application list for easy association with file types.'
                        )
                      )
                    )
                  )
                ),
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'checkbox' },
                      _etch2['default'].dom(
                        'label',
                        { 'for': 'system.windows.shell-menu-files' },
                        _etch2['default'].dom('input', {
                          ref: 'fileContextMenuCheckbox',
                          id: 'system.windows.shell-menu-files',
                          className: 'input-checkbox',
                          type: 'checkbox',
                          onclick: function (e) {
                            _this2.setRegistration(_atom.WinShell.fileContextMenu, e.target.checked);
                          } }),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-title' },
                          'Show in file context menus'
                        ),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-description' },
                          'Add "Open with ',
                          _atom.WinShell.appName,
                          '" to the File Explorer context menu for files.'
                        )
                      )
                    )
                  )
                ),
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'checkbox' },
                      _etch2['default'].dom(
                        'label',
                        { 'for': 'system.windows.shell-menu-folders' },
                        _etch2['default'].dom('input', {
                          ref: 'folderContextMenuCheckbox',
                          id: 'system.windows.shell-menu-folders',
                          className: 'input-checkbox',
                          type: 'checkbox',
                          onclick: function (e) {
                            _this2.setRegistration(_atom.WinShell.folderContextMenu, e.target.checked);
                            _this2.setRegistration(_atom.WinShell.folderBackgroundContextMenu, e.target.checked);
                          } }),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-title' },
                          'Show in folder context menus'
                        ),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-description' },
                          'Add "Open with ',
                          _atom.WinShell.appName,
                          '" to the File Explorer context menu for folders.'
                        )
                      )
                    )
                  )
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'setRegistration',
    value: function setRegistration(option, shouldBeRegistered) {
      if (shouldBeRegistered) {
        return option.register(function () {});
      } else {
        return option.deregister(function () {});
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return SystemPanel;
})();

exports['default'] = SystemPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3NldHRpbmdzLXZpZXcvbGliL3N5c3RlbS13aW5kb3dzLXBhbmVsLmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7b0JBRzRDLE1BQU07O29CQUNqQyxNQUFNOzs7O0lBRUYsV0FBVztBQUNsQixXQURPLFdBQVcsR0FDZjs7OzBCQURJLFdBQVc7O0FBRTVCLHNCQUFLLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQTtBQUNyQixRQUFJLENBQUMsYUFBYSxHQUFHLCtCQUF5QixDQUFBO0FBQzlDLFFBQUksQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFDckQsb0JBQWMsRUFBRSxzQkFBTTtBQUFFLGNBQUssUUFBUSxFQUFFLENBQUE7T0FBRTtBQUN6QyxzQkFBZ0IsRUFBRSx3QkFBTTtBQUFFLGNBQUssVUFBVSxFQUFFLENBQUE7T0FBRTtBQUM3QyxvQkFBYyxFQUFFLHNCQUFNO0FBQUUsY0FBSyxNQUFNLEVBQUUsQ0FBQTtPQUFFO0FBQ3ZDLHNCQUFnQixFQUFFLHdCQUFNO0FBQUUsY0FBSyxRQUFRLEVBQUUsQ0FBQTtPQUFFO0FBQzNDLHdCQUFrQixFQUFFLHlCQUFNO0FBQUUsY0FBSyxXQUFXLEVBQUUsQ0FBQTtPQUFFO0FBQ2hELDJCQUFxQixFQUFFLDRCQUFNO0FBQUUsY0FBSyxjQUFjLEVBQUUsQ0FBQTtPQUFFO0tBQ3ZELENBQUMsQ0FBQyxDQUFBOztBQUVILG1CQUFTLFdBQVcsQ0FBQyxZQUFZLENBQUMsVUFBQyxDQUFDLEVBQUs7QUFBRSxZQUFLLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEdBQUcsQ0FBQyxDQUFBO0tBQUUsQ0FBQyxDQUFBO0FBQ3ZGLG1CQUFTLGVBQWUsQ0FBQyxZQUFZLENBQUMsVUFBQyxDQUFDLEVBQUs7QUFBRSxZQUFLLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxPQUFPLEdBQUcsQ0FBQyxDQUFBO0tBQUUsQ0FBQyxDQUFBO0FBQy9GLG1CQUFTLGlCQUFpQixDQUFDLFlBQVksQ0FBQyxVQUFDLENBQUMsRUFBSztBQUFFLFlBQUssSUFBSSxDQUFDLHlCQUF5QixDQUFDLE9BQU8sR0FBRyxDQUFDLENBQUE7S0FBRSxDQUFDLENBQUE7R0FDcEc7O2VBaEJrQixXQUFXOztXQWtCdEIsbUJBQUc7QUFDVCxVQUFJLENBQUMsYUFBYSxDQUFDLE9BQU8sRUFBRSxDQUFBO0FBQzVCLGFBQU8sa0JBQUssT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQzFCOzs7V0FFTSxrQkFBRyxFQUFFOzs7V0FFTCxrQkFBRzs7O0FBQ1IsYUFDRTs7VUFBSyxTQUFTLEVBQUMsYUFBYSxFQUFDLFFBQVEsRUFBQyxHQUFHO1FBQ3ZDOztZQUFNLFNBQVMsRUFBQyx1QkFBdUI7VUFDckM7O2NBQUssU0FBUyxFQUFDLGdCQUFnQjtZQUM3Qjs7Z0JBQUssU0FBUyxFQUFDLG1CQUFtQjtjQUNoQzs7a0JBQUssU0FBUyxFQUFDLGdEQUFnRDs7ZUFBc0I7Y0FDckY7O2tCQUFLLFNBQVMsRUFBQyx5QkFBeUI7O2VBQStFO2NBQ3ZIOztrQkFBSyxTQUFTLEVBQUMsY0FBYztnQkFDM0I7O29CQUFLLFNBQVMsRUFBQyxlQUFlO2tCQUM1Qjs7c0JBQUssU0FBUyxFQUFDLFVBQVU7b0JBQ3ZCOzt3QkFBSyxTQUFTLEVBQUMsVUFBVTtzQkFDdkI7OzBCQUFPLE9BQUksNkJBQTZCO3dCQUN0QztBQUNFLDZCQUFHLEVBQUMscUJBQXFCO0FBQ3pCLDRCQUFFLEVBQUMsNkJBQTZCO0FBQ2hDLG1DQUFTLEVBQUMsZ0JBQWdCO0FBQzFCLDhCQUFJLEVBQUMsVUFBVTtBQUNmLGlDQUFPLEVBQUUsVUFBQyxDQUFDLEVBQUs7QUFBRSxtQ0FBSyxlQUFlLENBQUMsZUFBUyxXQUFXLEVBQUUsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQTsyQkFBRSxBQUFDLEdBQUc7d0JBQ3RGOzs0QkFBSyxTQUFTLEVBQUMsZUFBZTs7eUJBQStCO3dCQUM3RDs7NEJBQUssU0FBUyxFQUFDLHFCQUFxQjs7MEJBQzVCLGVBQVMsT0FBTzs7eUJBQ2xCO3VCQUNBO3FCQUNKO21CQUNGO2lCQUNGO2dCQUNOOztvQkFBSyxTQUFTLEVBQUMsZUFBZTtrQkFDNUI7O3NCQUFLLFNBQVMsRUFBQyxVQUFVO29CQUN2Qjs7d0JBQUssU0FBUyxFQUFDLFVBQVU7c0JBQ3ZCOzswQkFBTyxPQUFJLGlDQUFpQzt3QkFDMUM7QUFDRSw2QkFBRyxFQUFDLHlCQUF5QjtBQUM3Qiw0QkFBRSxFQUFDLGlDQUFpQztBQUNwQyxtQ0FBUyxFQUFDLGdCQUFnQjtBQUMxQiw4QkFBSSxFQUFDLFVBQVU7QUFDZixpQ0FBTyxFQUFFLFVBQUMsQ0FBQyxFQUFLO0FBQUUsbUNBQUssZUFBZSxDQUFDLGVBQVMsZUFBZSxFQUFFLENBQUMsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUE7MkJBQUUsQUFBQyxHQUFHO3dCQUMxRjs7NEJBQUssU0FBUyxFQUFDLGVBQWU7O3lCQUFpQzt3QkFDL0Q7OzRCQUFLLFNBQVMsRUFBQyxxQkFBcUI7OzBCQUNsQixlQUFTLE9BQU87O3lCQUM1Qjt1QkFDQTtxQkFDSjttQkFDRjtpQkFDRjtnQkFDTjs7b0JBQUssU0FBUyxFQUFDLGVBQWU7a0JBQzVCOztzQkFBSyxTQUFTLEVBQUMsVUFBVTtvQkFDdkI7O3dCQUFLLFNBQVMsRUFBQyxVQUFVO3NCQUN2Qjs7MEJBQU8sT0FBSSxtQ0FBbUM7d0JBQzVDO0FBQ0UsNkJBQUcsRUFBQywyQkFBMkI7QUFDL0IsNEJBQUUsRUFBQyxtQ0FBbUM7QUFDdEMsbUNBQVMsRUFBQyxnQkFBZ0I7QUFDMUIsOEJBQUksRUFBQyxVQUFVO0FBQ2YsaUNBQU8sRUFBRSxVQUFDLENBQUMsRUFBSztBQUNkLG1DQUFLLGVBQWUsQ0FBQyxlQUFTLGlCQUFpQixFQUFFLENBQUMsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUE7QUFDbEUsbUNBQUssZUFBZSxDQUFDLGVBQVMsMkJBQTJCLEVBQUUsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQTsyQkFDN0UsQUFBQyxHQUFHO3dCQUNQOzs0QkFBSyxTQUFTLEVBQUMsZUFBZTs7eUJBQW1DO3dCQUNqRTs7NEJBQUssU0FBUyxFQUFDLHFCQUFxQjs7MEJBQ2xCLGVBQVMsT0FBTzs7eUJBQzVCO3VCQUNBO3FCQUNKO21CQUNGO2lCQUNGO2VBQ0Y7YUFDRjtXQUNGO1NBQ0Q7T0FDSCxDQUNQO0tBQ0Y7OztXQUVlLHlCQUFDLE1BQU0sRUFBRSxrQkFBa0IsRUFBRTtBQUMzQyxVQUFJLGtCQUFrQixFQUFFO0FBQ3RCLGVBQU8sTUFBTSxDQUFDLFFBQVEsQ0FBQyxZQUFZLEVBQUUsQ0FBQyxDQUFBO09BQ3ZDLE1BQU07QUFDTCxlQUFPLE1BQU0sQ0FBQyxVQUFVLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQTtPQUN6QztLQUNGOzs7V0FFSyxpQkFBRztBQUNQLFVBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLENBQUE7S0FDckI7OztXQUVJLGdCQUFHO0FBQ04sVUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQTtLQUNoQzs7O1dBRVEsb0JBQUc7QUFDVixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxRQUFRLENBQUMsSUFBSSxDQUFDLFlBQVksR0FBRyxFQUFFLENBQUE7S0FDMUQ7OztXQUVVLHNCQUFHO0FBQ1osVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxZQUFZLEdBQUcsRUFBRSxDQUFBO0tBQzFEOzs7V0FFTSxrQkFBRztBQUNSLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFBO0tBQ3BEOzs7V0FFUSxvQkFBRztBQUNWLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFBO0tBQ3BEOzs7V0FFVyx1QkFBRztBQUNiLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxHQUFHLENBQUMsQ0FBQTtLQUMzQjs7O1dBRWMsMEJBQUc7QUFDaEIsVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUE7S0FDbkQ7OztTQXpJa0IsV0FBVzs7O3FCQUFYLFdBQVciLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvc2V0dGluZ3Mtdmlldy9saWIvc3lzdGVtLXdpbmRvd3MtcGFuZWwuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiogQGJhYmVsICovXG4vKiogQGpzeCBldGNoLmRvbSAqL1xuXG5pbXBvcnQge1dpblNoZWxsLCBDb21wb3NpdGVEaXNwb3NhYmxlfSBmcm9tICdhdG9tJ1xuaW1wb3J0IGV0Y2ggZnJvbSAnZXRjaCdcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU3lzdGVtUGFuZWwge1xuICBjb25zdHJ1Y3RvciAoKSB7XG4gICAgZXRjaC5pbml0aWFsaXplKHRoaXMpXG4gICAgdGhpcy5zdWJzY3JpcHRpb25zID0gbmV3IENvbXBvc2l0ZURpc3Bvc2FibGUoKVxuICAgIHRoaXMuc3Vic2NyaXB0aW9ucy5hZGQoYXRvbS5jb21tYW5kcy5hZGQodGhpcy5lbGVtZW50LCB7XG4gICAgICAnY29yZTptb3ZlLXVwJzogKCkgPT4geyB0aGlzLnNjcm9sbFVwKCkgfSxcbiAgICAgICdjb3JlOm1vdmUtZG93bic6ICgpID0+IHsgdGhpcy5zY3JvbGxEb3duKCkgfSxcbiAgICAgICdjb3JlOnBhZ2UtdXAnOiAoKSA9PiB7IHRoaXMucGFnZVVwKCkgfSxcbiAgICAgICdjb3JlOnBhZ2UtZG93bic6ICgpID0+IHsgdGhpcy5wYWdlRG93bigpIH0sXG4gICAgICAnY29yZTptb3ZlLXRvLXRvcCc6ICgpID0+IHsgdGhpcy5zY3JvbGxUb1RvcCgpIH0sXG4gICAgICAnY29yZTptb3ZlLXRvLWJvdHRvbSc6ICgpID0+IHsgdGhpcy5zY3JvbGxUb0JvdHRvbSgpIH1cbiAgICB9KSlcblxuICAgIFdpblNoZWxsLmZpbGVIYW5kbGVyLmlzUmVnaXN0ZXJlZCgoaSkgPT4geyB0aGlzLnJlZnMuZmlsZUhhbmRsZXJDaGVja2JveC5jaGVja2VkID0gaSB9KVxuICAgIFdpblNoZWxsLmZpbGVDb250ZXh0TWVudS5pc1JlZ2lzdGVyZWQoKGkpID0+IHsgdGhpcy5yZWZzLmZpbGVDb250ZXh0TWVudUNoZWNrYm94LmNoZWNrZWQgPSBpIH0pXG4gICAgV2luU2hlbGwuZm9sZGVyQ29udGV4dE1lbnUuaXNSZWdpc3RlcmVkKChpKSA9PiB7IHRoaXMucmVmcy5mb2xkZXJDb250ZXh0TWVudUNoZWNrYm94LmNoZWNrZWQgPSBpIH0pXG4gIH1cblxuICBkZXN0cm95ICgpIHtcbiAgICB0aGlzLnN1YnNjcmlwdGlvbnMuZGlzcG9zZSgpXG4gICAgcmV0dXJuIGV0Y2guZGVzdHJveSh0aGlzKVxuICB9XG5cbiAgdXBkYXRlICgpIHt9XG5cbiAgcmVuZGVyICgpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9J3BhbmVscy1pdGVtJyB0YWJJbmRleD0nMCc+XG4gICAgICAgIDxmb3JtIGNsYXNzTmFtZT0nZ2VuZXJhbC1wYW5lbCBzZWN0aW9uJz5cbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2V0dGluZ3MtcGFuZWwnPlxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3NlY3Rpb24tY29udGFpbmVyJz5cbiAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J2Jsb2NrIHNlY3Rpb24taGVhZGluZyBpY29uIGljb24tZGV2aWNlLWRlc2t0b3AnPlN5c3RlbSBTZXR0aW5nczwvZGl2PlxuICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0ndGV4dCBpY29uIGljb24tcXVlc3Rpb24nPlRoZXNlIHNldHRpbmdzIGRldGVybWluZSBob3cgQXRvbSBpbnRlZ3JhdGVzIHdpdGggeW91ciBvcGVyYXRpbmcgc3lzdGVtLjwvZGl2PlxuICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2VjdGlvbi1ib2R5Jz5cbiAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY29udHJvbC1ncm91cCc+XG4gICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY29udHJvbHMnPlxuICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY2hlY2tib3gnPlxuICAgICAgICAgICAgICAgICAgICAgIDxsYWJlbCBmb3I9J3N5c3RlbS53aW5kb3dzLmZpbGUtaGFuZGxlcic+XG4gICAgICAgICAgICAgICAgICAgICAgICA8aW5wdXRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgcmVmPSdmaWxlSGFuZGxlckNoZWNrYm94J1xuICAgICAgICAgICAgICAgICAgICAgICAgICBpZD0nc3lzdGVtLndpbmRvd3MuZmlsZS1oYW5kbGVyJ1xuICAgICAgICAgICAgICAgICAgICAgICAgICBjbGFzc05hbWU9J2lucHV0LWNoZWNrYm94J1xuICAgICAgICAgICAgICAgICAgICAgICAgICB0eXBlPSdjaGVja2JveCdcbiAgICAgICAgICAgICAgICAgICAgICAgICAgb25jbGljaz17KGUpID0+IHsgdGhpcy5zZXRSZWdpc3RyYXRpb24oV2luU2hlbGwuZmlsZUhhbmRsZXIsIGUudGFyZ2V0LmNoZWNrZWQpIH19IC8+XG4gICAgICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2V0dGluZy10aXRsZSc+UmVnaXN0ZXIgYXMgZmlsZSBoYW5kbGVyPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2V0dGluZy1kZXNjcmlwdGlvbic+XG4gICAgICAgICAgICAgICAgICAgICAgICAgIFNob3cge1dpblNoZWxsLmFwcE5hbWV9IGluIHRoZSBcIk9wZW4gd2l0aFwiIGFwcGxpY2F0aW9uIGxpc3QgZm9yIGVhc3kgYXNzb2NpYXRpb24gd2l0aCBmaWxlIHR5cGVzLlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgICAgPC9sYWJlbD5cbiAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY29udHJvbC1ncm91cCc+XG4gICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY29udHJvbHMnPlxuICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY2hlY2tib3gnPlxuICAgICAgICAgICAgICAgICAgICAgIDxsYWJlbCBmb3I9J3N5c3RlbS53aW5kb3dzLnNoZWxsLW1lbnUtZmlsZXMnPlxuICAgICAgICAgICAgICAgICAgICAgICAgPGlucHV0XG4gICAgICAgICAgICAgICAgICAgICAgICAgIHJlZj0nZmlsZUNvbnRleHRNZW51Q2hlY2tib3gnXG4gICAgICAgICAgICAgICAgICAgICAgICAgIGlkPSdzeXN0ZW0ud2luZG93cy5zaGVsbC1tZW51LWZpbGVzJ1xuICAgICAgICAgICAgICAgICAgICAgICAgICBjbGFzc05hbWU9J2lucHV0LWNoZWNrYm94J1xuICAgICAgICAgICAgICAgICAgICAgICAgICB0eXBlPSdjaGVja2JveCdcbiAgICAgICAgICAgICAgICAgICAgICAgICAgb25jbGljaz17KGUpID0+IHsgdGhpcy5zZXRSZWdpc3RyYXRpb24oV2luU2hlbGwuZmlsZUNvbnRleHRNZW51LCBlLnRhcmdldC5jaGVja2VkKSB9fSAvPlxuICAgICAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3NldHRpbmctdGl0bGUnPlNob3cgaW4gZmlsZSBjb250ZXh0IG1lbnVzPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2V0dGluZy1kZXNjcmlwdGlvbic+XG4gICAgICAgICAgICAgICAgICAgICAgICAgIEFkZCBcIk9wZW4gd2l0aCB7V2luU2hlbGwuYXBwTmFtZX1cIiB0byB0aGUgRmlsZSBFeHBsb3JlciBjb250ZXh0IG1lbnUgZm9yIGZpbGVzLlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgICAgPC9sYWJlbD5cbiAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY29udHJvbC1ncm91cCc+XG4gICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY29udHJvbHMnPlxuICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY2hlY2tib3gnPlxuICAgICAgICAgICAgICAgICAgICAgIDxsYWJlbCBmb3I9J3N5c3RlbS53aW5kb3dzLnNoZWxsLW1lbnUtZm9sZGVycyc+XG4gICAgICAgICAgICAgICAgICAgICAgICA8aW5wdXRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgcmVmPSdmb2xkZXJDb250ZXh0TWVudUNoZWNrYm94J1xuICAgICAgICAgICAgICAgICAgICAgICAgICBpZD0nc3lzdGVtLndpbmRvd3Muc2hlbGwtbWVudS1mb2xkZXJzJ1xuICAgICAgICAgICAgICAgICAgICAgICAgICBjbGFzc05hbWU9J2lucHV0LWNoZWNrYm94J1xuICAgICAgICAgICAgICAgICAgICAgICAgICB0eXBlPSdjaGVja2JveCdcbiAgICAgICAgICAgICAgICAgICAgICAgICAgb25jbGljaz17KGUpID0+IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnNldFJlZ2lzdHJhdGlvbihXaW5TaGVsbC5mb2xkZXJDb250ZXh0TWVudSwgZS50YXJnZXQuY2hlY2tlZClcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnNldFJlZ2lzdHJhdGlvbihXaW5TaGVsbC5mb2xkZXJCYWNrZ3JvdW5kQ29udGV4dE1lbnUsIGUudGFyZ2V0LmNoZWNrZWQpXG4gICAgICAgICAgICAgICAgICAgICAgICAgIH19IC8+XG4gICAgICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2V0dGluZy10aXRsZSc+U2hvdyBpbiBmb2xkZXIgY29udGV4dCBtZW51czwvZGl2PlxuICAgICAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3NldHRpbmctZGVzY3JpcHRpb24nPlxuICAgICAgICAgICAgICAgICAgICAgICAgICBBZGQgXCJPcGVuIHdpdGgge1dpblNoZWxsLmFwcE5hbWV9XCIgdG8gdGhlIEZpbGUgRXhwbG9yZXIgY29udGV4dCBtZW51IGZvciBmb2xkZXJzLlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgICAgPC9sYWJlbD5cbiAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgPC9mb3JtPlxuICAgICAgPC9kaXY+XG4gICAgKVxuICB9XG5cbiAgc2V0UmVnaXN0cmF0aW9uIChvcHRpb24sIHNob3VsZEJlUmVnaXN0ZXJlZCkge1xuICAgIGlmIChzaG91bGRCZVJlZ2lzdGVyZWQpIHtcbiAgICAgIHJldHVybiBvcHRpb24ucmVnaXN0ZXIoZnVuY3Rpb24gKCkge30pXG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBvcHRpb24uZGVyZWdpc3RlcihmdW5jdGlvbiAoKSB7fSlcbiAgICB9XG4gIH1cblxuICBmb2N1cyAoKSB7XG4gICAgdGhpcy5lbGVtZW50LmZvY3VzKClcbiAgfVxuXG4gIHNob3cgKCkge1xuICAgIHRoaXMuZWxlbWVudC5zdHlsZS5kaXNwbGF5ID0gJydcbiAgfVxuXG4gIHNjcm9sbFVwICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wIC09IGRvY3VtZW50LmJvZHkub2Zmc2V0SGVpZ2h0IC8gMjBcbiAgfVxuXG4gIHNjcm9sbERvd24gKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgKz0gZG9jdW1lbnQuYm9keS5vZmZzZXRIZWlnaHQgLyAyMFxuICB9XG5cbiAgcGFnZVVwICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wIC09IHRoaXMuZWxlbWVudC5vZmZzZXRIZWlnaHRcbiAgfVxuXG4gIHBhZ2VEb3duICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wICs9IHRoaXMuZWxlbWVudC5vZmZzZXRIZWlnaHRcbiAgfVxuXG4gIHNjcm9sbFRvVG9wICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wID0gMFxuICB9XG5cbiAgc2Nyb2xsVG9Cb3R0b20gKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgPSB0aGlzLmVsZW1lbnQuc2Nyb2xsSGVpZ2h0XG4gIH1cbn1cbiJdfQ==