Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _generalPanel = require('./general-panel');

var _generalPanel2 = _interopRequireDefault(_generalPanel);

var _editorPanel = require('./editor-panel');

var _editorPanel2 = _interopRequireDefault(_editorPanel);

var _packageDetailView = require('./package-detail-view');

var _packageDetailView2 = _interopRequireDefault(_packageDetailView);

var _keybindingsPanel = require('./keybindings-panel');

var _keybindingsPanel2 = _interopRequireDefault(_keybindingsPanel);

var _installPanel = require('./install-panel');

var _installPanel2 = _interopRequireDefault(_installPanel);

var _themesPanel = require('./themes-panel');

var _themesPanel2 = _interopRequireDefault(_themesPanel);

var _installedPackagesPanel = require('./installed-packages-panel');

var _installedPackagesPanel2 = _interopRequireDefault(_installedPackagesPanel);

var _updatesPanel = require('./updates-panel');

var _updatesPanel2 = _interopRequireDefault(_updatesPanel);

var _uriHandlerPanel = require('./uri-handler-panel');

var _uriHandlerPanel2 = _interopRequireDefault(_uriHandlerPanel);

var SettingsView = (function () {
  function SettingsView() {
    var _this = this;

    var _ref = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    var uri = _ref.uri;
    var packageManager = _ref.packageManager;
    var snippetsProvider = _ref.snippetsProvider;
    var activePanel = _ref.activePanel;

    _classCallCheck(this, SettingsView);

    this.uri = uri;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.deferredPanel = activePanel;
    this.destroyed = false;
    this.panelsByName = {};
    this.panelCreateCallbacks = {};

    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.disposables.add(atom.packages.onDidActivateInitialPackages(function () {
      _this.disposables.add(atom.packages.onDidActivatePackage(function (pack) {
        return _this.removePanelCache(pack.name);
      }), atom.packages.onDidDeactivatePackage(function (pack) {
        return _this.removePanelCache(pack.name);
      }));
    }));

    process.nextTick(function () {
      return _this.initializePanels();
    });
  }

  _createClass(SettingsView, [{
    key: 'removePanelCache',
    value: function removePanelCache(name) {
      delete this.panelsByName[name];
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.destroyed = true;
      this.disposables.dispose();
      for (var _name in this.panelsByName) {
        var panel = this.panelsByName[_name];
        panel.destroy();
      }

      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'settings-view pane-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'config-menu', ref: 'sidebar' },
          _etch2['default'].dom(
            'ul',
            { className: 'panels-menu nav nav-pills nav-stacked', ref: 'panelMenu' },
            _etch2['default'].dom('div', { className: 'panel-menu-separator', ref: 'menuSeparator' })
          ),
          _etch2['default'].dom(
            'div',
            { className: 'button-area' },
            _etch2['default'].dom(
              'button',
              { className: 'btn btn-default icon icon-link-external', ref: 'openDotAtom' },
              'Open Config Folder'
            )
          )
        ),
        _etch2['default'].dom('div', { className: 'panels', tabIndex: '-1', ref: 'panels' })
      );
    }

    // This prevents the view being actually disposed when closed
    // If you remove it you will need to ensure the cached settingsView
    // in main.coffee is correctly released on close as well...
  }, {
    key: 'onDidChangeTitle',
    value: function onDidChangeTitle() {
      return new _atom.Disposable();
    }
  }, {
    key: 'initializePanels',
    value: function initializePanels() {
      var _this2 = this;

      if (this.refs.panels.children.length > 1) {
        return;
      }

      var clickHandler = function clickHandler(event) {
        var target = event.target.closest('.panels-menu li a, .panels-packages li a');
        if (target) {
          _this2.showPanel(target.closest('li').name);
        }
      };
      this.element.addEventListener('click', clickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.element.removeEventListener('click', clickHandler);
      }));

      var focusHandler = function focusHandler() {
        _this2.focusActivePanel();
      };
      this.element.addEventListener('focus', focusHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.element.removeEventListener('focus', focusHandler);
      }));

      var openDotAtomClickHandler = function openDotAtomClickHandler() {
        atom.open({ pathsToOpen: [atom.getConfigDirPath()] });
      };
      this.refs.openDotAtom.addEventListener('click', openDotAtomClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        return _this2.refs.openDotAtom.removeEventListener('click', openDotAtomClickHandler);
      }));

      this.addCorePanel('Core', 'settings', function () {
        return new _generalPanel2['default']();
      });
      this.addCorePanel('Editor', 'code', function () {
        return new _editorPanel2['default']();
      });
      if (atom.config.getSchema('core.uriHandlerRegistration').type !== 'any') {
        // "feature flag" based on core support for URI handling
        this.addCorePanel('URI Handling', 'link', function () {
          return new _uriHandlerPanel2['default']();
        });
      }
      if (process.platform === 'win32' && require('atom').WinShell != null) {
        (function () {
          var SystemPanel = require('./system-windows-panel');
          _this2.addCorePanel('System', 'device-desktop', function () {
            return new SystemPanel();
          });
        })();
      }
      this.addCorePanel('Keybindings', 'keyboard', function () {
        return new _keybindingsPanel2['default']();
      });
      this.addCorePanel('Packages', 'package', function () {
        return new _installedPackagesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Themes', 'paintcan', function () {
        return new _themesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Updates', 'cloud-download', function () {
        return new _updatesPanel2['default'](_this2, _this2.packageManager);
      });
      this.addCorePanel('Install', 'plus', function () {
        return new _installPanel2['default'](_this2, _this2.packageManager);
      });

      this.showDeferredPanel();

      if (!this.activePanel) {
        this.showPanel('Core');
      }

      if (document.body.contains(this.element)) {
        this.refs.sidebar.style.width = this.refs.sidebar.offsetWidth;
      }
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: 'SettingsView',
        version: 2,
        activePanel: this.activePanel != null ? this.activePanel : this.deferredPanel,
        uri: this.uri
      };
    }
  }, {
    key: 'getPackages',
    value: function getPackages() {
      var _this3 = this;

      var bundledPackageMetadataCache = undefined;
      if (this.packages != null) {
        return this.packages;
      }

      this.packages = atom.packages.getLoadedPackages();

      try {
        var packageMetadata = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'package.json'));
        bundledPackageMetadataCache = packageMetadata ? packageMetadata._atomPackages : null;
      } catch (error) {}

      // Include disabled packages so they can be re-enabled from the UI
      var disabledPackages = atom.config.get('core.disabledPackages') || [];
      for (var packageName of disabledPackages) {
        var metadata;
        var packagePath = atom.packages.resolvePackagePath(packageName);
        if (!packagePath) {
          continue;
        }

        try {
          metadata = require(_path2['default'].join(packagePath, 'package.json'));
        } catch (error) {
          if (bundledPackageMetadataCache && bundledPackageMetadataCache[packageName]) {
            metadata = bundledPackageMetadataCache[packageName].metadata;
          }
        }
        if (metadata == null) {
          continue;
        }

        var _name2 = metadata.name != null ? metadata.name : packageName;
        if (!_underscorePlus2['default'].findWhere(this.packages, { name: _name2 })) {
          this.packages.push({ name: _name2, metadata: metadata, path: packagePath });
        }
      }

      this.packages.sort(function (pack1, pack2) {
        var title1 = _this3.packageManager.getPackageTitle(pack1);
        var title2 = _this3.packageManager.getPackageTitle(pack2);
        return title1.localeCompare(title2);
      });

      return this.packages;
    }
  }, {
    key: 'addCorePanel',
    value: function addCorePanel(name, iconName, panelCreateCallback) {
      var panelMenuItem = document.createElement('li');
      panelMenuItem.name = name;
      panelMenuItem.setAttribute('name', name);

      var a = document.createElement('a');
      a.classList.add('icon', 'icon-' + iconName);
      a.textContent = name;
      panelMenuItem.appendChild(a);

      this.refs.menuSeparator.parentElement.insertBefore(panelMenuItem, this.refs.menuSeparator);
      this.addPanel(name, panelCreateCallback);
    }
  }, {
    key: 'addPanel',
    value: function addPanel(name, panelCreateCallback) {
      this.panelCreateCallbacks[name] = panelCreateCallback;
      if (this.deferredPanel && this.deferredPanel.name === name) {
        this.showDeferredPanel();
      }
    }
  }, {
    key: 'getOrCreatePanel',
    value: function getOrCreatePanel(name, options) {
      var panel = this.panelsByName[name];
      if (panel) return panel;

      if (name in this.panelCreateCallbacks) {
        panel = this.panelCreateCallbacks[name]();
        delete this.panelCreateCallbacks[name];
      } else if (options && options.pack) {
        if (!options.pack.metadata) {
          options.pack.metadata = _underscorePlus2['default'].clone(options.pack);
        }
        panel = new _packageDetailView2['default'](options.pack, this, this.packageManager, this.snippetsProvider);
      }
      if (panel) {
        this.panelsByName[name] = panel;
      }

      return panel;
    }
  }, {
    key: 'makePanelMenuActive',
    value: function makePanelMenuActive(name) {
      var previouslyActivePanel = this.refs.sidebar.querySelector('.active');
      if (previouslyActivePanel) {
        previouslyActivePanel.classList.remove('active');
      }

      var newActivePanel = this.refs.sidebar.querySelector('[name=\'' + name + '\']');
      if (newActivePanel) {
        newActivePanel.classList.add('active');
      }
    }
  }, {
    key: 'focusActivePanel',
    value: function focusActivePanel() {
      // Pass focus to panel that is currently visible
      for (var i = 0; i < this.refs.panels.children.length; i++) {
        var child = this.refs.panels.children[i];
        if (child.offsetWidth > 0) {
          child.focus();
        }
      }
    }
  }, {
    key: 'showDeferredPanel',
    value: function showDeferredPanel() {
      if (this.deferredPanel) {
        var _deferredPanel = this.deferredPanel;
        var _name3 = _deferredPanel.name;
        var options = _deferredPanel.options;

        this.showPanel(_name3, options);
      }
    }

    // Public: show a panel.
    //
    // * `name` {String} the name of the panel to show
    // * `options` {Object} an options hash. Will be passed to `beforeShow()` on
    //   the panel. Options may include (but are not limited to):
    //   * `uri` the URI the panel was launched from
  }, {
    key: 'showPanel',
    value: function showPanel(name, options) {
      var panel = this.getOrCreatePanel(name, options);
      if (panel) {
        this.appendPanel(panel, options);
        this.makePanelMenuActive(name);
        this.setActivePanel(name, options);
        this.deferredPanel = null;
      } else {
        this.deferredPanel = { name: name, options: options };
      }
    }
  }, {
    key: 'showPanelForURI',
    value: function showPanelForURI(uri) {
      var regex = /config\/([a-z]+)\/?([a-zA-Z0-9_-]+)?/i;
      var match = regex.exec(uri);

      if (match) {
        var path1 = match[1];
        var path2 = match[2];

        if (path1 === 'packages' && path2 != null) {
          this.showPanel(path2, {
            uri: uri,
            pack: { name: path2 },
            back: atom.packages.getLoadedPackage(path2) ? 'Packages' : null
          });
        } else {
          var panelName = path1[0].toUpperCase() + path1.slice(1);
          this.showPanel(panelName, { uri: uri });
        }
      }
    }
  }, {
    key: 'appendPanel',
    value: function appendPanel(panel, options) {
      for (var i = 0; i < this.refs.panels.children.length; i++) {
        this.refs.panels.children[i].style.display = 'none';
      }

      if (!this.refs.panels.contains(panel.element)) {
        this.refs.panels.appendChild(panel.element);
      }

      if (panel.beforeShow) {
        panel.beforeShow(options);
      }
      panel.show();
      panel.focus();
    }
  }, {
    key: 'setActivePanel',
    value: function setActivePanel(name) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      this.activePanel = { name: name, options: options };
    }
  }, {
    key: 'removePanel',
    value: function removePanel(name) {
      var panel = this.panelsByName[name];
      if (panel) {
        panel.destroy();
        delete this.panelsByName[name];
      }
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Settings';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'tools';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.uri;
    }
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      return other instanceof SettingsView;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return SettingsView;
})();

exports['default'] = SettingsView;
module.exports = exports['default'];
/* The tabindex attr below ensures that clicks in a panel item won't
cause this view to gain focus. This is important because when this view
gains focus (e.g. immediately after atom displays it), it focuses the
currently active panel item. If that focusing causes the active panel to
scroll (e.g. because the active panel itself passes focus on to a search
box at the top of a scrolled panel), then the browser will not fire the
click event on the element within the panel on which the user originally
clicked (e.g. a package card). This would prevent us from showing a
package detail view when clicking on a package card. Phew! */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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