Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var PackageUpdatesStatusView = (function () {
  function PackageUpdatesStatusView() {
    _classCallCheck(this, PackageUpdatesStatusView);
  }

  _createClass(PackageUpdatesStatusView, [{
    key: 'initialize',
    value: function initialize(statusBar, packageManager, updates) {
      var _this = this;

      this.statusBar = statusBar;
      this.updates = updates;
      this.destroyed = true;
      this.updatingPackages = [];
      this.failedUpdates = [];
      this.disposables = new _atom.CompositeDisposable();

      this.element = document.createElement('div');
      this.element.classList.add('package-updates-status-view', 'inline-block', 'text', 'text-info');

      var iconPackage = document.createElement('span');
      iconPackage.classList.add('icon', 'icon-package');
      this.element.appendChild(iconPackage);

      this.countLabel = document.createElement('span');
      this.countLabel.classList.add('available-updates-status');
      this.element.appendChild(this.countLabel);

      this.disposables.add(packageManager.on('package-update-available theme-update-available', function (_ref) {
        var pack = _ref.pack;
        var error = _ref.error;
        _this.onPackageUpdateAvailable(pack);
      }));
      this.disposables.add(packageManager.on('package-updating theme-updating', function (_ref2) {
        var pack = _ref2.pack;
        var error = _ref2.error;
        _this.onPackageUpdating(pack);
      }));
      this.disposables.add(packageManager.on('package-updated theme-updated package-uninstalled theme-uninstalled', function (_ref3) {
        var pack = _ref3.pack;
        var error = _ref3.error;
        _this.onPackageUpdated(pack);
      }));
      this.disposables.add(packageManager.on('package-update-failed theme-update-failed', function (_ref4) {
        var pack = _ref4.pack;
        var error = _ref4.error;
        _this.onPackageUpdateFailed(pack);
      }));

      var clickHandler = function clickHandler() {
        atom.commands.dispatch(atom.views.getView(atom.workspace), 'settings-view:check-for-package-updates');
      };
      this.element.addEventListener('click', clickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this.element.removeEventListener('click', clickHandler);
      }));

      this.updateTile();
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();

      if (this.tile) {
        this.tile.destroy();
        this.tile = null;
      }

      if (this.tooltip) {
        this.tooltip.dispose();
        this.tooltip = null;
      }
    }
  }, {
    key: 'onPackageUpdateAvailable',
    value: function onPackageUpdateAvailable(pack) {
      for (var update of this.updates) {
        if (update.name === pack.name) {
          return;
        }
      }

      this.updates.push(pack);
      this.updateTile();
    }
  }, {
    key: 'onPackageUpdating',
    value: function onPackageUpdating(pack) {
      // Wipe failed status when an update is retried
      for (var index = 0; index < this.failedUpdates.length; index++) {
        var update = this.failedUpdates[index];
        if (update.name === pack.name) {
          this.failedUpdates.splice(index, 1);
        }
      }

      this.updatingPackages.push(pack);
      this.updateTile();
    }
  }, {
    key: 'onPackageUpdated',
    value: function onPackageUpdated(pack) {
      for (var index = 0; index < this.updates.length; index++) {
        var update = this.updates[index];
        if (update.name === pack.name) {
          this.updates.splice(index, 1);
        }
      }

      for (var index = 0; index < this.updatingPackages.length; index++) {
        var update = this.updatingPackages[index];
        if (update.name === pack.name) {
          this.updatingPackages.splice(index, 1);
        }
      }

      for (var index = 0; index < this.failedUpdates.length; index++) {
        var update = this.failedUpdates[index];
        if (update.name === pack.name) {
          this.failedUpdates.splice(index, 1);
        }
      }

      this.updateTile();
    }
  }, {
    key: 'onPackageUpdateFailed',
    value: function onPackageUpdateFailed(pack) {
      for (var update of this.failedUpdates) {
        if (update.name === pack.name) {
          return;
        }
      }

      for (var index = 0; index < this.updatingPackages.length; index++) {
        var update = this.updatingPackages[index];
        if (update.name === pack.name) {
          this.updatingPackages.splice(index, 1);
        }
      }

      this.failedUpdates.push(pack);
      this.updateTile();
    }
  }, {
    key: 'updateTile',
    value: function updateTile() {
      if (this.updates.length) {
        if (this.tooltip) {
          this.tooltip.dispose();
          this.tooltip = null;
        }

        if (this.destroyed) {
          // Priority of -99 should put us just to the left of the Squirrel icon, which displays when Atom has updates available
          this.tile = this.statusBar.addRightTile({ item: this, priority: -99 });
          this.destroyed = false;
        }

        var labelText = '' + _underscorePlus2['default'].pluralize(this.updates.length, 'update'); // 5 updates
        var tooltipText = _underscorePlus2['default'].pluralize(this.updates.length, 'package update') + ' available';

        if (this.updatingPackages.length) {
          labelText = this.updatingPackages.length + '/' + this.updates.length + ' updating'; // 3/5 updating
          tooltipText += ', ' + _underscorePlus2['default'].pluralize(this.updatingPackages.length, 'package') + ' currently updating';
        }

        if (this.failedUpdates.length) {
          labelText += ' (' + this.failedUpdates.length + ' failed)'; // 1 update (1 failed), or 3/5 updating (1 failed)
          tooltipText += ', ' + _underscorePlus2['default'].pluralize(this.failedUpdates.length, 'failed update');
        }

        this.countLabel.textContent = labelText;
        this.tooltip = atom.tooltips.add(this.element, { title: tooltipText });
      } else if (!this.destroyed) {
        this.tile.destroy();
        this.tile = null;
        this.destroyed = true;
      }
    }
  }]);

  return PackageUpdatesStatusView;
})();

exports['default'] = PackageUpdatesStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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