Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _atom = require('atom');

// View to display the snippets that a package has registered.

var PackageSnippetsView = (function () {
  function PackageSnippetsView(pack, snippetsProvider) {
    var _this = this;

    _classCallCheck(this, PackageSnippetsView);

    this.pack = pack;
    this.namespace = this.pack.name;
    this.snippetsProvider = snippetsProvider;
    this.packagePath = _path2['default'].join(pack.path, _path2['default'].sep);
    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.updateSnippetsView();

    var packagesWithSnippetsDisabled = atom.config.get('core.packagesWithSnippetsDisabled') || [];
    this.refs.snippetToggle.checked = !packagesWithSnippetsDisabled.includes(this.namespace);

    var changeHandler = function changeHandler(event) {
      event.stopPropagation();
      var value = _this.refs.snippetToggle.checked;
      if (value) {
        atom.config.removeAtKeyPath('core.packagesWithSnippetsDisabled', _this.namespace);
      } else {
        atom.config.pushAtKeyPath('core.packagesWithSnippetsDisabled', _this.namespace);
      }
      _this.updateSnippetsView();
    };

    this.refs.snippetToggle.addEventListener('change', changeHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.snippetToggle.removeEventListener('change', changeHandler);
    }));
  }

  _createClass(PackageSnippetsView, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'section',
        { className: 'section' },
        _etch2['default'].dom(
          'div',
          { className: 'section-heading icon icon-code' },
          'Snippets'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'checkbox' },
          _etch2['default'].dom(
            'label',
            { 'for': 'toggleSnippets' },
            _etch2['default'].dom('input', { id: 'toggleSnippets', className: 'input-checkbox', type: 'checkbox', ref: 'snippetToggle' }),
            _etch2['default'].dom(
              'div',
              { className: 'setting-title' },
              'Enable'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'setting-description' },
            'Disable this if you want to prevent this package’s snippets from appearing as suggestions or if you want to customize them in your snippets file.'
          )
        ),
        _etch2['default'].dom(
          'table',
          { className: 'package-snippets-table table native-key-bindings text', tabIndex: -1 },
          _etch2['default'].dom(
            'thead',
            null,
            _etch2['default'].dom(
              'tr',
              null,
              _etch2['default'].dom(
                'th',
                null,
                'Trigger'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Name'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Scope'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Body'
              )
            )
          ),
          _etch2['default'].dom('tbody', { ref: 'snippets' })
        )
      );
    }
  }, {
    key: 'getSnippetProperties',
    value: function getSnippetProperties() {
      var packageProperties = {};
      for (var _ref2 of this.snippetsProvider.getSnippets()) {
        var _name = _ref2.name;
        var properties = _ref2.properties;
        var selectorString = _ref2.selectorString;

        if (_name && _name.indexOf && _name.indexOf(this.packagePath) === 0) {
          var object = properties.snippets != null ? properties.snippets : {};
          for (var key in object) {
            var snippet = object[key];
            if (snippet != null) {
              snippet.selectorString = selectorString;
              if (packageProperties[key] == null) {
                packageProperties[key] = snippet;
              }
            }
          }
        }
      }

      return _underscorePlus2['default'].values(packageProperties).sort(function (snippet1, snippet2) {
        var prefix1 = snippet1.prefix != null ? snippet1.prefix : '';
        var prefix2 = snippet2.prefix != null ? snippet2.prefix : '';
        return prefix1.localeCompare(prefix2);
      });
    }
  }, {
    key: 'getSnippets',
    value: function getSnippets(callback) {
      var _this2 = this;

      var snippetsPackage = atom.packages.getLoadedPackage('snippets');
      var snippetsModule = snippetsPackage ? snippetsPackage.mainModule : null;
      if (snippetsModule) {
        if (snippetsModule.loaded) {
          callback(this.getSnippetProperties());
        } else {
          snippetsModule.onDidLoadSnippets(function () {
            return callback(_this2.getSnippetProperties());
          });
        }
      } else {
        callback([]); // eslint-disable-line standard/no-callback-literal
      }
    }
  }, {
    key: 'updateSnippetsView',
    value: function updateSnippetsView() {
      var _this3 = this;

      var packagesWithSnippetsDisabled = atom.config.get('core.packagesWithSnippetsDisabled') || [];
      var snippetsDisabled = packagesWithSnippetsDisabled.includes(this.namespace);

      this.getSnippets(function (snippets) {
        _this3.refs.snippets.innerHTML = '';

        if (snippetsDisabled) {
          _this3.refs.snippets.classList.add('text-subtle');
        } else {
          _this3.refs.snippets.classList.remove('text-subtle');
        }

        for (var _ref32 of snippets) {
          var body = _ref32.body;
          var bodyText = _ref32.bodyText;
          var _name2 = _ref32.name;
          var prefix = _ref32.prefix;
          var selectorString = _ref32.selectorString;

          if (_name2 == null) {
            _name2 = '';
          }

          if (prefix == null) {
            prefix = '';
          }

          if (body == null) {
            body = bodyText || '';
          }

          if (selectorString == null) {
            selectorString = '';
          }

          var row = document.createElement('tr');

          var prefixTd = document.createElement('td');
          prefixTd.classList.add('snippet-prefix');
          prefixTd.textContent = prefix;
          row.appendChild(prefixTd);

          var nameTd = document.createElement('td');
          nameTd.textContent = _name2;
          row.appendChild(nameTd);

          var scopeTd = document.createElement('td');
          scopeTd.classList.add('snippet-scope-name');
          scopeTd.textContent = selectorString;
          row.appendChild(scopeTd);

          var bodyTd = document.createElement('td');
          bodyTd.classList.add('snippet-body');
          row.appendChild(bodyTd);

          _this3.refs.snippets.appendChild(row);
          _this3.createButtonsForSnippetRow(bodyTd, { body: body, prefix: prefix, scope: selectorString, name: _name2 });
        }

        if (_this3.refs.snippets.children.length > 0) {
          _this3.element.style.display = '';
        } else {
          _this3.element.style.display = 'none';
        }
      });
    }
  }, {
    key: 'createButtonsForSnippetRow',
    value: function createButtonsForSnippetRow(td, _ref4) {
      var _this4 = this;

      var scope = _ref4.scope;
      var body = _ref4.body;
      var name = _ref4.name;
      var prefix = _ref4.prefix;

      var buttonContainer = document.createElement('div');
      buttonContainer.classList.add('btn-group', 'btn-group-xs');

      var viewButton = document.createElement('button');
      var copyButton = document.createElement('button');

      viewButton.setAttribute('type', 'button');
      viewButton.textContent = 'View';
      viewButton.classList.add('btn', 'snippet-view-btn');

      var tooltip = atom.tooltips.add(viewButton, {
        title: body,
        html: false,
        trigger: 'click',
        placement: 'auto left',
        'class': 'snippet-body-tooltip'
      });

      this.disposables.add(tooltip);

      copyButton.setAttribute('type', 'button');
      copyButton.textContent = 'Copy';
      copyButton.classList.add('btn', 'snippet-copy-btn');

      copyButton.addEventListener('click', function (event) {
        event.preventDefault();
        return _this4.writeSnippetToClipboard({ scope: scope, body: body, name: name, prefix: prefix });
      });

      buttonContainer.appendChild(viewButton);
      buttonContainer.appendChild(copyButton);

      td.appendChild(buttonContainer);
    }
  }, {
    key: 'writeSnippetToClipboard',
    value: function writeSnippetToClipboard(_ref5) {
      var scope = _ref5.scope;
      var body = _ref5.body;
      var name = _ref5.name;
      var prefix = _ref5.prefix;

      var content = undefined;
      var extension = _path2['default'].extname(this.snippetsProvider.getUserSnippetsPath());
      body = body.replace(/\n/g, '\\n').replace(/\t/g, '\\t');
      if (extension === '.cson') {
        body = body.replace(/'/g, '\\\'');
        content = '\n\'' + scope + '\':\n  \'' + name + '\':\n    \'prefix\': \'' + prefix + '\'\n    \'body\': \'' + body + '\'\n';
      } else {
        body = body.replace(/"/g, '\\"');
        content = '\n  "' + scope + '": {\n    "' + name + '": {\n      "prefix": "' + prefix + '",\n      "body": "' + body + '"\n    }\n  }\n';
      }

      atom.clipboard.write(content);
    }
  }]);

  return PackageSnippetsView;
})();

exports['default'] = PackageSnippetsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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