Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atom = require('atom');

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

// View to display the grammars that a package has registered.

var PackageGrammarsView = (function () {
  function PackageGrammarsView(packagePath) {
    var _this = this;

    _classCallCheck(this, PackageGrammarsView);

    this.element = document.createElement('section');
    this.element.classList.add('package-grammars');

    this.grammarSettings = document.createElement('div');
    this.element.appendChild(this.grammarSettings);

    this.disposables = new _atom.CompositeDisposable();
    this.packagePath = _path2['default'].join(packagePath, _path2['default'].sep);
    this.addGrammars();
    this.disposables.add(atom.grammars.onDidAddGrammar(function () {
      return _this.addGrammars();
    }));
    this.disposables.add(atom.grammars.onDidUpdateGrammar(function () {
      return _this.addGrammars();
    }));
  }

  _createClass(PackageGrammarsView, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'getPackageGrammars',
    value: function getPackageGrammars() {
      var packageGrammars = [];
      var grammars = atom.grammars.grammars != null ? atom.grammars.grammars : [];
      for (var grammar of grammars) {
        if (grammar.path) {
          if (grammar.path.indexOf(this.packagePath) === 0) {
            packageGrammars.push(grammar);
          }
        }
      }
      return packageGrammars.sort(function (grammar1, grammar2) {
        var name1 = grammar1.name || grammar1.scopeName || '';
        var name2 = grammar2.name || grammar2.scopeName || '';
        return name1.localeCompare(name2);
      });
    }
  }, {
    key: 'addGrammarHeading',
    value: function addGrammarHeading(grammar, panel) {
      var container = document.createElement('div');
      container.classList.add('native-key-bindings', 'text');
      container.tabIndex = -1;

      var grammarScope = document.createElement('div');
      grammarScope.classList.add('grammar-scope');

      var scopeStrong = document.createElement('strong');
      scopeStrong.textContent = 'Scope: ';
      grammarScope.appendChild(scopeStrong);

      var scopeSpan = document.createElement('span');
      scopeSpan.textContent = grammar.scopeName != null ? grammar.scopeName : '';
      grammarScope.appendChild(scopeSpan);
      container.appendChild(grammarScope);

      var grammarFileTypes = document.createElement('div');
      grammarFileTypes.classList.add('grammar-filetypes');

      var fileTypesStrong = document.createElement('strong');
      fileTypesStrong.textContent = 'File Types: ';
      grammarFileTypes.appendChild(fileTypesStrong);

      var fileTypes = grammar.fileTypes || [];
      var fileTypesSpan = document.createElement('span');
      fileTypesSpan.textContent = fileTypes.join(', ');
      grammarFileTypes.appendChild(fileTypesSpan);
      container.appendChild(grammarFileTypes);

      var sectionBody = panel.element.querySelector('.section-body');
      sectionBody.parentElement.insertBefore(container, sectionBody);
    }
  }, {
    key: 'addGrammars',
    value: function addGrammars() {
      this.grammarSettings.innerHTML = '';
      for (var grammar of this.getPackageGrammars()) {
        var scopeName = grammar.scopeName;
        var _name = grammar.name;

        if (!scopeName || !_name) {
          continue;
        }

        if (!scopeName.startsWith('.')) {
          scopeName = '.' + scopeName;
        }

        var title = _name + ' Grammar';
        var panel = new _settingsPanel2['default']({ title: title, scopeName: scopeName, icon: 'puzzle' });
        this.addGrammarHeading(grammar, panel);
        this.grammarSettings.appendChild(panel.element);
      }
    }
  }]);

  return PackageGrammarsView;
})();

exports['default'] = PackageGrammarsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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