Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var KeybindingsPanel = (function () {
  function KeybindingsPanel() {
    var _this = this;

    _classCallCheck(this, KeybindingsPanel);

    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    this.otherPlatformPattern = new RegExp('\\.platform-(?!' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b)');
    this.platformPattern = new RegExp('\\.platform-' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b');

    this.disposables.add(this.refs.searchEditor.onDidStopChanging(function () {
      _this.filterKeyBindings(_this.keyBindings, _this.refs.searchEditor.getText());
    }));

    this.disposables.add(atom.keymaps.onDidReloadKeymap(function () {
      _this.loadKeyBindings();
    }));
    this.disposables.add(atom.keymaps.onDidUnloadKeymap(function () {
      _this.loadKeyBindings();
    }));
    this.loadKeyBindings();
  }

  _createClass(KeybindingsPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'section',
          { className: 'keybinding-panel section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-heading icon icon-keyboard' },
            'Keybindings'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'text native-key-bindings', tabIndex: '-1' },
            _etch2['default'].dom('span', { className: 'icon icon-question' }),
            _etch2['default'].dom(
              'span',
              null,
              'You can override these keybindings by copying '
            ),
            _etch2['default'].dom('span', { className: 'icon icon-clippy' }),
            _etch2['default'].dom(
              'span',
              null,
              'and pasting them into '
            ),
            _etch2['default'].dom(
              'a',
              { className: 'link', onclick: this.didClickOpenKeymapFile },
              'your keymap file'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'editor-container' },
            _etch2['default'].dom(_atom.TextEditor, { mini: true, ref: 'searchEditor', placeholderText: 'Search keybindings' })
          ),
          _etch2['default'].dom(
            'table',
            { className: 'native-key-bindings table text', tabIndex: '-1' },
            _etch2['default'].dom('col', { className: 'keystroke' }),
            _etch2['default'].dom('col', { className: 'command' }),
            _etch2['default'].dom('col', { className: 'source' }),
            _etch2['default'].dom('col', { className: 'selector' }),
            _etch2['default'].dom(
              'thead',
              null,
              _etch2['default'].dom(
                'tr',
                null,
                _etch2['default'].dom(
                  'th',
                  { className: 'keystroke' },
                  'Keystroke'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'command' },
                  'Command'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'source' },
                  'Source'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'selector' },
                  'Selector'
                )
              )
            ),
            _etch2['default'].dom('tbody', { ref: 'keybindingRows' })
          )
        )
      );
    }
  }, {
    key: 'loadKeyBindings',
    value: function loadKeyBindings() {
      this.refs.keybindingRows.innerHTML = '';
      this.keyBindings = _underscorePlus2['default'].sortBy(atom.keymaps.getKeyBindings(), 'keystrokes');
      this.appendKeyBindings(this.keyBindings);
      this.filterKeyBindings(this.keyBindings, this.refs.searchEditor.getText());
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.searchEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'filterKeyBindings',
    value: function filterKeyBindings(keyBindings, filterString) {
      this.refs.keybindingRows.innerHTML = '';
      for (var keyBinding of keyBindings) {
        var selector = keyBinding.selector;
        var keystrokes = keyBinding.keystrokes;
        var command = keyBinding.command;
        var source = keyBinding.source;

        source = KeybindingsPanel.determineSource(source);
        var searchString = ('' + selector + keystrokes + command + source).toLowerCase();
        if (!searchString) {
          continue;
        }

        var keywords = filterString.trim().toLowerCase().split(' ');
        if (keywords.every(function (keyword) {
          return searchString.indexOf(keyword) !== -1;
        })) {
          this.appendKeyBinding(keyBinding);
        }
      }
    }
  }, {
    key: 'appendKeyBindings',
    value: function appendKeyBindings(keyBindings) {
      for (var keyBinding of keyBindings) {
        this.appendKeyBinding(keyBinding);
      }
    }
  }, {
    key: 'appendKeyBinding',
    value: function appendKeyBinding(keyBinding) {
      if (!this.showSelector(keyBinding.selector)) {
        return;
      }

      var element = this.elementForKeyBinding(keyBinding);
      element.dataset.keyBinding = keyBinding;
      this.refs.keybindingRows.appendChild(element);
    }
  }, {
    key: 'showSelector',
    value: function showSelector(selector) {
      var _this2 = this;

      var segments = undefined;
      if (selector) {
        segments = selector.split(',') || [];
      } else {
        segments = [];
      }

      return segments.some(function (s) {
        return _this2.platformPattern.test(s) || !_this2.otherPlatformPattern.test(s);
      });
    }
  }, {
    key: 'elementForKeyBinding',
    value: function elementForKeyBinding(keyBinding) {
      var selector = keyBinding.selector;
      var keystrokes = keyBinding.keystrokes;
      var command = keyBinding.command;
      var source = keyBinding.source;

      source = KeybindingsPanel.determineSource(source);

      var tr = document.createElement('tr');
      if (source === 'User') {
        tr.classList.add('is-user');
      }

      var keystrokeTd = document.createElement('td');
      keystrokeTd.classList.add('keystroke');

      var copyIcon = document.createElement('span');
      copyIcon.classList.add('icon', 'icon-clippy', 'copy-icon');
      copyIcon.onclick = function () {
        var content = undefined;
        var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());

        var escapeCSON = function escapeCSON(input) {
          return JSON.stringify(input).slice(1, -1) // Remove wrapping double quotes
          .replace(/\\"/g, '"') // Unescape double quotes
          .replace(/'/g, '\\\''); // Escape single quotes
        };

        if (keymapExtension === '.cson') {
          content = '\'' + escapeCSON(selector) + '\':\n  \'' + escapeCSON(keystrokes) + '\': \'' + escapeCSON(command) + '\'';
        } else {
          content = JSON.stringify(selector) + ': {\n  ' + JSON.stringify(keystrokes) + ': ' + JSON.stringify(command) + '\n}';
        }
        return atom.clipboard.write(content);
      };
      keystrokeTd.appendChild(copyIcon);

      var keystrokesSpan = document.createElement('span');
      keystrokesSpan.textContent = keystrokes;
      keystrokeTd.appendChild(keystrokesSpan);
      tr.appendChild(keystrokeTd);

      var commandTd = document.createElement('td');
      commandTd.classList.add('command');
      commandTd.textContent = command;
      tr.appendChild(commandTd);

      var sourceTd = document.createElement('td');
      sourceTd.classList.add('source');
      sourceTd.textContent = source;
      tr.appendChild(sourceTd);

      var selectorTd = document.createElement('td');
      selectorTd.classList.add('selector');
      selectorTd.textContent = selector;
      tr.appendChild(selectorTd);

      return tr;
    }
  }, {
    key: 'didClickOpenKeymapFile',
    value: function didClickOpenKeymapFile(e) {
      e.preventDefault();
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open-your-keymap');
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }

    // Private: Returns a user friendly description of where a keybinding was
    // loaded from.
    //
    // * filePath:
    //   The absolute path from which the keymap was loaded
    //
    // Returns one of:
    // * `Core` indicates it comes from a bundled package.
    // * `User` indicates that it was defined by a user.
    // * `<package-name>` the package which defined it.
    // * `Unknown` if an invalid path was passed in.
  }], [{
    key: 'determineSource',
    value: function determineSource(filePath) {
      if (!filePath) {
        return 'Unknown';
      }

      if (filePath.indexOf(_path2['default'].join(atom.getLoadSettings().resourcePath, 'keymaps')) === 0) {
        return 'Core';
      } else if (filePath === atom.keymaps.getUserKeymapPath()) {
        return 'User';
      } else {
        var pathParts = filePath.split(_path2['default'].sep);
        var packageNameIndex = pathParts.length - 3;
        var packageName = pathParts[packageNameIndex] != null ? pathParts[packageNameIndex] : '';
        return _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(packageName));
      }
    }
  }]);

  return KeybindingsPanel;
})();

exports['default'] = KeybindingsPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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