Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var ErrorView = (function () {
  function ErrorView(packageManager, _ref) {
    var _this = this;

    var message = _ref.message;
    var stderr = _ref.stderr;
    var packageInstallError = _ref.packageInstallError;

    _classCallCheck(this, ErrorView);

    _etch2['default'].initialize(this);

    this.isOutputHidden = true;
    this.refs.detailsArea.style.display = 'none';
    this.refs.details.textContent = stderr;
    this.refs.message.textContent = message;

    // Check for native build tools and show warning if missing.
    if (packageInstallError && process.platform === 'win32') {
      packageManager.checkNativeBuildTools()['catch'](function () {
        _this.refs.alert.appendChild(new CompileToolsErrorView().element);
      });
    }
  }

  _createClass(ErrorView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { className: 'error-message' },
        _etch2['default'].dom(
          'div',
          { ref: 'alert', className: 'alert alert-danger alert-dismissable native-key-bindings', tabIndex: '-1' },
          _etch2['default'].dom('button', { ref: 'close', className: 'close icon icon-x', onclick: function () {
              return _this2.destroy();
            } }),
          _etch2['default'].dom('span', { ref: 'message', className: 'native-key-bindings' }),
          _etch2['default'].dom(
            'a',
            { ref: 'detailsLink', className: 'alert-link error-link', onclick: function () {
                return _this2.toggleOutput();
              } },
            'Show output…'
          ),
          _etch2['default'].dom(
            'div',
            { ref: 'detailsArea', className: 'padded' },
            _etch2['default'].dom('pre', { ref: 'details', className: 'error-details text' })
          )
        )
      );
    }
  }, {
    key: 'toggleOutput',
    value: function toggleOutput() {
      if (this.isOutputHidden) {
        this.isOutputHidden = false;
        this.refs.detailsArea.style.display = '';
        this.refs.detailsLink.textContent = 'Hide output…';
      } else {
        this.isOutputHidden = true;
        this.refs.detailsArea.style.display = 'none';
        this.refs.detailsLink.textContent = 'Show output…';
      }
    }
  }]);

  return ErrorView;
})();

exports['default'] = ErrorView;

var CompileToolsErrorView = (function () {
  function CompileToolsErrorView() {
    _classCallCheck(this, CompileToolsErrorView);

    _etch2['default'].initialize(this);
  }

  _createClass(CompileToolsErrorView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        null,
        _etch2['default'].dom(
          'div',
          { className: 'icon icon-alert compile-tools-heading compile-tools-message' },
          'Compiler tools not found'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'compile-tools-message' },
          'Packages that depend on modules that contain C/C++ code will fail to install.'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'compile-tools-message' },
          _etch2['default'].dom(
            'span',
            null,
            'Read '
          ),
          _etch2['default'].dom(
            'a',
            { className: 'link', href: 'https://github.com/atom/atom/blob/master/docs/build-instructions/windows.md' },
            'here'
          ),
          _etch2['default'].dom(
            'span',
            null,
            ' for instructions on installing Python and Visual Studio.'
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'compile-tools-message' },
          _etch2['default'].dom(
            'span',
            null,
            'Run '
          ),
          _etch2['default'].dom(
            'code',
            { className: 'alert-danger' },
            'apm install --check'
          ),
          _etch2['default'].dom(
            'span',
            null,
            ' after installing to test compiling a native module.'
          )
        )
      );
    }
  }]);

  return CompileToolsErrorView;
})();

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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