Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var CollapsibleSectionPanel = (function () {
  function CollapsibleSectionPanel() {
    _classCallCheck(this, CollapsibleSectionPanel);
  }

  _createClass(CollapsibleSectionPanel, [{
    key: 'notHiddenCardsLength',
    value: function notHiddenCardsLength(sectionElement) {
      return sectionElement.querySelectorAll('.package-card:not(.hidden)').length;
    }
  }, {
    key: 'updateSectionCount',
    value: function updateSectionCount(headerElement, countElement, packageCount, totalCount) {
      if (totalCount != null) {
        countElement.textContent = packageCount + '/' + totalCount;
      } else {
        countElement.textContent = packageCount;
      }

      if (packageCount > 0) {
        headerElement.classList.add('has-items');
      }
    }
  }, {
    key: 'updateSectionCounts',
    value: function updateSectionCounts() {
      this.resetSectionHasItems();

      var filterText = this.refs.filterEditor.getText();
      if (filterText === '') {
        this.updateUnfilteredSectionCounts();
      } else {
        this.updateFilteredSectionCounts();
      }
    }
  }, {
    key: 'handleEvents',
    value: function handleEvents() {
      var _this = this;

      var handler = function handler(e) {
        var target = e.target.closest('.sub-section .has-items');
        if (target) {
          target.parentNode.classList.toggle('collapsed');
        }
      };
      this.element.addEventListener('click', handler);
      return new _atom.Disposable(function () {
        return _this.element.removeEventListener('click', handler);
      });
    }
  }, {
    key: 'resetCollapsibleSections',
    value: function resetCollapsibleSections(headerSections) {
      for (var headerSection of headerSections) {
        this.resetCollapsibleSection(headerSection);
      }
    }
  }, {
    key: 'resetCollapsibleSection',
    value: function resetCollapsibleSection(headerSection) {
      headerSection.classList.remove('has-items');
    }
  }]);

  return CollapsibleSectionPanel;
})();

exports['default'] = CollapsibleSectionPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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