/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

var invariant = require("fbjs/lib/invariant");

/**
 * A helper function to fetch the results of a query. Note that results for
 * fragment spreads are masked: fields must be explicitly listed in the query in
 * order to be accessible in the result object.
 */
function fetchRelayModernQuery(environment, taggedNode, variables, cacheConfig) {
  !environment.unstable_internal ? process.env.NODE_ENV !== "production" ? invariant(false, 'fetchRelayModernQuery: Expected a valid Relay environment, got `%s`.', environment) : invariant(false) : void 0;
  var _environment$unstable = environment.unstable_internal,
      createOperationDescriptor = _environment$unstable.createOperationDescriptor,
      getRequest = _environment$unstable.getRequest;
  var query = getRequest(taggedNode);

  if (query.params.operationKind !== 'query') {
    throw new Error('fetchRelayModernQuery: Expected query operation');
  }

  var operation = createOperationDescriptor(query, variables);
  return environment.execute({
    operation: operation,
    cacheConfig: cacheConfig
  }).map(function () {
    return environment.lookup(operation.fragment, operation).data;
  }).toPromise();
}

module.exports = fetchRelayModernQuery;