Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _electron = require('electron');

var _atom = require('atom');

var _url = require('url');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var GitHubFile = (function () {
  _createClass(GitHubFile, null, [{
    key: 'fromPath',

    // Public
    value: function fromPath(filePath) {
      return new GitHubFile(filePath);
    }
  }]);

  function GitHubFile(filePath) {
    _classCallCheck(this, GitHubFile);

    this.filePath = filePath;

    var _atom$project$relativizePath = atom.project.relativizePath(this.filePath);

    var _atom$project$relativizePath2 = _slicedToArray(_atom$project$relativizePath, 1);

    var rootDir = _atom$project$relativizePath2[0];

    if (rootDir != null) {
      var rootDirIndex = atom.project.getPaths().indexOf(rootDir);
      this.repo = atom.project.getRepositories()[rootDirIndex];
      this.type = 'none';
      if (this.repo && this.gitURL()) {
        if (this.isGitHubWikiURL(this.githubRepoURL())) {
          this.type = 'wiki';
        } else if (this.isGistURL(this.githubRepoURL())) {
          this.type = 'gist';
        } else {
          this.type = 'repo';
        }
      }
    }
  }

  // Public

  _createClass(GitHubFile, [{
    key: 'open',
    value: function open(lineRange) {
      if (this.validateRepo()) {
        this.openURLInBrowser(this.blobURL() + this.getLineRangeSuffix(lineRange));
      }
    }

    // Public
  }, {
    key: 'openOnMaster',
    value: function openOnMaster(lineRange) {
      if (this.validateRepo()) {
        this.openURLInBrowser(this.blobURLForMaster() + this.getLineRangeSuffix(lineRange));
      }
    }

    // Public
  }, {
    key: 'blame',
    value: function blame(lineRange) {
      if (this.validateRepo()) {
        if (this.type === 'repo') {
          this.openURLInBrowser(this.blameURL() + this.getLineRangeSuffix(lineRange));
        } else {
          atom.notifications.addWarning('Blames do not exist for ' + this.type + 's');
        }
      }
    }
  }, {
    key: 'history',
    value: function history() {
      if (this.validateRepo()) {
        this.openURLInBrowser(this.historyURL());
      }
    }
  }, {
    key: 'copyURL',
    value: function copyURL(lineRange) {
      if (this.validateRepo()) {
        atom.clipboard.write(this.shaURL() + this.getLineRangeSuffix(lineRange));
      }
    }
  }, {
    key: 'openBranchCompare',
    value: function openBranchCompare() {
      if (this.validateRepo()) {
        if (this.type === 'repo') {
          this.openURLInBrowser(this.branchCompareURL());
        } else {
          atom.notifications.addWarning('Branches do not exist for ' + this.type + 's');
        }
      }
    }
  }, {
    key: 'openIssues',
    value: function openIssues() {
      if (this.validateRepo()) {
        if (this.type === 'repo') {
          this.openURLInBrowser(this.issuesURL());
        } else {
          atom.notifications.addWarning('Issues do not exist for ' + this.type + 's');
        }
      }
    }
  }, {
    key: 'openPullRequests',
    value: function openPullRequests() {
      if (this.validateRepo()) {
        if (this.type === 'repo') {
          this.openURLInBrowser(this.pullRequestsURL());
        } else {
          atom.notifications.addWarning('Pull requests do not exist for ' + this.type + 's');
        }
      }
    }
  }, {
    key: 'openRepository',
    value: function openRepository() {
      if (this.validateRepo()) {
        this.openURLInBrowser(this.githubRepoURL());
      }
    }
  }, {
    key: 'getLineRangeSuffix',
    value: function getLineRangeSuffix(lineRange) {
      if (lineRange && this.type !== 'wiki' && atom.config.get('open-on-github.includeLineNumbersInUrls')) {
        lineRange = _atom.Range.fromObject(lineRange);
        var startRow = lineRange.start.row + 1;
        var endRow = lineRange.end.row + 1;

        if (startRow === endRow) {
          if (this.type === 'gist') {
            return '-L' + startRow;
          } else {
            return '#L' + startRow;
          }
        } else {
          if (this.type === 'gist') {
            return '-L' + startRow + '-L' + endRow;
          } else {
            return '#L' + startRow + '-L' + endRow;
          }
        }
      } else {
        return '';
      }
    }

    // Internal
  }, {
    key: 'validateRepo',
    value: function validateRepo() {
      if (!this.repo) {
        atom.notifications.addWarning('No repository found for path: ' + this.filePath + '.');
        return false;
      } else if (!this.gitURL()) {
        atom.notifications.addWarning('No URL defined for remote: ' + this.remoteName());
        return false;
      } else if (!this.githubRepoURL()) {
        atom.notifications.addWarning('Remote URL is not hosted on GitHub: ' + this.gitURL());
        return false;
      }
      return true;
    }

    // Internal
  }, {
    key: 'openURLInBrowser',
    value: function openURLInBrowser(url) {
      _electron.shell.openExternal(url);
    }

    // Internal
  }, {
    key: 'blobURL',
    value: function blobURL() {
      var gitHubRepoURL = this.githubRepoURL();
      var repoRelativePath = this.repoRelativePath();

      if (this.type === 'wiki') {
        return gitHubRepoURL + '/' + this.extractFileName(repoRelativePath);
      } else if (this.type === 'gist') {
        return gitHubRepoURL + '#file-' + this.encodeSegments(repoRelativePath.replace(/\./g, '-'));
      } else {
        return gitHubRepoURL + '/blob/' + this.remoteBranchName() + '/' + this.encodeSegments(repoRelativePath);
      }
    }

    // Internal
  }, {
    key: 'blobURLForMaster',
    value: function blobURLForMaster() {
      var gitHubRepoURL = this.githubRepoURL();

      if (this.type === 'repo') {
        return gitHubRepoURL + '/blob/master/' + this.encodeSegments(this.repoRelativePath());
      } else {
        return this.blobURL(); // Only repos have branches
      }
    }

    // Internal
  }, {
    key: 'shaURL',
    value: function shaURL() {
      var gitHubRepoURL = this.githubRepoURL();
      var encodedSHA = this.encodeSegments(this.sha());
      var repoRelativePath = this.repoRelativePath();

      if (this.type === 'wiki') {
        return gitHubRepoURL + '/' + this.extractFileName(repoRelativePath) + '/' + encodedSHA;
      } else if (this.type === 'gist') {
        return gitHubRepoURL + '/' + encodedSHA + '#file-' + this.encodeSegments(repoRelativePath.replace(/\./g, '-'));
      } else {
        return gitHubRepoURL + '/blob/' + encodedSHA + '/' + this.encodeSegments(repoRelativePath);
      }
    }

    // Internal
  }, {
    key: 'blameURL',
    value: function blameURL() {
      return this.githubRepoURL() + '/blame/' + this.remoteBranchName() + '/' + this.encodeSegments(this.repoRelativePath());
    }

    // Internal
  }, {
    key: 'historyURL',
    value: function historyURL() {
      var gitHubRepoURL = this.githubRepoURL();

      if (this.type === 'wiki') {
        return gitHubRepoURL + '/' + this.extractFileName(this.repoRelativePath()) + '/_history';
      } else if (this.type === 'gist') {
        return gitHubRepoURL + '/revisions';
      } else {
        return gitHubRepoURL + '/commits/' + this.remoteBranchName() + '/' + this.encodeSegments(this.repoRelativePath());
      }
    }

    // Internal
  }, {
    key: 'issuesURL',
    value: function issuesURL() {
      return this.githubRepoURL() + '/issues';
    }

    // Internal
  }, {
    key: 'pullRequestsURL',
    value: function pullRequestsURL() {
      return this.githubRepoURL() + '/pulls';
    }

    // Internal
  }, {
    key: 'branchCompareURL',
    value: function branchCompareURL() {
      return this.githubRepoURL() + '/compare/' + this.encodeSegments(this.branchName());
    }
  }, {
    key: 'encodeSegments',
    value: function encodeSegments() {
      var segments = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];

      return segments.split('/').map(function (segment) {
        return encodeURIComponent(segment);
      }).join('/');
    }

    // Internal
  }, {
    key: 'extractFileName',
    value: function extractFileName() {
      var relativePath = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];

      return _path2['default'].parse(relativePath).name;
    }

    // Internal
  }, {
    key: 'gitURL',
    value: function gitURL() {
      var remoteName = this.remoteName();
      if (remoteName != null) {
        return this.repo.getConfigValue('remote.' + remoteName + '.url', this.filePath);
      } else {
        return this.repo.getConfigValue('remote.origin.url', this.filePath);
      }
    }

    // Internal
  }, {
    key: 'githubRepoURL',
    value: function githubRepoURL() {
      var url = this.gitURL();

      if (url.match(/git@[^:]+:/)) {
        // git@github.com:user/repo.git
        url = url.replace(/^git@([^:]+):(.+)$/, function (match, host, repoPath) {
          repoPath = repoPath.replace(/^\/+/, '');
          return 'https://' + host + '/' + repoPath; // -> https://github.com/user/repo.git
        });
      } else if (url.match(/^ssh:\/\/git@([^/]+)\//)) {
          // ssh://git@github.com/user/repo.git
          url = 'https://' + url.substring(10); // -> https://github.com/user/repo.git
        } else if (url.match(/^git:\/\/[^/]+\//)) {
            // git://github.com/user/repo.git
            url = 'https' + url.substring(3); // -> https://github.com/user/repo.git
          } else if (url.match(/^https?:\/\/\w+@/)) {
              // https://user@github.com/user/repo.git
              url = url.replace(/^https?:\/\/\w+@/, 'https://'); // -> https://github.com/user/repo.git
            }

      // Remove trailing .git and trailing slashes
      url = url.replace(/\.git$/, '').replace(/\/+$/, '');
      // Change .wiki to /wiki
      url = url.replace(/\.wiki$/, '/wiki');

      if (!this.isBitbucketURL(url)) {
        return url;
      }
    }
  }, {
    key: 'isGistURL',
    value: function isGistURL(url) {
      try {
        var _parseURL = (0, _url.parse)(url);

        var host = _parseURL.host;

        return host === 'gist.github.com';
      } catch (error) {
        return false;
      }
    }
  }, {
    key: 'isGitHubWikiURL',
    value: function isGitHubWikiURL(url) {
      return (/\/wiki$/.test(url)
      );
    }
  }, {
    key: 'isBitbucketURL',
    value: function isBitbucketURL(url) {
      if (url.startsWith('git@bitbucket.org')) {
        return true;
      }

      try {
        var _parseURL2 = (0, _url.parse)(url);

        var host = _parseURL2.host;

        return host === 'bitbucket.org';
      } catch (error) {
        return false;
      }
    }

    // Internal
  }, {
    key: 'repoRelativePath',
    value: function repoRelativePath() {
      return this.repo.getRepo(this.filePath).relativize(this.filePath);
    }

    // Internal
  }, {
    key: 'remoteName',
    value: function remoteName() {
      var gitConfigRemote = this.repo.getConfigValue('atom.open-on-github.remote', this.filePath);

      if (gitConfigRemote) {
        return gitConfigRemote;
      }

      var shortBranch = this.repo.getShortHead(this.filePath);

      if (!shortBranch) {
        return null;
      }

      var branchRemote = this.repo.getConfigValue('branch.' + shortBranch + '.remote', this.filePath);

      if (branchRemote && branchRemote.length > 0) {
        return branchRemote;
      }

      return null;
    }

    // Internal
  }, {
    key: 'sha',
    value: function sha() {
      return this.repo.getReferenceTarget('HEAD', this.filePath);
    }

    // Internal
  }, {
    key: 'branchName',
    value: function branchName() {
      var shortBranch = this.repo.getShortHead(this.filePath);

      if (!shortBranch) {
        return null;
      }

      var branchMerge = this.repo.getConfigValue('branch.' + shortBranch + '.merge', this.filePath);
      if (!(branchMerge && branchMerge.length > 11)) {
        return shortBranch;
      }

      if (branchMerge.indexOf('refs/heads/') !== 0) {
        return shortBranch;
      }

      return branchMerge.substring(11);
    }

    // Internal
  }, {
    key: 'remoteBranchName',
    value: function remoteBranchName() {
      var gitConfigBranch = this.repo.getConfigValue('atom.open-on-github.branch', this.filePath);

      if (gitConfigBranch) {
        return gitConfigBranch;
      } else if (this.remoteName() != null) {
        return this.encodeSegments(this.branchName());
      } else {
        return 'master';
      }
    }
  }]);

  return GitHubFile;
})();

exports['default'] = GitHubFile;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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