Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var KeyBindingResolverView = (function () {
  function KeyBindingResolverView() {
    var _this = this;

    _classCallCheck(this, KeyBindingResolverView);

    this.keystrokes = null;
    this.usedKeyBinding = null;
    this.unusedKeyBindings = [];
    this.unmatchedKeyBindings = [];
    this.partiallyMatchedBindings = [];
    this.attached = false;
    this.disposables = new _atom.CompositeDisposable();
    this.keybindingDisposables = new _atom.CompositeDisposable();

    this.disposables.add(atom.workspace.getBottomDock().observeActivePaneItem(function (item) {
      if (item === _this) {
        _this.attach();
      } else {
        _this.detach();
      }
    }));

    this.disposables.add(atom.workspace.getBottomDock().observeVisible(function (visible) {
      if (visible) {
        if (atom.workspace.getBottomDock().getActivePaneItem() === _this) _this.attach();
      } else {
        _this.detach();
      }
    }));

    _etch2['default'].initialize(this);
  }

  _createClass(KeyBindingResolverView, [{
    key: 'getTitle',
    value: function getTitle() {
      return 'Key Binding Resolver';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'keyboard';
    }
  }, {
    key: 'getDefaultLocation',
    value: function getDefaultLocation() {
      return 'bottom';
    }
  }, {
    key: 'getAllowedLocations',
    value: function getAllowedLocations() {
      // TODO: Support left and right possibly
      return ['bottom'];
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return 'atom://keybinding-resolver';
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: 'keybinding-resolver/KeyBindingResolverView'
      };
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.detach();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'attach',
    value: function attach() {
      var _this2 = this;

      if (this.attached) return;

      this.attached = true;
      this.keybindingDisposables = new _atom.CompositeDisposable();
      this.keybindingDisposables.add(atom.keymaps.onDidMatchBinding(function (_ref) {
        var keystrokes = _ref.keystrokes;
        var binding = _ref.binding;
        var keyboardEventTarget = _ref.keyboardEventTarget;
        var eventType = _ref.eventType;

        if (eventType === 'keyup' && binding == null) {
          return;
        }

        var unusedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes, target: keyboardEventTarget }).filter(function (b) {
          return b !== binding;
        });

        var unmatchedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes }).filter(function (b) {
          return b !== binding && !unusedKeyBindings.includes(b);
        });

        _this2.update({ usedKeyBinding: binding, unusedKeyBindings: unusedKeyBindings, unmatchedKeyBindings: unmatchedKeyBindings, keystrokes: keystrokes });
      }));

      this.keybindingDisposables.add(atom.keymaps.onDidPartiallyMatchBindings(function (_ref2) {
        var keystrokes = _ref2.keystrokes;
        var partiallyMatchedBindings = _ref2.partiallyMatchedBindings;

        _this2.update({ keystrokes: keystrokes, partiallyMatchedBindings: partiallyMatchedBindings });
      }));

      this.keybindingDisposables.add(atom.keymaps.onDidFailToMatchBinding(function (_ref3) {
        var keystrokes = _ref3.keystrokes;
        var keyboardEventTarget = _ref3.keyboardEventTarget;
        var eventType = _ref3.eventType;

        if (eventType === 'keyup') {
          return;
        }

        var unusedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes, target: keyboardEventTarget });
        var unmatchedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes }).filter(function (b) {
          return !unusedKeyBindings.includes(b);
        });

        _this2.update({ unusedKeyBindings: unusedKeyBindings, unmatchedKeyBindings: unmatchedKeyBindings, keystrokes: keystrokes });
      }));
    }
  }, {
    key: 'detach',
    value: function detach() {
      if (!this.attached) return;

      this.attached = false;
      this.keybindingDisposables.dispose();
      this.keybindingDisposables = null;
    }
  }, {
    key: 'update',
    value: function update(props) {
      this.keystrokes = props.keystrokes;
      this.usedKeyBinding = props.usedKeyBinding;
      this.unusedKeyBindings = props.unusedKeyBindings || [];
      this.unmatchedKeyBindings = props.unmatchedKeyBindings || [];
      this.partiallyMatchedBindings = props.partiallyMatchedBindings || [];
      return _etch2['default'].update(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'key-binding-resolver' },
        _etch2['default'].dom(
          'div',
          { className: 'panel-heading' },
          this.renderKeystrokes()
        ),
        _etch2['default'].dom(
          'div',
          { className: 'panel-body' },
          this.renderKeyBindings()
        )
      );
    }
  }, {
    key: 'renderKeystrokes',
    value: function renderKeystrokes() {
      if (this.keystrokes) {
        if (this.partiallyMatchedBindings.length > 0) {
          return _etch2['default'].dom(
            'span',
            { className: 'keystroke highlight-info' },
            this.keystrokes,
            ' (partial)'
          );
        } else {
          return _etch2['default'].dom(
            'span',
            { className: 'keystroke highlight-info' },
            this.keystrokes
          );
        }
      } else {
        return _etch2['default'].dom(
          'span',
          null,
          'Press any key'
        );
      }
    }
  }, {
    key: 'renderKeyBindings',
    value: function renderKeyBindings() {
      var _this3 = this;

      if (this.partiallyMatchedBindings.length > 0) {
        return _etch2['default'].dom(
          'table',
          { className: 'table-condensed' },
          _etch2['default'].dom(
            'tbody',
            null,
            this.partiallyMatchedBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unused' },
                _etch2['default'].dom(
                  'td',
                  { className: 'copy', onclick: function () {
                      return _this3.copyKeybinding(binding);
                    } },
                  _etch2['default'].dom('span', { className: 'icon icon-clippy' })
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'keystrokes' },
                  binding.keystrokes
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this3.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            })
          )
        );
      } else {
        var usedKeyBinding = '';
        if (this.usedKeyBinding) {
          usedKeyBinding = _etch2['default'].dom(
            'tr',
            { className: 'used' },
            _etch2['default'].dom(
              'td',
              { className: 'copy', onclick: function () {
                  return _this3.copyKeybinding(_this3.usedKeyBinding);
                } },
              _etch2['default'].dom('span', { className: 'icon icon-clippy' })
            ),
            _etch2['default'].dom(
              'td',
              { className: 'command' },
              this.usedKeyBinding.command
            ),
            _etch2['default'].dom(
              'td',
              { className: 'selector' },
              this.usedKeyBinding.selector
            ),
            _etch2['default'].dom(
              'td',
              { className: 'source', onclick: function () {
                  return _this3.openKeybindingFile(_this3.usedKeyBinding.source);
                } },
              this.usedKeyBinding.source
            )
          );
        }
        return _etch2['default'].dom(
          'table',
          { className: 'table-condensed' },
          _etch2['default'].dom(
            'tbody',
            null,
            usedKeyBinding,
            this.unusedKeyBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unused' },
                _etch2['default'].dom(
                  'td',
                  { className: 'copy', onclick: function () {
                      return _this3.copyKeybinding(binding);
                    } },
                  _etch2['default'].dom('span', { className: 'icon icon-clippy' })
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this3.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            }),
            this.unmatchedKeyBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unmatched' },
                _etch2['default'].dom(
                  'td',
                  { className: 'copy', onclick: function () {
                      return _this3.copyKeybinding(binding);
                    } },
                  _etch2['default'].dom('span', { className: 'icon icon-clippy' })
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this3.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            })
          )
        );
      }
    }
  }, {
    key: 'isInAsarArchive',
    value: function isInAsarArchive(pathToCheck) {
      var _atom$getLoadSettings = atom.getLoadSettings();

      var resourcePath = _atom$getLoadSettings.resourcePath;

      return pathToCheck.startsWith('' + resourcePath + _path2['default'].sep) && _path2['default'].extname(resourcePath) === '.asar';
    }
  }, {
    key: 'extractBundledKeymap',
    value: function extractBundledKeymap(bundledKeymapPath) {
      var metadata = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'package.json'));
      var bundledKeymaps = metadata ? metadata._atomKeymaps : {};
      var keymapName = _path2['default'].basename(bundledKeymapPath);
      var extractedKeymapPath = _path2['default'].join(require('temp').mkdirSync('atom-bundled-keymap-'), keymapName);
      _fsPlus2['default'].writeFileSync(extractedKeymapPath, JSON.stringify(bundledKeymaps[keymapName] || {}, null, 2));
      return extractedKeymapPath;
    }
  }, {
    key: 'extractBundledPackageKeymap',
    value: function extractBundledPackageKeymap(keymapRelativePath) {
      var packageName = keymapRelativePath.split(_path2['default'].sep)[1];
      var keymapName = _path2['default'].basename(keymapRelativePath);
      var metadata = atom.packages.packagesCache[packageName] || {};
      var keymaps = metadata.keymaps || {};
      var extractedKeymapPath = _path2['default'].join(require('temp').mkdirSync('atom-bundled-keymap-'), keymapName);
      _fsPlus2['default'].writeFileSync(extractedKeymapPath, JSON.stringify(keymaps[keymapRelativePath] || {}, null, 2));
      return extractedKeymapPath;
    }
  }, {
    key: 'openKeybindingFile',
    value: function openKeybindingFile(keymapPath) {
      if (this.isInAsarArchive(keymapPath)) {
        keymapPath = this.extractBundledKeymap(keymapPath);
      } else if (keymapPath.startsWith('core:node_modules')) {
        keymapPath = this.extractBundledPackageKeymap(keymapPath.replace('core:', ''));
      } else if (keymapPath.startsWith('core:')) {
        keymapPath = this.extractBundledKeymap(keymapPath.replace('core:', ''));
      }

      atom.workspace.open(keymapPath);
    }
  }, {
    key: 'copyKeybinding',
    value: function copyKeybinding(binding) {
      var content = undefined;
      var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
      var escapedKeystrokes = binding.keystrokes.replace(/\\/g, '\\\\'); // Escape backslashes
      if (keymapExtension === '.cson') {
        content = '\'' + binding.selector + '\':\n  \'' + escapedKeystrokes + '\': \'' + binding.command + '\'\n';
      } else {
        content = '"' + binding.selector + '": {\n  "' + escapedKeystrokes + '": "' + binding.command + '"\n}\n';
      }

      atom.notifications.addInfo('Keybinding Copied');
      return atom.clipboard.write(content);
    }
  }]);

  return KeyBindingResolverView;
})();

exports['default'] = KeyBindingResolverView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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