Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _viewUri = require('./view-uri');

var _viewUri2 = _interopRequireDefault(_viewUri);

var REBUILDING = 'rebuilding';
var REBUILD_FAILED = 'rebuild-failed';
var REBUILD_SUCCEEDED = 'rebuild-succeeded';

var IncompatiblePackagesComponent = (function () {
  function IncompatiblePackagesComponent(packageManager) {
    var _this = this;

    _classCallCheck(this, IncompatiblePackagesComponent);

    this.rebuildStatuses = new Map();
    this.rebuildFailureOutputs = new Map();
    this.rebuildInProgress = false;
    this.rebuiltPackageCount = 0;
    this.packageManager = packageManager;
    this.loaded = false;
    _etch2['default'].initialize(this);

    if (this.packageManager.getActivePackages().length > 0) {
      this.populateIncompatiblePackages();
    } else {
      global.setImmediate(this.populateIncompatiblePackages.bind(this));
    }

    this.element.addEventListener('click', function (event) {
      if (event.target === _this.refs.rebuildButton) {
        _this.rebuildIncompatiblePackages();
      } else if (event.target === _this.refs.reloadButton) {
        atom.reload();
      } else if (event.target.classList.contains('view-settings')) {
        atom.workspace.open('atom://config/packages/' + event.target['package'].name);
      }
    });
  }

  _createClass(IncompatiblePackagesComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      if (!this.loaded) {
        return _etch2['default'].dom(
          'div',
          { className: 'incompatible-packages padded' },
          'Loading...'
        );
      }

      return _etch2['default'].dom(
        'div',
        {
          className: 'incompatible-packages padded native-key-bindings',
          tabIndex: '-1'
        },
        this.renderHeading(),
        this.renderIncompatiblePackageList()
      );
    }
  }, {
    key: 'renderHeading',
    value: function renderHeading() {
      if (this.incompatiblePackages.length > 0) {
        if (this.rebuiltPackageCount > 0) {
          var alertClass = this.rebuiltPackageCount === this.incompatiblePackages.length ? 'alert-success icon-check' : 'alert-warning icon-bug';

          return _etch2['default'].dom(
            'div',
            { className: 'alert icon ' + alertClass },
            this.rebuiltPackageCount,
            ' of ',
            this.incompatiblePackages.length,
            ' ',
            'packages were rebuilt successfully. Reload Atom to activate them.',
            _etch2['default'].dom(
              'button',
              { ref: 'reloadButton', className: 'btn pull-right' },
              'Reload Atom'
            )
          );
        } else {
          return _etch2['default'].dom(
            'div',
            { className: 'alert alert-danger icon icon-bug' },
            'Some installed packages could not be loaded because they contain native modules that were compiled for an earlier version of Atom.',
            _etch2['default'].dom(
              'button',
              {
                ref: 'rebuildButton',
                className: 'btn pull-right',
                disabled: this.rebuildInProgress
              },
              'Rebuild Packages'
            )
          );
        }
      } else {
        return _etch2['default'].dom(
          'div',
          { className: 'alert alert-success icon icon-check' },
          'None of your packages contain incompatible native modules.'
        );
      }
    }
  }, {
    key: 'renderIncompatiblePackageList',
    value: function renderIncompatiblePackageList() {
      return _etch2['default'].dom(
        'div',
        null,
        this.incompatiblePackages.map(this.renderIncompatiblePackage.bind(this))
      );
    }
  }, {
    key: 'renderIncompatiblePackage',
    value: function renderIncompatiblePackage(pack) {
      var rebuildStatus = this.rebuildStatuses.get(pack);

      return _etch2['default'].dom(
        'div',
        { className: 'incompatible-package' },
        this.renderRebuildStatusIndicator(rebuildStatus),
        _etch2['default'].dom(
          'button',
          {
            className: 'btn view-settings icon icon-gear pull-right',
            'package': pack
          },
          'Package Settings'
        ),
        _etch2['default'].dom(
          'h4',
          { className: 'heading' },
          pack.name,
          ' ',
          pack.metadata.version
        ),
        rebuildStatus ? this.renderRebuildOutput(pack) : this.renderIncompatibleModules(pack)
      );
    }
  }, {
    key: 'renderRebuildStatusIndicator',
    value: function renderRebuildStatusIndicator(rebuildStatus) {
      if (rebuildStatus === REBUILDING) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-info pull-right icon icon-gear' },
          'Rebuilding'
        );
      } else if (rebuildStatus === REBUILD_SUCCEEDED) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-success pull-right icon icon-check' },
          'Rebuild Succeeded'
        );
      } else if (rebuildStatus === REBUILD_FAILED) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-error pull-right icon icon-x' },
          'Rebuild Failed'
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'renderRebuildOutput',
    value: function renderRebuildOutput(pack) {
      if (this.rebuildStatuses.get(pack) === REBUILD_FAILED) {
        return _etch2['default'].dom(
          'pre',
          null,
          this.rebuildFailureOutputs.get(pack)
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'renderIncompatibleModules',
    value: function renderIncompatibleModules(pack) {
      return _etch2['default'].dom(
        'ul',
        null,
        pack.incompatibleModules.map(function (nativeModule) {
          return _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom(
              'div',
              { className: 'icon icon-file-binary' },
              nativeModule.name,
              '@',
              nativeModule.version || 'unknown',
              ' –',
              ' ',
              _etch2['default'].dom(
                'span',
                { className: 'text-warning' },
                nativeModule.error
              )
            )
          );
        })
      );
    }
  }, {
    key: 'populateIncompatiblePackages',
    value: function populateIncompatiblePackages() {
      this.incompatiblePackages = this.packageManager.getLoadedPackages().filter(function (pack) {
        return !pack.isCompatible();
      });

      for (var pack of this.incompatiblePackages) {
        var buildFailureOutput = pack.getBuildFailureOutput();
        if (buildFailureOutput) {
          this.setPackageStatus(pack, REBUILD_FAILED);
          this.setRebuildFailureOutput(pack, buildFailureOutput);
        }
      }

      this.loaded = true;
      _etch2['default'].update(this);
    }
  }, {
    key: 'rebuildIncompatiblePackages',
    value: _asyncToGenerator(function* () {
      this.rebuildInProgress = true;
      var rebuiltPackageCount = 0;
      for (var pack of this.incompatiblePackages) {
        this.setPackageStatus(pack, REBUILDING);

        var _ref = yield pack.rebuild();

        var code = _ref.code;
        var stderr = _ref.stderr;

        if (code === 0) {
          this.setPackageStatus(pack, REBUILD_SUCCEEDED);
          rebuiltPackageCount++;
        } else {
          this.setRebuildFailureOutput(pack, stderr);
          this.setPackageStatus(pack, REBUILD_FAILED);
        }
      }
      this.rebuildInProgress = false;
      this.rebuiltPackageCount = rebuiltPackageCount;
      _etch2['default'].update(this);
    })
  }, {
    key: 'setPackageStatus',
    value: function setPackageStatus(pack, status) {
      this.rebuildStatuses.set(pack, status);
      _etch2['default'].update(this);
    }
  }, {
    key: 'setRebuildFailureOutput',
    value: function setRebuildFailureOutput(pack, output) {
      this.rebuildFailureOutputs.set(pack, output);
      _etch2['default'].update(this);
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Incompatible Packages';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return _viewUri2['default'];
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'package';
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return { deserializer: 'IncompatiblePackagesComponent' };
    }
  }]);

  return IncompatiblePackagesComponent;
})();

exports['default'] = IncompatiblePackagesComponent;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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