Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _atom = require('atom');

'use babel';

var GoToLineView = (function () {
  function GoToLineView() {
    var _this = this;

    _classCallCheck(this, GoToLineView);

    this.miniEditor = new _atom.TextEditor({ mini: true });
    this.miniEditor.element.addEventListener('blur', this.close.bind(this));

    this.message = document.createElement('div');
    this.message.classList.add('message');

    this.element = document.createElement('div');
    this.element.classList.add('go-to-line');
    this.element.appendChild(this.miniEditor.element);
    this.element.appendChild(this.message);

    this.panel = atom.workspace.addModalPanel({
      item: this,
      visible: false
    });
    atom.commands.add('atom-text-editor', 'go-to-line:toggle', function () {
      _this.toggle();
      return false;
    });
    atom.commands.add(this.miniEditor.element, 'core:confirm', function () {
      _this.navigate();
    });
    atom.commands.add(this.miniEditor.element, 'core:cancel', function () {
      _this.close();
    });
    this.miniEditor.onWillInsertText(function (arg) {
      if (arg.text.match(/[^0-9:]/)) {
        arg.cancel();
      }
    });
    this.miniEditor.onDidChange(function () {
      _this.navigate({ keepOpen: true });
    });
  }

  _createClass(GoToLineView, [{
    key: 'toggle',
    value: function toggle() {
      this.panel.isVisible() ? this.close() : this.open();
    }
  }, {
    key: 'close',
    value: function close() {
      if (!this.panel.isVisible()) return;
      this.miniEditor.setText('');
      this.panel.hide();
      if (this.miniEditor.element.hasFocus()) {
        this.restoreFocus();
      }
    }
  }, {
    key: 'navigate',
    value: function navigate() {
      var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      var lineNumber = this.miniEditor.getText();
      var editor = atom.workspace.getActiveTextEditor();
      if (!options.keepOpen) {
        this.close();
      }
      if (!editor || !lineNumber.length) return;

      var currentRow = editor.getCursorBufferPosition().row;
      var rowLineNumber = lineNumber.split(/:+/)[0] || '';
      var row = rowLineNumber.length > 0 ? parseInt(rowLineNumber) - 1 : currentRow;
      var columnLineNumber = lineNumber.split(/:+/)[1] || '';
      var column = columnLineNumber.length > 0 ? parseInt(columnLineNumber) - 1 : -1;

      var position = new _atom.Point(row, column);
      editor.setCursorBufferPosition(position);
      editor.unfoldBufferRow(row);
      if (column < 0) {
        editor.moveToFirstCharacterOfLine();
      }
      editor.scrollToBufferPosition(position, {
        center: true
      });
    }
  }, {
    key: 'storeFocusedElement',
    value: function storeFocusedElement() {
      this.previouslyFocusedElement = document.activeElement;
      return this.previouslyFocusedElement;
    }
  }, {
    key: 'restoreFocus',
    value: function restoreFocus() {
      if (this.previouslyFocusedElement && this.previouslyFocusedElement.parentElement) {
        return this.previouslyFocusedElement.focus();
      }
      atom.views.getView(atom.workspace).focus();
    }
  }, {
    key: 'open',
    value: function open() {
      if (this.panel.isVisible() || !atom.workspace.getActiveTextEditor()) return;
      this.storeFocusedElement();
      this.panel.show();
      this.message.textContent = 'Enter a <row> or <row>:<column> to go there. Examples: "3" for row 3 or "2:7" for row 2 and column 7';
      this.miniEditor.element.focus();
    }
  }]);

  return GoToLineView;
})();

exports['default'] = {
  activate: function activate() {
    return new GoToLineView();
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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