"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.watchWorkspaceItem = watchWorkspaceItem;

var _atom = require("atom");

var _uriPattern = _interopRequireDefault(require("./atom/uri-pattern"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ItemWatcher {
  constructor(workspace, pattern, component, stateKey) {
    _defineProperty(this, "updateActiveState", () => {
      const wasActive = this.activeItem;
      this.activeItem = this.isActiveItem(); // Update the component's state if it's changed as a result

      if (wasActive && !this.activeItem) {
        return new Promise(resolve => this.component.setState({
          [this.stateKey]: false
        }, resolve));
      } else if (!wasActive && this.activeItem) {
        return new Promise(resolve => this.component.setState({
          [this.stateKey]: true
        }, resolve));
      } else {
        return Promise.resolve();
      }
    });

    _defineProperty(this, "itemMatches", item => item && item.getURI && this.pattern.matches(item.getURI()).ok());

    this.workspace = workspace;
    this.pattern = pattern instanceof _uriPattern["default"] ? pattern : new _uriPattern["default"](pattern);
    this.component = component;
    this.stateKey = stateKey;
    this.activeItem = this.isActiveItem();
    this.subs = new _atom.CompositeDisposable();
  }

  isActiveItem() {
    for (const pane of this.workspace.getPanes()) {
      if (this.itemMatches(pane.getActiveItem())) {
        return true;
      }
    }

    return false;
  }

  setInitialState() {
    if (!this.component.state) {
      this.component.state = {};
    }

    this.component.state[this.stateKey] = this.activeItem;
    return this;
  }

  subscribeToWorkspace() {
    this.subs.dispose();
    this.subs = new _atom.CompositeDisposable(this.workspace.getCenter().onDidChangeActivePaneItem(this.updateActiveState));
    return this;
  }

  setPattern(pattern) {
    this.pattern = pattern instanceof _uriPattern["default"] ? pattern : new _uriPattern["default"](pattern);
    return this.updateActiveState();
  }

  dispose() {
    this.subs.dispose();
  }

}

function watchWorkspaceItem(workspace, pattern, component, stateKey) {
  return new ItemWatcher(workspace, pattern, component, stateKey).setInitialState().subscribeToWorkspace();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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