"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueCommentView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../timeago"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../github-dotcom-markdown"));

var _helpers = require("../../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueCommentView extends _react["default"].Component {
  render() {
    const comment = this.props.item;
    const author = comment.author || _helpers.GHOST_USER;
    return _react["default"].createElement("div", {
      className: "issue timeline-item"
    }, _react["default"].createElement("div", {
      className: "info-row"
    }, _react["default"].createElement(_octicon["default"], {
      className: "pre-timeline-item-icon",
      icon: "comment"
    }), _react["default"].createElement("img", {
      className: "author-avatar",
      src: author.avatarUrl,
      alt: author.login,
      title: author.login
    }), _react["default"].createElement("span", {
      className: "comment-message-header"
    }, author.login, " commented", ' ', _react["default"].createElement("a", {
      href: comment.url
    }, _react["default"].createElement(_timeago["default"], {
      time: comment.createdAt
    })))), _react["default"].createElement(_githubDotcomMarkdown["default"], {
      html: comment.bodyHTML,
      switchToIssueish: this.props.switchToIssueish
    }));
  }

}

exports.BareIssueCommentView = BareIssueCommentView;

_defineProperty(BareIssueCommentView, "propTypes", {
  switchToIssueish: _propTypes["default"].func.isRequired,
  item: _propTypes["default"].shape({
    author: _propTypes["default"].shape({
      avatarUrl: _propTypes["default"].string.isRequired,
      login: _propTypes["default"].string.isRequired
    }),
    bodyHTML: _propTypes["default"].string.isRequired,
    createdAt: _propTypes["default"].string.isRequired,
    url: _propTypes["default"].string.isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueCommentView, {
  item: function () {
    const node = require("./__generated__/issueCommentView_item.graphql");

    if (node.hash && node.hash !== "adc36c52f51de14256693ab9e4eb84bb") {
      console.error("The definition of 'issueCommentView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueCommentView_item.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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