"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCommitsView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _commitView = _interopRequireDefault(require("./commit-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommitsView extends _react["default"].Component {
  render() {
    return _react["default"].createElement("div", {
      className: "timeline-item commits"
    }, this.renderSummary(), this.renderCommits());
  }

  renderSummary() {
    if (this.props.nodes.length > 1) {
      const namesString = this.calculateNames(this.getCommits());
      return _react["default"].createElement("div", {
        className: "info-row"
      }, _react["default"].createElement(_octicon["default"], {
        className: "pre-timeline-item-icon",
        icon: "repo-push"
      }), _react["default"].createElement("span", {
        className: "comment-message-header"
      }, namesString, " added some commits..."));
    } else {
      return null;
    }
  }

  renderCommits() {
    return this.getCommits().map(commit => {
      return _react["default"].createElement(_commitView["default"], {
        key: commit.id,
        commit: commit,
        onBranch: this.props.onBranch,
        openCommit: this.props.openCommit
      });
    });
  }

  getCommits() {
    return this.props.nodes.map(n => n.commit);
  }

  calculateNames(commits) {
    let names = new Set();
    commits.forEach(commit => {
      let name = null;

      if (commit.author.user) {
        name = commit.author.user.login;
      } else if (commit.author.name) {
        name = commit.author.name;
      }

      if (name && !names.has(name)) {
        names.add(name);
      }
    });
    names = Array.from(names);

    if (names.length === 1) {
      return names[0];
    } else if (names.length === 2) {
      return `${names[0]} and ${names[1]}`;
    } else if (names.length > 2) {
      return `${names[0]}, ${names[1]}, and others`;
    } else {
      return 'Someone';
    }
  }

}

exports.BareCommitsView = BareCommitsView;

_defineProperty(BareCommitsView, "propTypes", {
  nodes: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    commit: _propTypes["default"].shape({
      author: _propTypes["default"].shape({
        name: _propTypes["default"].string,
        user: _propTypes["default"].shape({
          login: _propTypes["default"].string.isRequired
        })
      }).isRequired
    }).isRequired
  }).isRequired).isRequired,
  onBranch: _propTypes["default"].bool.isRequired,
  openCommit: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommitsView, {
  nodes: function () {
    const node = require("./__generated__/commitsView_nodes.graphql");

    if (node.hash && node.hash !== "5b2734f1e64af2ad2c9803201a0082f3") {
      console.error("The definition of 'commitsView_nodes' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commitsView_nodes.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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