"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCommitCommentView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../timeago"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../github-dotcom-markdown"));

var _helpers = require("../../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommitCommentView extends _react["default"].Component {
  render() {
    const comment = this.props.item;
    const author = comment.author || _helpers.GHOST_USER;
    return _react["default"].createElement("div", {
      className: "issue"
    }, _react["default"].createElement("div", {
      className: "info-row"
    }, this.props.isReply ? null : _react["default"].createElement(_octicon["default"], {
      className: "pre-timeline-item-icon",
      icon: "comment"
    }), _react["default"].createElement("img", {
      className: "author-avatar",
      src: author.avatarUrl,
      alt: author.login,
      title: author.login
    }), this.renderHeader(comment, author)), _react["default"].createElement(_githubDotcomMarkdown["default"], {
      html: comment.bodyHTML,
      switchToIssueish: this.props.switchToIssueish
    }));
  }

  renderHeader(comment, author) {
    if (this.props.isReply) {
      return _react["default"].createElement("span", {
        className: "comment-message-header"
      }, author.login, " replied ", _react["default"].createElement(_timeago["default"], {
        time: comment.createdAt
      }));
    } else {
      return _react["default"].createElement("span", {
        className: "comment-message-header"
      }, author.login, " commented ", this.renderPath(), " in", ' ', comment.commit.oid.substr(0, 7), " ", _react["default"].createElement(_timeago["default"], {
        time: comment.createdAt
      }));
    }
  }

  renderPath() {
    if (this.props.item.path) {
      return _react["default"].createElement("span", null, "on ", _react["default"].createElement("code", null, this.props.item.path));
    } else {
      return null;
    }
  }

}

exports.BareCommitCommentView = BareCommitCommentView;

_defineProperty(BareCommitCommentView, "propTypes", {
  item: _propTypes["default"].object.isRequired,
  isReply: _propTypes["default"].bool.isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommitCommentView, {
  item: function () {
    const node = require("./__generated__/commitCommentView_item.graphql");

    if (node.hash && node.hash !== "f3e868b343fe8d6fee958d5339b554dc") {
      console.error("The definition of 'commitCommentView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commitCommentView_item.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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