"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCommitCommentThreadView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _commitCommentView = _interopRequireDefault(require("./commit-comment-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommitCommentThreadView extends _react["default"].Component {
  render() {
    const {
      item
    } = this.props;
    return _react["default"].createElement("div", {
      className: "commit-comment-thread timeline-item"
    }, item.comments.edges.map((edge, i) => _react["default"].createElement(_commitCommentView["default"], {
      isReply: i !== 0,
      key: edge.node.id,
      item: edge.node,
      switchToIssueish: this.props.switchToIssueish
    })));
  }

}

exports.BareCommitCommentThreadView = BareCommitCommentThreadView;

_defineProperty(BareCommitCommentThreadView, "propTypes", {
  item: _propTypes["default"].shape({
    commit: _propTypes["default"].shape({
      oid: _propTypes["default"].string.isRequired
    }).isRequired,
    comments: _propTypes["default"].shape({
      edges: _propTypes["default"].arrayOf(_propTypes["default"].shape({
        node: _propTypes["default"].object.isRequired
      }).isRequired).isRequired
    }).isRequired
  }).isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommitCommentThreadView, {
  item: function () {
    const node = require("./__generated__/commitCommentThreadView_item.graphql");

    if (node.hash && node.hash !== "2f881b33df634a755a5d66b192c2791b") {
      console.error("The definition of 'commitCommentThreadView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commitCommentThreadView_item.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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