"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const CONTENT_TYPES = Object.keys(_helpers.reactionTypeToEmoji);
const EMOJI_COUNT = CONTENT_TYPES.length;
const EMOJI_PER_ROW = 4;
const EMOJI_ROWS = Math.ceil(EMOJI_COUNT / EMOJI_PER_ROW);

class ReactionPickerView extends _react["default"].Component {
  render() {
    const viewerReactedSet = new Set(this.props.viewerReacted);
    const emojiRows = [];

    for (let row = 0; row < EMOJI_ROWS; row++) {
      const emojiButtons = [];

      for (let column = 0; column < EMOJI_PER_ROW; column++) {
        const emojiIndex = row * EMOJI_PER_ROW + column;
        /* istanbul ignore if */

        if (emojiIndex >= CONTENT_TYPES.length) {
          break;
        }

        const content = CONTENT_TYPES[emojiIndex];
        const toggle = !viewerReactedSet.has(content) ? () => this.props.addReactionAndClose(content) : () => this.props.removeReactionAndClose(content);
        const className = (0, _classnames["default"])('github-ReactionPicker-reaction', 'btn', {
          selected: viewerReactedSet.has(content)
        });
        emojiButtons.push(_react["default"].createElement("button", {
          key: content,
          className: className,
          onClick: toggle
        }, _helpers.reactionTypeToEmoji[content]));
      }

      emojiRows.push(_react["default"].createElement("p", {
        key: row,
        className: "github-ReactionPicker-row inline-block-tight"
      }, emojiButtons));
    }

    return _react["default"].createElement("div", {
      className: "github-ReactionPicker"
    }, emojiRows);
  }

}

exports["default"] = ReactionPickerView;

_defineProperty(ReactionPickerView, "propTypes", {
  viewerReacted: _propTypes["default"].arrayOf(_propTypes["default"].oneOf(Object.keys(_helpers.reactionTypeToEmoji))),
  // Action methods
  addReactionAndClose: _propTypes["default"].func.isRequired,
  removeReactionAndClose: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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