"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryErrorTile extends _react["default"].Component {
  componentDidMount() {
    // eslint-disable-next-line no-console
    console.error('Error encountered in subquery', this.props.error);
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-QueryErrorTile"
    }, _react["default"].createElement("div", {
      className: "github-QueryErrorTile-messages"
    }, this.renderMessages()));
  }

  renderMessages() {
    if (this.props.error.errors) {
      return this.props.error.errors.map((error, index) => {
        return this.renderMessage(error.message, index, 'alert');
      });
    }

    if (this.props.error.response) {
      return this.renderMessage(this.props.error.responseText, '0', 'alert');
    }

    if (this.props.error.network) {
      return this.renderMessage('Offline', '0', 'alignment-unalign');
    }

    return this.renderMessage(this.props.error.toString(), '0', 'alert');
  }

  renderMessage(body, key, icon) {
    return _react["default"].createElement("p", {
      key: key,
      className: "github-QueryErrorTile-message"
    }, _react["default"].createElement(_octicon["default"], {
      icon: icon
    }), body);
  }

}

exports["default"] = QueryErrorTile;

_defineProperty(QueryErrorTile, "propTypes", {
  error: _propTypes["default"].shape({
    response: _propTypes["default"].shape({
      status: _propTypes["default"].number.isRequired
    }),
    responseText: _propTypes["default"].string,
    network: _propTypes["default"].bool,
    errors: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      message: _propTypes["default"].string.isRequired
    }))
  }).isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInF1ZXJ5LWVycm9yLXRpbGUuanMiXSwibmFtZXMiOlsiUXVlcnlFcnJvclRpbGUiLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbXBvbmVudERpZE1vdW50IiwiY29uc29sZSIsImVycm9yIiwicHJvcHMiLCJyZW5kZXIiLCJyZW5kZXJNZXNzYWdlcyIsImVycm9ycyIsIm1hcCIsImluZGV4IiwicmVuZGVyTWVzc2FnZSIsIm1lc3NhZ2UiLCJyZXNwb25zZSIsInJlc3BvbnNlVGV4dCIsIm5ldHdvcmsiLCJ0b1N0cmluZyIsImJvZHkiLCJrZXkiLCJpY29uIiwiUHJvcFR5cGVzIiwic2hhcGUiLCJzdGF0dXMiLCJudW1iZXIiLCJpc1JlcXVpcmVkIiwic3RyaW5nIiwiYm9vbCIsImFycmF5T2YiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFFQTs7Ozs7O0FBRWUsTUFBTUEsY0FBTixTQUE2QkMsa0JBQU1DLFNBQW5DLENBQTZDO0FBYzFEQyxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQjtBQUNBQyxJQUFBQSxPQUFPLENBQUNDLEtBQVIsQ0FBYywrQkFBZCxFQUErQyxLQUFLQyxLQUFMLENBQVdELEtBQTFEO0FBQ0Q7O0FBRURFLEVBQUFBLE1BQU0sR0FBRztBQUNQLFdBQ0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0U7QUFBSyxNQUFBLFNBQVMsRUFBQztBQUFmLE9BQ0csS0FBS0MsY0FBTCxFQURILENBREYsQ0FERjtBQU9EOztBQUVEQSxFQUFBQSxjQUFjLEdBQUc7QUFDZixRQUFJLEtBQUtGLEtBQUwsQ0FBV0QsS0FBWCxDQUFpQkksTUFBckIsRUFBNkI7QUFDM0IsYUFBTyxLQUFLSCxLQUFMLENBQVdELEtBQVgsQ0FBaUJJLE1BQWpCLENBQXdCQyxHQUF4QixDQUE0QixDQUFDTCxLQUFELEVBQVFNLEtBQVIsS0FBa0I7QUFDbkQsZUFBTyxLQUFLQyxhQUFMLENBQW1CUCxLQUFLLENBQUNRLE9BQXpCLEVBQWtDRixLQUFsQyxFQUF5QyxPQUF6QyxDQUFQO0FBQ0QsT0FGTSxDQUFQO0FBR0Q7O0FBRUQsUUFBSSxLQUFLTCxLQUFMLENBQVdELEtBQVgsQ0FBaUJTLFFBQXJCLEVBQStCO0FBQzdCLGFBQU8sS0FBS0YsYUFBTCxDQUFtQixLQUFLTixLQUFMLENBQVdELEtBQVgsQ0FBaUJVLFlBQXBDLEVBQWtELEdBQWxELEVBQXVELE9BQXZELENBQVA7QUFDRDs7QUFFRCxRQUFJLEtBQUtULEtBQUwsQ0FBV0QsS0FBWCxDQUFpQlcsT0FBckIsRUFBOEI7QUFDNUIsYUFBTyxLQUFLSixhQUFMLENBQW1CLFNBQW5CLEVBQThCLEdBQTlCLEVBQW1DLG1CQUFuQyxDQUFQO0FBQ0Q7O0FBRUQsV0FBTyxLQUFLQSxhQUFMLENBQW1CLEtBQUtOLEtBQUwsQ0FBV0QsS0FBWCxDQUFpQlksUUFBakIsRUFBbkIsRUFBZ0QsR0FBaEQsRUFBcUQsT0FBckQsQ0FBUDtBQUNEOztBQUVETCxFQUFBQSxhQUFhLENBQUNNLElBQUQsRUFBT0MsR0FBUCxFQUFZQyxJQUFaLEVBQWtCO0FBQzdCLFdBQ0U7QUFBRyxNQUFBLEdBQUcsRUFBRUQsR0FBUjtBQUFhLE1BQUEsU0FBUyxFQUFDO0FBQXZCLE9BQ0UsZ0NBQUMsbUJBQUQ7QUFBUyxNQUFBLElBQUksRUFBRUM7QUFBZixNQURGLEVBRUdGLElBRkgsQ0FERjtBQU1EOztBQXREeUQ7Ozs7Z0JBQXZDbEIsYyxlQUNBO0FBQ2pCSyxFQUFBQSxLQUFLLEVBQUVnQixzQkFBVUMsS0FBVixDQUFnQjtBQUNyQlIsSUFBQUEsUUFBUSxFQUFFTyxzQkFBVUMsS0FBVixDQUFnQjtBQUN4QkMsTUFBQUEsTUFBTSxFQUFFRixzQkFBVUcsTUFBVixDQUFpQkM7QUFERCxLQUFoQixDQURXO0FBSXJCVixJQUFBQSxZQUFZLEVBQUVNLHNCQUFVSyxNQUpIO0FBS3JCVixJQUFBQSxPQUFPLEVBQUVLLHNCQUFVTSxJQUxFO0FBTXJCbEIsSUFBQUEsTUFBTSxFQUFFWSxzQkFBVU8sT0FBVixDQUFrQlAsc0JBQVVDLEtBQVYsQ0FBZ0I7QUFDeENULE1BQUFBLE9BQU8sRUFBRVEsc0JBQVVLLE1BQVYsQ0FBaUJEO0FBRGMsS0FBaEIsQ0FBbEI7QUFOYSxHQUFoQixFQVNKQTtBQVZjLEMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5cbmltcG9ydCBPY3RpY29uIGZyb20gJy4uL2F0b20vb2N0aWNvbic7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFF1ZXJ5RXJyb3JUaWxlIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBlcnJvcjogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgIHJlc3BvbnNlOiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgICBzdGF0dXM6IFByb3BUeXBlcy5udW1iZXIuaXNSZXF1aXJlZCxcbiAgICAgIH0pLFxuICAgICAgcmVzcG9uc2VUZXh0OiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgbmV0d29yazogUHJvcFR5cGVzLmJvb2wsXG4gICAgICBlcnJvcnM6IFByb3BUeXBlcy5hcnJheU9mKFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgIG1lc3NhZ2U6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgIH0pKSxcbiAgICB9KS5pc1JlcXVpcmVkLFxuICB9XG5cbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWNvbnNvbGVcbiAgICBjb25zb2xlLmVycm9yKCdFcnJvciBlbmNvdW50ZXJlZCBpbiBzdWJxdWVyeScsIHRoaXMucHJvcHMuZXJyb3IpO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1RdWVyeUVycm9yVGlsZVwiPlxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1RdWVyeUVycm9yVGlsZS1tZXNzYWdlc1wiPlxuICAgICAgICAgIHt0aGlzLnJlbmRlck1lc3NhZ2VzKCl9XG4gICAgICAgIDwvZGl2PlxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlck1lc3NhZ2VzKCkge1xuICAgIGlmICh0aGlzLnByb3BzLmVycm9yLmVycm9ycykge1xuICAgICAgcmV0dXJuIHRoaXMucHJvcHMuZXJyb3IuZXJyb3JzLm1hcCgoZXJyb3IsIGluZGV4KSA9PiB7XG4gICAgICAgIHJldHVybiB0aGlzLnJlbmRlck1lc3NhZ2UoZXJyb3IubWVzc2FnZSwgaW5kZXgsICdhbGVydCcpO1xuICAgICAgfSk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMucHJvcHMuZXJyb3IucmVzcG9uc2UpIHtcbiAgICAgIHJldHVybiB0aGlzLnJlbmRlck1lc3NhZ2UodGhpcy5wcm9wcy5lcnJvci5yZXNwb25zZVRleHQsICcwJywgJ2FsZXJ0Jyk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMucHJvcHMuZXJyb3IubmV0d29yaykge1xuICAgICAgcmV0dXJuIHRoaXMucmVuZGVyTWVzc2FnZSgnT2ZmbGluZScsICcwJywgJ2FsaWdubWVudC11bmFsaWduJyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMucmVuZGVyTWVzc2FnZSh0aGlzLnByb3BzLmVycm9yLnRvU3RyaW5nKCksICcwJywgJ2FsZXJ0Jyk7XG4gIH1cblxuICByZW5kZXJNZXNzYWdlKGJvZHksIGtleSwgaWNvbikge1xuICAgIHJldHVybiAoXG4gICAgICA8cCBrZXk9e2tleX0gY2xhc3NOYW1lPVwiZ2l0aHViLVF1ZXJ5RXJyb3JUaWxlLW1lc3NhZ2VcIj5cbiAgICAgICAgPE9jdGljb24gaWNvbj17aWNvbn0gLz5cbiAgICAgICAge2JvZHl9XG4gICAgICA8L3A+XG4gICAgKTtcbiAgfVxufVxuIl19