"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.PrCommitView = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _nodeEmoji = require("node-emoji");

var _moment = _interopRequireDefault(require("moment"));

var _reactRelay = require("react-relay");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const avatarAltText = 'committer avatar';

class PrCommitView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openCommitDetailItem", () => this.props.openCommit({
      sha: this.props.item.sha
    }));

    this.state = {
      showMessageBody: false
    };
    (0, _helpers.autobind)(this, 'toggleShowCommitMessageBody', 'humanizeTimeSince');
  }

  toggleShowCommitMessageBody() {
    this.setState({
      showMessageBody: !this.state.showMessageBody
    });
  }

  humanizeTimeSince(date) {
    return (0, _moment["default"])(date).fromNow();
  }

  render() {
    const {
      messageHeadline,
      messageBody,
      shortSha,
      url
    } = this.props.item;
    const {
      avatarUrl,
      name,
      date
    } = this.props.item.committer;
    return _react["default"].createElement("div", {
      className: "github-PrCommitView-container"
    }, _react["default"].createElement("div", {
      className: "github-PrCommitView-commit"
    }, _react["default"].createElement("h3", {
      className: "github-PrCommitView-title"
    }, this.props.onBranch ? _react["default"].createElement("button", {
      className: "github-PrCommitView-messageHeadline is-button",
      onClick: this.openCommitDetailItem
    }, (0, _nodeEmoji.emojify)(messageHeadline)) : _react["default"].createElement("span", {
      className: "github-PrCommitView-messageHeadline"
    }, (0, _nodeEmoji.emojify)(messageHeadline)), messageBody ? _react["default"].createElement("button", {
      className: "github-PrCommitView-moreButton",
      onClick: this.toggleShowCommitMessageBody
    }, this.state.showMessageBody ? 'hide' : 'show', " more...") : null), _react["default"].createElement("div", {
      className: "github-PrCommitView-meta"
    }, _react["default"].createElement("img", {
      className: "github-PrCommitView-avatar",
      src: avatarUrl,
      alt: avatarAltText,
      title: avatarAltText
    }), _react["default"].createElement("span", {
      className: "github-PrCommitView-metaText"
    }, name, " committed ", this.humanizeTimeSince(date))), this.state.showMessageBody ? _react["default"].createElement("pre", {
      className: "github-PrCommitView-moreText"
    }, (0, _nodeEmoji.emojify)(messageBody)) : null), _react["default"].createElement("div", {
      className: "github-PrCommitView-sha"
    }, _react["default"].createElement("a", {
      href: url,
      title: `open commit ${shortSha} on GitHub.com`
    }, shortSha)));
  }

}

exports.PrCommitView = PrCommitView;

_defineProperty(PrCommitView, "propTypes", {
  item: _propTypes["default"].shape({
    committer: _propTypes["default"].shape({
      avatarUrl: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired,
      date: _propTypes["default"].string.isRequired
    }).isRequired,
    messageBody: _propTypes["default"].string,
    messageHeadline: _propTypes["default"].string.isRequired,
    shortSha: _propTypes["default"].string.isRequired,
    sha: _propTypes["default"].string.isRequired,
    url: _propTypes["default"].string.isRequired
  }).isRequired,
  onBranch: _propTypes["default"].bool.isRequired,
  openCommit: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(PrCommitView, {
  item: function () {
    const node = require("./__generated__/prCommitView_item.graphql");

    if (node.hash && node.hash !== "2bd193bec5d758f465d9428ff3cd8a09") {
      console.error("The definition of 'prCommitView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prCommitView_item.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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