"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openCommitDetailItem = openCommitDetailItem;
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _gitShellOutStrategy = require("../git-shell-out-strategy");

var _dialogView = _interopRequireDefault(require("./dialog-view"));

var _autofocus = _interopRequireDefault(require("../autofocus"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class OpenCommitDialog extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "accept", () => {
      const ref = this.ref.getText();

      if (ref.length === 0) {
        return Promise.resolve();
      }

      return this.props.request.accept(ref);
    });

    _defineProperty(this, "didChangeRef", () => {
      const enabled = !this.ref.isEmpty();

      if (this.state.acceptEnabled !== enabled) {
        this.setState({
          acceptEnabled: enabled
        });
      }
    });

    this.ref = new _atom.TextBuffer();
    this.sub = this.ref.onDidChange(this.didChangeRef);
    this.state = {
      acceptEnabled: false
    };
    this.autofocus = new _autofocus["default"]();
  }

  render() {
    return _react["default"].createElement(_dialogView["default"], {
      acceptEnabled: this.state.acceptEnabled,
      acceptClassName: "icon icon-commit",
      acceptText: "Open commit",
      accept: this.accept,
      cancel: this.props.request.cancel,
      autofocus: this.autofocus,
      inProgress: this.props.inProgress,
      error: this.props.error,
      workspace: this.props.workspace,
      commands: this.props.commands
    }, _react["default"].createElement("label", {
      className: "github-DialogLabel github-CommitRef"
    }, "Commit sha or ref:", _react["default"].createElement(_atomTextEditor["default"], {
      ref: this.autofocus.target,
      mini: true,
      buffer: this.ref
    })));
  }

  componentDidMount() {
    this.autofocus.trigger();
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

}

exports["default"] = OpenCommitDialog;

_defineProperty(OpenCommitDialog, "propTypes", {
  // Model
  request: _propTypes["default"].shape({
    getParams: _propTypes["default"].func.isRequired,
    accept: _propTypes["default"].func.isRequired,
    cancel: _propTypes["default"].func.isRequired
  }).isRequired,
  inProgress: _propTypes["default"].bool,
  error: _propTypes["default"].instanceOf(Error),
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired
});

async function openCommitDetailItem(ref, {
  workspace,
  repository
}) {
  try {
    await repository.getCommit(ref);
  } catch (error) {
    if (error instanceof _gitShellOutStrategy.GitError && error.code === 128) {
      error.userMessage = 'There is no commit associated with that reference.';
    }

    throw error;
  }

  const item = await workspace.open(_commitDetailItem["default"].buildURI(repository.getWorkingDirectoryPath(), ref), {
    searchAllPanes: true
  });
  (0, _reporterProxy.addEvent)('open-commit-in-pane', {
    "package": 'github',
    from: OpenCommitDialog.name
  });
  return item;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm9wZW4tY29tbWl0LWRpYWxvZy5qcyJdLCJuYW1lcyI6WyJPcGVuQ29tbWl0RGlhbG9nIiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwicmVmIiwiZ2V0VGV4dCIsImxlbmd0aCIsIlByb21pc2UiLCJyZXNvbHZlIiwicmVxdWVzdCIsImFjY2VwdCIsImVuYWJsZWQiLCJpc0VtcHR5Iiwic3RhdGUiLCJhY2NlcHRFbmFibGVkIiwic2V0U3RhdGUiLCJUZXh0QnVmZmVyIiwic3ViIiwib25EaWRDaGFuZ2UiLCJkaWRDaGFuZ2VSZWYiLCJhdXRvZm9jdXMiLCJBdXRvRm9jdXMiLCJyZW5kZXIiLCJjYW5jZWwiLCJpblByb2dyZXNzIiwiZXJyb3IiLCJ3b3Jrc3BhY2UiLCJjb21tYW5kcyIsInRhcmdldCIsImNvbXBvbmVudERpZE1vdW50IiwidHJpZ2dlciIsImNvbXBvbmVudFdpbGxVbm1vdW50IiwiZGlzcG9zZSIsIlByb3BUeXBlcyIsInNoYXBlIiwiZ2V0UGFyYW1zIiwiZnVuYyIsImlzUmVxdWlyZWQiLCJib29sIiwiaW5zdGFuY2VPZiIsIkVycm9yIiwib2JqZWN0Iiwib3BlbkNvbW1pdERldGFpbEl0ZW0iLCJyZXBvc2l0b3J5IiwiZ2V0Q29tbWl0IiwiR2l0RXJyb3IiLCJjb2RlIiwidXNlck1lc3NhZ2UiLCJpdGVtIiwib3BlbiIsIkNvbW1pdERldGFpbEl0ZW0iLCJidWlsZFVSSSIsImdldFdvcmtpbmdEaXJlY3RvcnlQYXRoIiwic2VhcmNoQWxsUGFuZXMiLCJmcm9tIiwibmFtZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFDQTs7QUFFQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7Ozs7O0FBRWUsTUFBTUEsZ0JBQU4sU0FBK0JDLGtCQUFNQyxTQUFyQyxDQUErQztBQWdCNURDLEVBQUFBLFdBQVcsQ0FBQ0MsS0FBRCxFQUFRO0FBQ2pCLFVBQU1BLEtBQU47O0FBRGlCLG9DQTRDVixNQUFNO0FBQ2IsWUFBTUMsR0FBRyxHQUFHLEtBQUtBLEdBQUwsQ0FBU0MsT0FBVCxFQUFaOztBQUNBLFVBQUlELEdBQUcsQ0FBQ0UsTUFBSixLQUFlLENBQW5CLEVBQXNCO0FBQ3BCLGVBQU9DLE9BQU8sQ0FBQ0MsT0FBUixFQUFQO0FBQ0Q7O0FBRUQsYUFBTyxLQUFLTCxLQUFMLENBQVdNLE9BQVgsQ0FBbUJDLE1BQW5CLENBQTBCTixHQUExQixDQUFQO0FBQ0QsS0FuRGtCOztBQUFBLDBDQXFESixNQUFNO0FBQ25CLFlBQU1PLE9BQU8sR0FBRyxDQUFDLEtBQUtQLEdBQUwsQ0FBU1EsT0FBVCxFQUFqQjs7QUFDQSxVQUFJLEtBQUtDLEtBQUwsQ0FBV0MsYUFBWCxLQUE2QkgsT0FBakMsRUFBMEM7QUFDeEMsYUFBS0ksUUFBTCxDQUFjO0FBQUNELFVBQUFBLGFBQWEsRUFBRUg7QUFBaEIsU0FBZDtBQUNEO0FBQ0YsS0ExRGtCOztBQUdqQixTQUFLUCxHQUFMLEdBQVcsSUFBSVksZ0JBQUosRUFBWDtBQUNBLFNBQUtDLEdBQUwsR0FBVyxLQUFLYixHQUFMLENBQVNjLFdBQVQsQ0FBcUIsS0FBS0MsWUFBMUIsQ0FBWDtBQUVBLFNBQUtOLEtBQUwsR0FBYTtBQUNYQyxNQUFBQSxhQUFhLEVBQUU7QUFESixLQUFiO0FBSUEsU0FBS00sU0FBTCxHQUFpQixJQUFJQyxxQkFBSixFQUFqQjtBQUNEOztBQUVEQyxFQUFBQSxNQUFNLEdBQUc7QUFDUCxXQUNFLGdDQUFDLHNCQUFEO0FBQ0UsTUFBQSxhQUFhLEVBQUUsS0FBS1QsS0FBTCxDQUFXQyxhQUQ1QjtBQUVFLE1BQUEsZUFBZSxFQUFDLGtCQUZsQjtBQUdFLE1BQUEsVUFBVSxFQUFDLGFBSGI7QUFJRSxNQUFBLE1BQU0sRUFBRSxLQUFLSixNQUpmO0FBS0UsTUFBQSxNQUFNLEVBQUUsS0FBS1AsS0FBTCxDQUFXTSxPQUFYLENBQW1CYyxNQUw3QjtBQU1FLE1BQUEsU0FBUyxFQUFFLEtBQUtILFNBTmxCO0FBT0UsTUFBQSxVQUFVLEVBQUUsS0FBS2pCLEtBQUwsQ0FBV3FCLFVBUHpCO0FBUUUsTUFBQSxLQUFLLEVBQUUsS0FBS3JCLEtBQUwsQ0FBV3NCLEtBUnBCO0FBU0UsTUFBQSxTQUFTLEVBQUUsS0FBS3RCLEtBQUwsQ0FBV3VCLFNBVHhCO0FBVUUsTUFBQSxRQUFRLEVBQUUsS0FBS3ZCLEtBQUwsQ0FBV3dCO0FBVnZCLE9BWUU7QUFBTyxNQUFBLFNBQVMsRUFBQztBQUFqQiw2QkFFRSxnQ0FBQywwQkFBRDtBQUFnQixNQUFBLEdBQUcsRUFBRSxLQUFLUCxTQUFMLENBQWVRLE1BQXBDO0FBQTRDLE1BQUEsSUFBSSxFQUFFLElBQWxEO0FBQXdELE1BQUEsTUFBTSxFQUFFLEtBQUt4QjtBQUFyRSxNQUZGLENBWkYsQ0FERjtBQW9CRDs7QUFFRHlCLEVBQUFBLGlCQUFpQixHQUFHO0FBQ2xCLFNBQUtULFNBQUwsQ0FBZVUsT0FBZjtBQUNEOztBQUVEQyxFQUFBQSxvQkFBb0IsR0FBRztBQUNyQixTQUFLZCxHQUFMLENBQVNlLE9BQVQ7QUFDRDs7QUExRDJEOzs7O2dCQUF6Q2pDLGdCLGVBQ0E7QUFDakI7QUFDQVUsRUFBQUEsT0FBTyxFQUFFd0Isc0JBQVVDLEtBQVYsQ0FBZ0I7QUFDdkJDLElBQUFBLFNBQVMsRUFBRUYsc0JBQVVHLElBQVYsQ0FBZUMsVUFESDtBQUV2QjNCLElBQUFBLE1BQU0sRUFBRXVCLHNCQUFVRyxJQUFWLENBQWVDLFVBRkE7QUFHdkJkLElBQUFBLE1BQU0sRUFBRVUsc0JBQVVHLElBQVYsQ0FBZUM7QUFIQSxHQUFoQixFQUlOQSxVQU5jO0FBT2pCYixFQUFBQSxVQUFVLEVBQUVTLHNCQUFVSyxJQVBMO0FBUWpCYixFQUFBQSxLQUFLLEVBQUVRLHNCQUFVTSxVQUFWLENBQXFCQyxLQUFyQixDQVJVO0FBVWpCO0FBQ0FkLEVBQUFBLFNBQVMsRUFBRU8sc0JBQVVRLE1BQVYsQ0FBaUJKLFVBWFg7QUFZakJWLEVBQUFBLFFBQVEsRUFBRU0sc0JBQVVRLE1BQVYsQ0FBaUJKO0FBWlYsQzs7QUE0RWQsZUFBZUssb0JBQWYsQ0FBb0N0QyxHQUFwQyxFQUF5QztBQUFDc0IsRUFBQUEsU0FBRDtBQUFZaUIsRUFBQUE7QUFBWixDQUF6QyxFQUFrRTtBQUN2RSxNQUFJO0FBQ0YsVUFBTUEsVUFBVSxDQUFDQyxTQUFYLENBQXFCeEMsR0FBckIsQ0FBTjtBQUNELEdBRkQsQ0FFRSxPQUFPcUIsS0FBUCxFQUFjO0FBQ2QsUUFBSUEsS0FBSyxZQUFZb0IsNkJBQWpCLElBQTZCcEIsS0FBSyxDQUFDcUIsSUFBTixLQUFlLEdBQWhELEVBQXFEO0FBQ25EckIsTUFBQUEsS0FBSyxDQUFDc0IsV0FBTixHQUFvQixvREFBcEI7QUFDRDs7QUFFRCxVQUFNdEIsS0FBTjtBQUNEOztBQUVELFFBQU11QixJQUFJLEdBQUcsTUFBTXRCLFNBQVMsQ0FBQ3VCLElBQVYsQ0FDakJDLDZCQUFpQkMsUUFBakIsQ0FBMEJSLFVBQVUsQ0FBQ1MsdUJBQVgsRUFBMUIsRUFBZ0VoRCxHQUFoRSxDQURpQixFQUVqQjtBQUFDaUQsSUFBQUEsY0FBYyxFQUFFO0FBQWpCLEdBRmlCLENBQW5CO0FBSUEsK0JBQVMscUJBQVQsRUFBZ0M7QUFBQyxlQUFTLFFBQVY7QUFBb0JDLElBQUFBLElBQUksRUFBRXZELGdCQUFnQixDQUFDd0Q7QUFBM0MsR0FBaEM7QUFDQSxTQUFPUCxJQUFQO0FBQ0QiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQge1RleHRCdWZmZXJ9IGZyb20gJ2F0b20nO1xuXG5pbXBvcnQgQXRvbVRleHRFZGl0b3IgZnJvbSAnLi4vYXRvbS9hdG9tLXRleHQtZWRpdG9yJztcbmltcG9ydCBDb21taXREZXRhaWxJdGVtIGZyb20gJy4uL2l0ZW1zL2NvbW1pdC1kZXRhaWwtaXRlbSc7XG5pbXBvcnQge0dpdEVycm9yfSBmcm9tICcuLi9naXQtc2hlbGwtb3V0LXN0cmF0ZWd5JztcbmltcG9ydCBEaWFsb2dWaWV3IGZyb20gJy4vZGlhbG9nLXZpZXcnO1xuaW1wb3J0IEF1dG9Gb2N1cyBmcm9tICcuLi9hdXRvZm9jdXMnO1xuaW1wb3J0IHthZGRFdmVudH0gZnJvbSAnLi4vcmVwb3J0ZXItcHJveHknO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBPcGVuQ29tbWl0RGlhbG9nIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICAvLyBNb2RlbFxuICAgIHJlcXVlc3Q6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICBnZXRQYXJhbXM6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgICBhY2NlcHQ6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgICBjYW5jZWw6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgfSkuaXNSZXF1aXJlZCxcbiAgICBpblByb2dyZXNzOiBQcm9wVHlwZXMuYm9vbCxcbiAgICBlcnJvcjogUHJvcFR5cGVzLmluc3RhbmNlT2YoRXJyb3IpLFxuXG4gICAgLy8gQXRvbSBlbnZpcm9ubWVudFxuICAgIHdvcmtzcGFjZTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGNvbW1hbmRzOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gIH1cblxuICBjb25zdHJ1Y3Rvcihwcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcblxuICAgIHRoaXMucmVmID0gbmV3IFRleHRCdWZmZXIoKTtcbiAgICB0aGlzLnN1YiA9IHRoaXMucmVmLm9uRGlkQ2hhbmdlKHRoaXMuZGlkQ2hhbmdlUmVmKTtcblxuICAgIHRoaXMuc3RhdGUgPSB7XG4gICAgICBhY2NlcHRFbmFibGVkOiBmYWxzZSxcbiAgICB9O1xuXG4gICAgdGhpcy5hdXRvZm9jdXMgPSBuZXcgQXV0b0ZvY3VzKCk7XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxEaWFsb2dWaWV3XG4gICAgICAgIGFjY2VwdEVuYWJsZWQ9e3RoaXMuc3RhdGUuYWNjZXB0RW5hYmxlZH1cbiAgICAgICAgYWNjZXB0Q2xhc3NOYW1lPVwiaWNvbiBpY29uLWNvbW1pdFwiXG4gICAgICAgIGFjY2VwdFRleHQ9XCJPcGVuIGNvbW1pdFwiXG4gICAgICAgIGFjY2VwdD17dGhpcy5hY2NlcHR9XG4gICAgICAgIGNhbmNlbD17dGhpcy5wcm9wcy5yZXF1ZXN0LmNhbmNlbH1cbiAgICAgICAgYXV0b2ZvY3VzPXt0aGlzLmF1dG9mb2N1c31cbiAgICAgICAgaW5Qcm9ncmVzcz17dGhpcy5wcm9wcy5pblByb2dyZXNzfVxuICAgICAgICBlcnJvcj17dGhpcy5wcm9wcy5lcnJvcn1cbiAgICAgICAgd29ya3NwYWNlPXt0aGlzLnByb3BzLndvcmtzcGFjZX1cbiAgICAgICAgY29tbWFuZHM9e3RoaXMucHJvcHMuY29tbWFuZHN9PlxuXG4gICAgICAgIDxsYWJlbCBjbGFzc05hbWU9XCJnaXRodWItRGlhbG9nTGFiZWwgZ2l0aHViLUNvbW1pdFJlZlwiPlxuICAgICAgICAgIENvbW1pdCBzaGEgb3IgcmVmOlxuICAgICAgICAgIDxBdG9tVGV4dEVkaXRvciByZWY9e3RoaXMuYXV0b2ZvY3VzLnRhcmdldH0gbWluaT17dHJ1ZX0gYnVmZmVyPXt0aGlzLnJlZn0gLz5cbiAgICAgICAgPC9sYWJlbD5cblxuICAgICAgPC9EaWFsb2dWaWV3PlxuICAgICk7XG4gIH1cblxuICBjb21wb25lbnREaWRNb3VudCgpIHtcbiAgICB0aGlzLmF1dG9mb2N1cy50cmlnZ2VyKCk7XG4gIH1cblxuICBjb21wb25lbnRXaWxsVW5tb3VudCgpIHtcbiAgICB0aGlzLnN1Yi5kaXNwb3NlKCk7XG4gIH1cblxuICBhY2NlcHQgPSAoKSA9PiB7XG4gICAgY29uc3QgcmVmID0gdGhpcy5yZWYuZ2V0VGV4dCgpO1xuICAgIGlmIChyZWYubGVuZ3RoID09PSAwKSB7XG4gICAgICByZXR1cm4gUHJvbWlzZS5yZXNvbHZlKCk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMucHJvcHMucmVxdWVzdC5hY2NlcHQocmVmKTtcbiAgfVxuXG4gIGRpZENoYW5nZVJlZiA9ICgpID0+IHtcbiAgICBjb25zdCBlbmFibGVkID0gIXRoaXMucmVmLmlzRW1wdHkoKTtcbiAgICBpZiAodGhpcy5zdGF0ZS5hY2NlcHRFbmFibGVkICE9PSBlbmFibGVkKSB7XG4gICAgICB0aGlzLnNldFN0YXRlKHthY2NlcHRFbmFibGVkOiBlbmFibGVkfSk7XG4gICAgfVxuICB9XG59XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBvcGVuQ29tbWl0RGV0YWlsSXRlbShyZWYsIHt3b3Jrc3BhY2UsIHJlcG9zaXRvcnl9KSB7XG4gIHRyeSB7XG4gICAgYXdhaXQgcmVwb3NpdG9yeS5nZXRDb21taXQocmVmKTtcbiAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICBpZiAoZXJyb3IgaW5zdGFuY2VvZiBHaXRFcnJvciAmJiBlcnJvci5jb2RlID09PSAxMjgpIHtcbiAgICAgIGVycm9yLnVzZXJNZXNzYWdlID0gJ1RoZXJlIGlzIG5vIGNvbW1pdCBhc3NvY2lhdGVkIHdpdGggdGhhdCByZWZlcmVuY2UuJztcbiAgICB9XG5cbiAgICB0aHJvdyBlcnJvcjtcbiAgfVxuXG4gIGNvbnN0IGl0ZW0gPSBhd2FpdCB3b3Jrc3BhY2Uub3BlbihcbiAgICBDb21taXREZXRhaWxJdGVtLmJ1aWxkVVJJKHJlcG9zaXRvcnkuZ2V0V29ya2luZ0RpcmVjdG9yeVBhdGgoKSwgcmVmKSxcbiAgICB7c2VhcmNoQWxsUGFuZXM6IHRydWV9LFxuICApO1xuICBhZGRFdmVudCgnb3Blbi1jb21taXQtaW4tcGFuZScsIHtwYWNrYWdlOiAnZ2l0aHViJywgZnJvbTogT3BlbkNvbW1pdERpYWxvZy5uYW1lfSk7XG4gIHJldHVybiBpdGVtO1xufVxuIl19