"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _atom = require("atom");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _reporterProxy = require("../reporter-proxy");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _marker = _interopRequireDefault(require("../atom/marker"));

var _markerLayer = _interopRequireDefault(require("../atom/marker-layer"));

var _decoration = _interopRequireDefault(require("../atom/decoration"));

var _gutter = _interopRequireDefault(require("../atom/gutter"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _filePatchHeaderView = _interopRequireDefault(require("./file-patch-header-view"));

var _filePatchMetaView = _interopRequireDefault(require("./file-patch-meta-view"));

var _hunkHeaderView = _interopRequireDefault(require("./hunk-header-view"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _changedFileItem = _interopRequireDefault(require("../items/changed-file-item"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _commentGutterDecorationController = _interopRequireDefault(require("../controllers/comment-gutter-decoration-controller"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _file = _interopRequireDefault(require("../models/patch/file"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const executableText = {
  [_file["default"].modes.NORMAL]: 'non executable',
  [_file["default"].modes.EXECUTABLE]: 'executable'
};

class MultiFilePatchView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "renderFilePatchDecorations", (filePatch, index) => {
      const isCollapsed = !filePatch.getRenderStatus().isVisible();
      const isEmpty = filePatch.getMarker().getRange().isEmpty();
      const isExpandable = filePatch.getRenderStatus().isExpandable();
      const isUnavailable = isCollapsed && !isExpandable;
      const atEnd = filePatch.getStartRange().start.isEqual(this.props.multiFilePatch.getBuffer().getEndPosition());
      const position = isEmpty && atEnd ? 'after' : 'before';
      return _react["default"].createElement(_react.Fragment, {
        key: filePatch.getPath()
      }, _react["default"].createElement(_marker["default"], {
        invalidate: "never",
        bufferRange: filePatch.getStartRange()
      }, _react["default"].createElement(_decoration["default"], {
        type: "block",
        position: position,
        order: index,
        className: "github-FilePatchView-controlBlock"
      }, _react["default"].createElement(_filePatchHeaderView["default"], {
        itemType: this.props.itemType,
        relPath: filePatch.getPath(),
        newPath: filePatch.getStatus() === 'renamed' ? filePatch.getNewPath() : null,
        stagingStatus: this.props.stagingStatus,
        isPartiallyStaged: this.props.isPartiallyStaged,
        hasUndoHistory: this.props.hasUndoHistory,
        hasMultipleFileSelections: this.props.hasMultipleFileSelections,
        tooltips: this.props.tooltips,
        undoLastDiscard: () => this.undoLastDiscardFromButton(filePatch),
        diveIntoMirrorPatch: () => this.props.diveIntoMirrorPatch(filePatch),
        openFile: () => this.didOpenFile({
          selectedFilePatch: filePatch
        }),
        toggleFile: () => this.props.toggleFile(filePatch),
        isCollapsed: isCollapsed,
        triggerCollapse: () => this.props.multiFilePatch.collapseFilePatch(filePatch),
        triggerExpand: () => this.props.multiFilePatch.expandFilePatch(filePatch)
      }), !isCollapsed && this.renderSymlinkChangeMeta(filePatch), !isCollapsed && this.renderExecutableModeChangeMeta(filePatch))), isExpandable && this.renderDiffGate(filePatch, position, index), isUnavailable && this.renderDiffUnavailable(filePatch, position, index), this.renderHunkHeaders(filePatch, index));
    });

    _defineProperty(this, "undoLastDiscardFromCoreUndo", () => {
      if (this.props.hasUndoHistory) {
        const selectedFilePatches = Array.from(this.getSelectedFilePatches());
        /* istanbul ignore else */

        if (this.props.itemType === _changedFileItem["default"]) {
          this.props.undoLastDiscard(selectedFilePatches[0], {
            eventSource: {
              command: 'core:undo'
            }
          });
        }
      }
    });

    _defineProperty(this, "undoLastDiscardFromButton", filePatch => {
      this.props.undoLastDiscard(filePatch, {
        eventSource: 'button'
      });
    });

    _defineProperty(this, "discardSelectionFromCommand", () => {
      return this.props.discardRows(this.props.selectedRows, this.props.selectionMode, {
        eventSource: {
          command: 'github:discard-selected-lines'
        }
      });
    });

    _defineProperty(this, "didToggleModeChange", () => {
      return Promise.all(Array.from(this.getSelectedFilePatches()).filter(fp => fp.didChangeExecutableMode()).map(this.props.toggleModeChange));
    });

    _defineProperty(this, "didToggleSymlinkChange", () => {
      return Promise.all(Array.from(this.getSelectedFilePatches()).filter(fp => fp.hasTypechange()).map(this.props.toggleSymlinkChange));
    });

    _defineProperty(this, "scrollToFile", ({
      changedFilePath,
      changedFilePosition
    }) => {
      /* istanbul ignore next */
      this.refEditor.map(e => {
        const row = this.props.multiFilePatch.getBufferRowForDiffPosition(changedFilePath, changedFilePosition);

        if (row === null) {
          return null;
        }

        e.scrollToBufferPosition({
          row,
          column: 0
        }, {
          center: true
        });
        e.setCursorBufferPosition({
          row,
          column: 0
        });
        return null;
      });
    });

    (0, _helpers.autobind)(this, 'didMouseDownOnHeader', 'didMouseDownOnLineNumber', 'didMouseMoveOnLineNumber', 'didMouseUp', 'didConfirm', 'didToggleSelectionMode', 'selectNextHunk', 'selectPreviousHunk', 'didOpenFile', 'didAddSelection', 'didChangeSelectionRange', 'didDestroySelection', 'oldLineNumberLabel', 'newLineNumberLabel');
    this.mouseSelectionInProgress = false;
    this.lastMouseMoveLine = null;
    this.nextSelectionMode = null;
    this.refRoot = new _refHolder["default"]();
    this.refEditor = new _refHolder["default"]();
    this.refEditorElement = new _refHolder["default"]();
    this.mounted = false;
    this.subs = new _eventKit.CompositeDisposable();
    this.subs.add(this.refEditor.observe(editor => {
      this.refEditorElement.setter(editor.getElement());

      if (this.props.refEditor) {
        this.props.refEditor.setter(editor);
      }
    }), this.refEditorElement.observe(element => {
      this.props.refInitialFocus && this.props.refInitialFocus.setter(element);
    })); // Synchronously maintain the editor's scroll position and logical selection across buffer updates.

    this.suppressChanges = false;
    let lastScrollTop = null;
    let lastScrollLeft = null;
    let lastSelectionIndex = null;
    this.subs.add(this.props.onWillUpdatePatch(() => {
      this.suppressChanges = true;
      this.refEditor.map(editor => {
        lastSelectionIndex = this.props.multiFilePatch.getMaxSelectionIndex(this.props.selectedRows);
        lastScrollTop = editor.getElement().getScrollTop();
        lastScrollLeft = editor.getElement().getScrollLeft();
        return null;
      });
    }), this.props.onDidUpdatePatch(nextPatch => {
      this.refEditor.map(editor => {
        /* istanbul ignore else */
        if (lastSelectionIndex !== null) {
          const nextSelectionRange = nextPatch.getSelectionRangeForIndex(lastSelectionIndex);

          if (this.props.selectionMode === 'line') {
            this.nextSelectionMode = 'line';
            editor.setSelectedBufferRange(nextSelectionRange);
          } else {
            const nextHunks = new Set(_atom.Range.fromObject(nextSelectionRange).getRows().map(row => nextPatch.getHunkAt(row)).filter(Boolean));
            /* istanbul ignore next */

            const nextRanges = nextHunks.size > 0 ? Array.from(nextHunks, hunk => hunk.getRange()) : [[[0, 0], [0, 0]]];
            this.nextSelectionMode = 'hunk';
            editor.setSelectedBufferRanges(nextRanges);
          }
        }
        /* istanbul ignore else */


        if (lastScrollTop !== null) {
          editor.getElement().setScrollTop(lastScrollTop);
        }
        /* istanbul ignore else */


        if (lastScrollLeft !== null) {
          editor.getElement().setScrollLeft(lastScrollLeft);
        }

        return null;
      });
      this.suppressChanges = false;
      this.didChangeSelectedRows();
    }));
  }

  componentDidMount() {
    this.mounted = true;
    this.measurePerformance('mount');
    window.addEventListener('mouseup', this.didMouseUp);
    this.refEditor.map(editor => {
      // this.props.multiFilePatch is guaranteed to contain at least one FilePatch if <AtomTextEditor> is rendered.
      const [firstPatch] = this.props.multiFilePatch.getFilePatches();
      const [firstHunk] = firstPatch.getHunks();

      if (!firstHunk) {
        return null;
      }

      this.nextSelectionMode = 'hunk';
      editor.setSelectedBufferRange(firstHunk.getRange());
      return null;
    });
    this.subs.add(this.props.config.onDidChange('github.showDiffIconGutter', () => this.forceUpdate()));
    const {
      initChangedFilePath,
      initChangedFilePosition
    } = this.props;
    /* istanbul ignore next */

    if (initChangedFilePath && initChangedFilePosition >= 0) {
      this.scrollToFile({
        changedFilePath: initChangedFilePath,
        changedFilePosition: initChangedFilePosition
      });
    }
    /* istanbul ignore if */


    if (this.props.onOpenFilesTab) {
      this.subs.add(this.props.onOpenFilesTab(this.scrollToFile));
    }
  }

  componentDidUpdate(prevProps) {
    this.measurePerformance('update');

    if (prevProps.refInitialFocus !== this.props.refInitialFocus) {
      prevProps.refInitialFocus && prevProps.refInitialFocus.setter(null);
      this.props.refInitialFocus && this.refEditorElement.map(this.props.refInitialFocus.setter);
    }

    if (this.props.multiFilePatch === prevProps.multiFilePatch) {
      this.nextSelectionMode = null;
    }
  }

  componentWillUnmount() {
    window.removeEventListener('mouseup', this.didMouseUp);
    this.subs.dispose();
    this.mounted = false;
    performance.clearMarks();
    performance.clearMeasures();
  }

  render() {
    const rootClass = (0, _classnames["default"])('github-FilePatchView', {
      [`github-FilePatchView--${this.props.stagingStatus}`]: this.props.stagingStatus
    }, {
      'github-FilePatchView--blank': !this.props.multiFilePatch.anyPresent()
    }, {
      'github-FilePatchView--hunkMode': this.props.selectionMode === 'hunk'
    });

    if (this.mounted) {
      performance.mark('MultiFilePatchView-update-start');
    } else {
      performance.mark('MultiFilePatchView-mount-start');
    }

    return _react["default"].createElement("div", {
      className: rootClass,
      ref: this.refRoot.setter
    }, this.renderCommands(), _react["default"].createElement("main", {
      className: "github-FilePatchView-container"
    }, this.props.multiFilePatch.anyPresent() ? this.renderNonEmptyPatch() : this.renderEmptyPatch()));
  }

  renderCommands() {
    if (this.props.itemType === _commitDetailItem["default"] || this.props.itemType === _issueishDetailItem["default"]) {
      return _react["default"].createElement(_commands["default"], {
        registry: this.props.commands,
        target: this.refRoot
      }, _react["default"].createElement(_commands.Command, {
        command: "github:select-next-hunk",
        callback: this.selectNextHunk
      }), _react["default"].createElement(_commands.Command, {
        command: "github:select-previous-hunk",
        callback: this.selectPreviousHunk
      }), _react["default"].createElement(_commands.Command, {
        command: "github:toggle-patch-selection-mode",
        callback: this.didToggleSelectionMode
      }));
    }

    let stageModeCommand = null;
    let stageSymlinkCommand = null;

    if (this.props.multiFilePatch.didAnyChangeExecutableMode()) {
      const command = this.props.stagingStatus === 'unstaged' ? 'github:stage-file-mode-change' : 'github:unstage-file-mode-change';
      stageModeCommand = _react["default"].createElement(_commands.Command, {
        command: command,
        callback: this.didToggleModeChange
      });
    }

    if (this.props.multiFilePatch.anyHaveTypechange()) {
      const command = this.props.stagingStatus === 'unstaged' ? 'github:stage-symlink-change' : 'github:unstage-symlink-change';
      stageSymlinkCommand = _react["default"].createElement(_commands.Command, {
        command: command,
        callback: this.didToggleSymlinkChange
      });
    }

    return _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: this.refRoot
    }, _react["default"].createElement(_commands.Command, {
      command: "github:select-next-hunk",
      callback: this.selectNextHunk
    }), _react["default"].createElement(_commands.Command, {
      command: "github:select-previous-hunk",
      callback: this.selectPreviousHunk
    }), _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.didConfirm
    }), _react["default"].createElement(_commands.Command, {
      command: "core:undo",
      callback: this.undoLastDiscardFromCoreUndo
    }), _react["default"].createElement(_commands.Command, {
      command: "github:discard-selected-lines",
      callback: this.discardSelectionFromCommand
    }), _react["default"].createElement(_commands.Command, {
      command: "github:jump-to-file",
      callback: this.didOpenFile
    }), _react["default"].createElement(_commands.Command, {
      command: "github:surface",
      callback: this.props.surface
    }), _react["default"].createElement(_commands.Command, {
      command: "github:toggle-patch-selection-mode",
      callback: this.didToggleSelectionMode
    }), stageModeCommand, stageSymlinkCommand,
    /* istanbul ignore next */
    atom.inDevMode() && _react["default"].createElement(_commands.Command, {
      command: "github:inspect-patch",
      callback: () => {
        // eslint-disable-next-line no-console
        console.log(this.props.multiFilePatch.getPatchBuffer().inspect({
          layerNames: ['patch', 'hunk']
        }));
      }
    }),
    /* istanbul ignore next */
    atom.inDevMode() && _react["default"].createElement(_commands.Command, {
      command: "github:inspect-regions",
      callback: () => {
        // eslint-disable-next-line no-console
        console.log(this.props.multiFilePatch.getPatchBuffer().inspect({
          layerNames: ['unchanged', 'deletion', 'addition', 'nonewline']
        }));
      }
    }),
    /* istanbul ignore next */
    atom.inDevMode() && _react["default"].createElement(_commands.Command, {
      command: "github:inspect-mfp",
      callback: () => {
        // eslint-disable-next-line no-console
        console.log(this.props.multiFilePatch.inspect());
      }
    }));
  }

  renderEmptyPatch() {
    return _react["default"].createElement("p", {
      className: "github-FilePatchView-message icon icon-info"
    }, "No changes to display");
  }

  renderNonEmptyPatch() {
    return _react["default"].createElement(_atomTextEditor["default"], {
      workspace: this.props.workspace,
      buffer: this.props.multiFilePatch.getBuffer(),
      lineNumberGutterVisible: false,
      autoWidth: false,
      autoHeight: false,
      readOnly: true,
      softWrapped: true,
      didAddSelection: this.didAddSelection,
      didChangeSelectionRange: this.didChangeSelectionRange,
      didDestroySelection: this.didDestroySelection,
      refModel: this.refEditor,
      hideEmptiness: true
    }, _react["default"].createElement(_gutter["default"], {
      name: "old-line-numbers",
      priority: 1,
      className: "old",
      type: "line-number",
      labelFn: this.oldLineNumberLabel,
      onMouseDown: this.didMouseDownOnLineNumber,
      onMouseMove: this.didMouseMoveOnLineNumber
    }), _react["default"].createElement(_gutter["default"], {
      name: "new-line-numbers",
      priority: 2,
      className: "new",
      type: "line-number",
      labelFn: this.newLineNumberLabel,
      onMouseDown: this.didMouseDownOnLineNumber,
      onMouseMove: this.didMouseMoveOnLineNumber
    }), _react["default"].createElement(_gutter["default"], {
      name: "github-comment-icon",
      priority: 3,
      className: "comment",
      type: "decorated"
    }), this.props.config.get('github.showDiffIconGutter') && _react["default"].createElement(_gutter["default"], {
      name: "diff-icons",
      priority: 4,
      type: "line-number",
      className: "icons",
      labelFn: _helpers.blankLabel,
      onMouseDown: this.didMouseDownOnLineNumber,
      onMouseMove: this.didMouseMoveOnLineNumber
    }), this.renderPRCommentIcons(), this.props.multiFilePatch.getFilePatches().map(this.renderFilePatchDecorations), this.renderLineDecorations(Array.from(this.props.selectedRows, row => _atom.Range.fromObject([[row, 0], [row, Infinity]])), 'github-FilePatchView-line--selected', {
      gutter: true,
      icon: true,
      line: true
    }), this.renderDecorationsOnLayer(this.props.multiFilePatch.getAdditionLayer(), 'github-FilePatchView-line--added', {
      icon: true,
      line: true
    }), this.renderDecorationsOnLayer(this.props.multiFilePatch.getDeletionLayer(), 'github-FilePatchView-line--deleted', {
      icon: true,
      line: true
    }), this.renderDecorationsOnLayer(this.props.multiFilePatch.getNoNewlineLayer(), 'github-FilePatchView-line--nonewline', {
      icon: true,
      line: true
    }));
  }

  renderPRCommentIcons() {
    if (this.props.itemType !== _issueishDetailItem["default"] || this.props.reviewCommentsLoading) {
      return null;
    }

    return this.props.reviewCommentThreads.map(({
      comments,
      thread
    }) => {
      const {
        path,
        position
      } = comments[0];

      if (!this.props.multiFilePatch.getPatchForPath(path)) {
        return null;
      }

      const row = this.props.multiFilePatch.getBufferRowForDiffPosition(path, position);

      if (row === null) {
        return null;
      }

      const isRowSelected = this.props.selectedRows.has(row);
      return _react["default"].createElement(_commentGutterDecorationController["default"], {
        key: `github-comment-gutter-decoration-${thread.id}`,
        commentRow: row,
        threadId: thread.id,
        workspace: this.props.workspace,
        endpoint: this.props.endpoint,
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdirPath,
        extraClasses: isRowSelected ? ['github-FilePatchView-line--selected'] : [],
        parent: this.constructor.name
      });
    });
  }

  renderDiffGate(filePatch, position, orderOffset) {
    const showDiff = () => {
      (0, _reporterProxy.addEvent)('expand-file-patch', {
        component: this.constructor.name,
        "package": 'github'
      });
      this.props.multiFilePatch.expandFilePatch(filePatch);
    };

    return _react["default"].createElement(_marker["default"], {
      invalidate: "never",
      bufferRange: filePatch.getStartRange()
    }, _react["default"].createElement(_decoration["default"], {
      type: "block",
      order: orderOffset + 0.1,
      position: position,
      className: "github-FilePatchView-controlBlock"
    }, _react["default"].createElement("p", {
      className: "github-FilePatchView-message icon icon-info"
    }, "Large diffs are collapsed by default for performance reasons.", _react["default"].createElement("br", null), _react["default"].createElement("button", {
      className: "github-FilePatchView-showDiffButton",
      onClick: showDiff
    }, " Load Diff"))));
  }

  renderDiffUnavailable(filePatch, position, orderOffset) {
    return _react["default"].createElement(_marker["default"], {
      invalidate: "never",
      bufferRange: filePatch.getStartRange()
    }, _react["default"].createElement(_decoration["default"], {
      type: "block",
      order: orderOffset + 0.1,
      position: position,
      className: "github-FilePatchView-controlBlock"
    }, _react["default"].createElement("p", {
      className: "github-FilePatchView-message icon icon-warning"
    }, "This diff is too large to load at all. Use the command-line to view it.")));
  }

  renderExecutableModeChangeMeta(filePatch) {
    if (!filePatch.didChangeExecutableMode()) {
      return null;
    }

    const oldMode = filePatch.getOldMode();
    const newMode = filePatch.getNewMode();
    const attrs = this.props.stagingStatus === 'unstaged' ? {
      actionIcon: 'icon-move-down',
      actionText: 'Stage Mode Change'
    } : {
      actionIcon: 'icon-move-up',
      actionText: 'Unstage Mode Change'
    };
    return _react["default"].createElement(_filePatchMetaView["default"], {
      title: "Mode change",
      actionIcon: attrs.actionIcon,
      actionText: attrs.actionText,
      itemType: this.props.itemType,
      action: () => this.props.toggleModeChange(filePatch)
    }, _react["default"].createElement(_react.Fragment, null, "File changed mode", _react["default"].createElement("span", {
      className: "github-FilePatchView-metaDiff github-FilePatchView-metaDiff--removed"
    }, "from ", executableText[oldMode], " ", _react["default"].createElement("code", null, oldMode)), _react["default"].createElement("span", {
      className: "github-FilePatchView-metaDiff github-FilePatchView-metaDiff--added"
    }, "to ", executableText[newMode], " ", _react["default"].createElement("code", null, newMode))));
  }

  renderSymlinkChangeMeta(filePatch) {
    if (!filePatch.hasSymlink()) {
      return null;
    }

    let detail = _react["default"].createElement("div", null);

    let title = '';
    const oldSymlink = filePatch.getOldSymlink();
    const newSymlink = filePatch.getNewSymlink();

    if (oldSymlink && newSymlink) {
      detail = _react["default"].createElement(_react.Fragment, null, "Symlink changed", _react["default"].createElement("span", {
        className: (0, _classnames["default"])('github-FilePatchView-metaDiff', 'github-FilePatchView-metaDiff--fullWidth', 'github-FilePatchView-metaDiff--removed')
      }, "from ", _react["default"].createElement("code", null, oldSymlink)), _react["default"].createElement("span", {
        className: (0, _classnames["default"])('github-FilePatchView-metaDiff', 'github-FilePatchView-metaDiff--fullWidth', 'github-FilePatchView-metaDiff--added')
      }, "to ", _react["default"].createElement("code", null, newSymlink)), ".");
      title = 'Symlink changed';
    } else if (oldSymlink && !newSymlink) {
      detail = _react["default"].createElement(_react.Fragment, null, "Symlink", _react["default"].createElement("span", {
        className: "github-FilePatchView-metaDiff github-FilePatchView-metaDiff--removed"
      }, "to ", _react["default"].createElement("code", null, oldSymlink)), "deleted.");
      title = 'Symlink deleted';
    } else {
      detail = _react["default"].createElement(_react.Fragment, null, "Symlink", _react["default"].createElement("span", {
        className: "github-FilePatchView-metaDiff github-FilePatchView-metaDiff--added"
      }, "to ", _react["default"].createElement("code", null, newSymlink)), "created.");
      title = 'Symlink created';
    }

    const attrs = this.props.stagingStatus === 'unstaged' ? {
      actionIcon: 'icon-move-down',
      actionText: 'Stage Symlink Change'
    } : {
      actionIcon: 'icon-move-up',
      actionText: 'Unstage Symlink Change'
    };
    return _react["default"].createElement(_filePatchMetaView["default"], {
      title: title,
      actionIcon: attrs.actionIcon,
      actionText: attrs.actionText,
      itemType: this.props.itemType,
      action: () => this.props.toggleSymlinkChange(filePatch)
    }, _react["default"].createElement(_react.Fragment, null, detail));
  }

  renderHunkHeaders(filePatch, orderOffset) {
    const toggleVerb = this.props.stagingStatus === 'unstaged' ? 'Stage' : 'Unstage';
    const selectedHunks = new Set(Array.from(this.props.selectedRows, row => this.props.multiFilePatch.getHunkAt(row)));
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement(_markerLayer["default"], null, filePatch.getHunks().map((hunk, index) => {
      const containsSelection = this.props.selectionMode === 'line' && selectedHunks.has(hunk);
      const isSelected = this.props.selectionMode === 'hunk' && selectedHunks.has(hunk);
      let buttonSuffix = '';

      if (containsSelection) {
        buttonSuffix += 'Selected Line';

        if (this.props.selectedRows.size > 1) {
          buttonSuffix += 's';
        }
      } else {
        buttonSuffix += 'Hunk';

        if (selectedHunks.size > 1) {
          buttonSuffix += 's';
        }
      }

      const toggleSelectionLabel = `${toggleVerb} ${buttonSuffix}`;
      const discardSelectionLabel = `Discard ${buttonSuffix}`;
      const startPoint = hunk.getRange().start;
      const startRange = new _atom.Range(startPoint, startPoint);
      return _react["default"].createElement(_marker["default"], {
        key: `hunkHeader-${index}`,
        bufferRange: startRange,
        invalidate: "never"
      }, _react["default"].createElement(_decoration["default"], {
        type: "block",
        order: orderOffset + 0.2,
        className: "github-FilePatchView-controlBlock"
      }, _react["default"].createElement(_hunkHeaderView["default"], {
        refTarget: this.refEditorElement,
        hunk: hunk,
        isSelected: isSelected,
        stagingStatus: this.props.stagingStatus,
        selectionMode: "line",
        toggleSelectionLabel: toggleSelectionLabel,
        discardSelectionLabel: discardSelectionLabel,
        tooltips: this.props.tooltips,
        keymaps: this.props.keymaps,
        toggleSelection: () => this.toggleHunkSelection(hunk, containsSelection),
        discardSelection: () => this.discardHunkSelection(hunk, containsSelection),
        mouseDown: this.didMouseDownOnHeader,
        itemType: this.props.itemType
      })));
    })));
  }

  renderLineDecorations(ranges, lineClass, {
    line,
    gutter,
    icon,
    refHolder
  }) {
    if (ranges.length === 0) {
      return null;
    }

    const holder = refHolder || new _refHolder["default"]();
    return _react["default"].createElement(_markerLayer["default"], {
      handleLayer: holder.setter
    }, ranges.map((range, index) => {
      return _react["default"].createElement(_marker["default"], {
        key: `line-${lineClass}-${index}`,
        bufferRange: range,
        invalidate: "never"
      });
    }), this.renderDecorations(lineClass, {
      line,
      gutter,
      icon
    }));
  }

  renderDecorationsOnLayer(layer, lineClass, {
    line,
    gutter,
    icon
  }) {
    if (layer.getMarkerCount() === 0) {
      return null;
    }

    return _react["default"].createElement(_markerLayer["default"], {
      external: layer
    }, this.renderDecorations(lineClass, {
      line,
      gutter,
      icon
    }));
  }

  renderDecorations(lineClass, {
    line,
    gutter,
    icon
  }) {
    return _react["default"].createElement(_react.Fragment, null, line && _react["default"].createElement(_decoration["default"], {
      type: "line",
      className: lineClass,
      omitEmptyLastRow: false
    }), gutter && _react["default"].createElement(_react.Fragment, null, _react["default"].createElement(_decoration["default"], {
      type: "line-number",
      gutterName: "old-line-numbers",
      className: lineClass,
      omitEmptyLastRow: false
    }), _react["default"].createElement(_decoration["default"], {
      type: "line-number",
      gutterName: "new-line-numbers",
      className: lineClass,
      omitEmptyLastRow: false
    }), _react["default"].createElement(_decoration["default"], {
      type: "gutter",
      gutterName: "github-comment-icon",
      className: `github-editorCommentGutterIcon empty ${lineClass}`,
      omitEmptyLastRow: false
    })), icon && _react["default"].createElement(_decoration["default"], {
      type: "line-number",
      gutterName: "diff-icons",
      className: lineClass,
      omitEmptyLastRow: false
    }));
  }

  toggleHunkSelection(hunk, containsSelection) {
    if (containsSelection) {
      return this.props.toggleRows(this.props.selectedRows, this.props.selectionMode, {
        eventSource: 'button'
      });
    } else {
      const changeRows = new Set(hunk.getChanges().reduce((rows, change) => {
        rows.push(...change.getBufferRows());
        return rows;
      }, []));
      return this.props.toggleRows(changeRows, 'hunk', {
        eventSource: 'button'
      });
    }
  }

  discardHunkSelection(hunk, containsSelection) {
    if (containsSelection) {
      return this.props.discardRows(this.props.selectedRows, this.props.selectionMode, {
        eventSource: 'button'
      });
    } else {
      const changeRows = new Set(hunk.getChanges().reduce((rows, change) => {
        rows.push(...change.getBufferRows());
        return rows;
      }, []));
      return this.props.discardRows(changeRows, 'hunk', {
        eventSource: 'button'
      });
    }
  }

  didMouseDownOnHeader(event, hunk) {
    this.nextSelectionMode = 'hunk';
    this.handleSelectionEvent(event, hunk.getRange());
  }

  didMouseDownOnLineNumber(event) {
    const line = event.bufferRow;

    if (line === undefined || isNaN(line)) {
      return;
    }

    this.nextSelectionMode = 'line';

    if (this.handleSelectionEvent(event.domEvent, [[line, 0], [line, Infinity]])) {
      this.mouseSelectionInProgress = true;
    }
  }

  didMouseMoveOnLineNumber(event) {
    if (!this.mouseSelectionInProgress) {
      return;
    }

    const line = event.bufferRow;

    if (this.lastMouseMoveLine === line || line === undefined || isNaN(line)) {
      return;
    }

    this.lastMouseMoveLine = line;
    this.nextSelectionMode = 'line';
    this.handleSelectionEvent(event.domEvent, [[line, 0], [line, Infinity]], {
      add: true
    });
  }

  didMouseUp() {
    this.mouseSelectionInProgress = false;
  }

  handleSelectionEvent(event, rangeLike, opts) {
    if (event.button !== 0) {
      return false;
    }

    const isWindows = process.platform === 'win32';

    if (event.ctrlKey && !isWindows) {
      // Allow the context menu to open.
      return false;
    }

    const options = _objectSpread2({
      add: false
    }, opts); // Normalize the target selection range


    const converted = _atom.Range.fromObject(rangeLike);

    const range = this.refEditor.map(editor => editor.clipBufferRange(converted)).getOr(converted);

    if (event.metaKey ||
    /* istanbul ignore next */
    event.ctrlKey && isWindows) {
      this.refEditor.map(editor => {
        let intersects = false;
        let without = null;

        for (const selection of editor.getSelections()) {
          if (selection.intersectsBufferRange(range)) {
            // Remove range from this selection by truncating it to the "near edge" of the range and creating a
            // new selection from the "far edge" to the previous end. Omit either side if it is empty.
            intersects = true;
            const selectionRange = selection.getBufferRange();
            const newRanges = [];

            if (!range.start.isEqual(selectionRange.start)) {
              // Include the bit from the selection's previous start to the range's start.
              let nudged = range.start;

              if (range.start.column === 0) {
                const lastColumn = editor.getBuffer().lineLengthForRow(range.start.row - 1);
                nudged = [range.start.row - 1, lastColumn];
              }

              newRanges.push([selectionRange.start, nudged]);
            }

            if (!range.end.isEqual(selectionRange.end)) {
              // Include the bit from the range's end to the selection's end.
              let nudged = range.end;
              const lastColumn = editor.getBuffer().lineLengthForRow(range.end.row);

              if (range.end.column === lastColumn) {
                nudged = [range.end.row + 1, 0];
              }

              newRanges.push([nudged, selectionRange.end]);
            }

            if (newRanges.length > 0) {
              selection.setBufferRange(newRanges[0]);

              for (const newRange of newRanges.slice(1)) {
                editor.addSelectionForBufferRange(newRange, {
                  reversed: selection.isReversed()
                });
              }
            } else {
              without = selection;
            }
          }
        }

        if (without !== null) {
          const replacementRanges = editor.getSelections().filter(each => each !== without).map(each => each.getBufferRange());

          if (replacementRanges.length > 0) {
            editor.setSelectedBufferRanges(replacementRanges);
          }
        }

        if (!intersects) {
          // Add this range as a new, distinct selection.
          editor.addSelectionForBufferRange(range);
        }

        return null;
      });
    } else if (options.add || event.shiftKey) {
      // Extend the existing selection to encompass this range.
      this.refEditor.map(editor => {
        const lastSelection = editor.getLastSelection();
        const lastSelectionRange = lastSelection.getBufferRange(); // You are now entering the wall of ternery operators. This is your last exit before the tollbooth

        const isBefore = range.start.isLessThan(lastSelectionRange.start);
        const farEdge = isBefore ? range.start : range.end;
        const newRange = isBefore ? [farEdge, lastSelectionRange.end] : [lastSelectionRange.start, farEdge];
        lastSelection.setBufferRange(newRange, {
          reversed: isBefore
        });
        return null;
      });
    } else {
      this.refEditor.map(editor => editor.setSelectedBufferRange(range));
    }

    return true;
  }

  didConfirm() {
    return this.props.toggleRows(this.props.selectedRows, this.props.selectionMode);
  }

  didToggleSelectionMode() {
    const selectedHunks = this.getSelectedHunks();
    this.withSelectionMode({
      line: () => {
        const hunkRanges = selectedHunks.map(hunk => hunk.getRange());
        this.nextSelectionMode = 'hunk';
        this.refEditor.map(editor => editor.setSelectedBufferRanges(hunkRanges));
      },
      hunk: () => {
        let firstChangeRow = Infinity;

        for (const hunk of selectedHunks) {
          const [firstChange] = hunk.getChanges();
          /* istanbul ignore else */

          if (firstChange && (!firstChangeRow || firstChange.getStartBufferRow() < firstChangeRow)) {
            firstChangeRow = firstChange.getStartBufferRow();
          }
        }

        this.nextSelectionMode = 'line';
        this.refEditor.map(editor => {
          editor.setSelectedBufferRanges([[[firstChangeRow, 0], [firstChangeRow, Infinity]]]);
          return null;
        });
      }
    });
  }

  selectNextHunk() {
    this.refEditor.map(editor => {
      const nextHunks = new Set(this.withSelectedHunks(hunk => this.getHunkAfter(hunk) || hunk));
      const nextRanges = Array.from(nextHunks, hunk => hunk.getRange());
      this.nextSelectionMode = 'hunk';
      editor.setSelectedBufferRanges(nextRanges);
      return null;
    });
  }

  selectPreviousHunk() {
    this.refEditor.map(editor => {
      const nextHunks = new Set(this.withSelectedHunks(hunk => this.getHunkBefore(hunk) || hunk));
      const nextRanges = Array.from(nextHunks, hunk => hunk.getRange());
      this.nextSelectionMode = 'hunk';
      editor.setSelectedBufferRanges(nextRanges);
      return null;
    });
  }

  didOpenFile({
    selectedFilePatch
  }) {
    const cursorsByFilePatch = new Map();
    this.refEditor.map(editor => {
      const placedRows = new Set();

      for (const cursor of editor.getCursors()) {
        const cursorRow = cursor.getBufferPosition().row;
        const hunk = this.props.multiFilePatch.getHunkAt(cursorRow);
        const filePatch = this.props.multiFilePatch.getFilePatchAt(cursorRow);
        /* istanbul ignore next */

        if (!hunk) {
          continue;
        }

        let newRow = hunk.getNewRowAt(cursorRow);
        let newColumn = cursor.getBufferPosition().column;

        if (newRow === null) {
          let nearestRow = hunk.getNewStartRow();

          for (const region of hunk.getRegions()) {
            if (!region.includesBufferRow(cursorRow)) {
              region.when({
                unchanged: () => {
                  nearestRow += region.bufferRowCount();
                },
                addition: () => {
                  nearestRow += region.bufferRowCount();
                }
              });
            } else {
              break;
            }
          }

          if (!placedRows.has(nearestRow)) {
            newRow = nearestRow;
            newColumn = 0;
            placedRows.add(nearestRow);
          }
        }

        if (newRow !== null) {
          // Why is this needed? I _think_ everything is in terms of buffer position
          // so there shouldn't be an off-by-one issue
          newRow -= 1;
          const cursors = cursorsByFilePatch.get(filePatch);

          if (!cursors) {
            cursorsByFilePatch.set(filePatch, [[newRow, newColumn]]);
          } else {
            cursors.push([newRow, newColumn]);
          }
        }
      }

      return null;
    });
    const filePatchesWithCursors = new Set(cursorsByFilePatch.keys());

    if (selectedFilePatch && !filePatchesWithCursors.has(selectedFilePatch)) {
      const [firstHunk] = selectedFilePatch.getHunks();
      const cursorRow = firstHunk ? firstHunk.getNewStartRow() - 1 :
      /* istanbul ignore next */
      0;
      return this.props.openFile(selectedFilePatch, [[cursorRow, 0]], true);
    } else {
      const pending = cursorsByFilePatch.size === 1;
      return Promise.all(Array.from(cursorsByFilePatch, value => {
        const [filePatch, cursors] = value;
        return this.props.openFile(filePatch, cursors, pending);
      }));
    }
  }

  getSelectedRows() {
    return this.refEditor.map(editor => {
      return new Set(editor.getSelections().map(selection => selection.getBufferRange()).reduce((acc, range) => {
        for (const row of range.getRows()) {
          if (this.isChangeRow(row)) {
            acc.push(row);
          }
        }

        return acc;
      }, []));
    }).getOr(new Set());
  }

  didAddSelection() {
    this.didChangeSelectedRows();
  }

  didChangeSelectionRange(event) {
    if (!event || event.oldBufferRange.start.row !== event.newBufferRange.start.row || event.oldBufferRange.end.row !== event.newBufferRange.end.row) {
      this.didChangeSelectedRows();
    }
  }

  didDestroySelection() {
    this.didChangeSelectedRows();
  }

  didChangeSelectedRows() {
    if (this.suppressChanges) {
      return;
    }

    const nextCursorRows = this.refEditor.map(editor => {
      return editor.getCursorBufferPositions().map(position => position.row);
    }).getOr([]);
    const hasMultipleFileSelections = this.props.multiFilePatch.spansMultipleFiles(nextCursorRows);
    this.props.selectedRowsChanged(this.getSelectedRows(), this.nextSelectionMode || 'line', hasMultipleFileSelections);
  }

  oldLineNumberLabel({
    bufferRow,
    softWrapped
  }) {
    const hunk = this.props.multiFilePatch.getHunkAt(bufferRow);

    if (hunk === undefined) {
      return this.pad('');
    }

    const oldRow = hunk.getOldRowAt(bufferRow);

    if (softWrapped) {
      return this.pad(oldRow === null ? '' : '•');
    }

    return this.pad(oldRow);
  }

  newLineNumberLabel({
    bufferRow,
    softWrapped
  }) {
    const hunk = this.props.multiFilePatch.getHunkAt(bufferRow);

    if (hunk === undefined) {
      return this.pad('');
    }

    const newRow = hunk.getNewRowAt(bufferRow);

    if (softWrapped) {
      return this.pad(newRow === null ? '' : '•');
    }

    return this.pad(newRow);
  }
  /*
   * Return a Set of the Hunks that include at least one editor selection. The selection need not contain an actual
   * change row.
   */


  getSelectedHunks() {
    return this.withSelectedHunks(each => each);
  }

  withSelectedHunks(callback) {
    return this.refEditor.map(editor => {
      const seen = new Set();
      return editor.getSelectedBufferRanges().reduce((acc, range) => {
        for (const row of range.getRows()) {
          const hunk = this.props.multiFilePatch.getHunkAt(row);

          if (!hunk || seen.has(hunk)) {
            continue;
          }

          seen.add(hunk);
          acc.push(callback(hunk));
        }

        return acc;
      }, []);
    }).getOr([]);
  }
  /*
   * Return a Set of FilePatches that include at least one editor selection. The selection need not contain an actual
   * change row.
   */


  getSelectedFilePatches() {
    return this.refEditor.map(editor => {
      const patches = new Set();

      for (const range of editor.getSelectedBufferRanges()) {
        for (const row of range.getRows()) {
          const patch = this.props.multiFilePatch.getFilePatchAt(row);
          patches.add(patch);
        }
      }

      return patches;
    }).getOr(new Set());
  }

  getHunkBefore(hunk) {
    const prevRow = hunk.getRange().start.row - 1;
    return this.props.multiFilePatch.getHunkAt(prevRow);
  }

  getHunkAfter(hunk) {
    const nextRow = hunk.getRange().end.row + 1;
    return this.props.multiFilePatch.getHunkAt(nextRow);
  }

  isChangeRow(bufferRow) {
    const changeLayers = [this.props.multiFilePatch.getAdditionLayer(), this.props.multiFilePatch.getDeletionLayer()];
    return changeLayers.some(layer => layer.findMarkers({
      intersectsRow: bufferRow
    }).length > 0);
  }

  withSelectionMode(callbacks) {
    const callback = callbacks[this.props.selectionMode];
    /* istanbul ignore if */

    if (!callback) {
      throw new Error(`Unknown selection mode: ${this.props.selectionMode}`);
    }

    return callback();
  }

  pad(num) {
    const maxDigits = this.props.multiFilePatch.getMaxLineNumberWidth();

    if (num === null) {
      return _helpers.NBSP_CHARACTER.repeat(maxDigits);
    } else {
      return _helpers.NBSP_CHARACTER.repeat(maxDigits - num.toString().length) + num.toString();
    }
  }

  measurePerformance(action) {
    /* istanbul ignore else */
    if ((action === 'update' || action === 'mount') && performance.getEntriesByName(`MultiFilePatchView-${action}-start`).length > 0) {
      performance.mark(`MultiFilePatchView-${action}-end`);
      performance.measure(`MultiFilePatchView-${action}`, `MultiFilePatchView-${action}-start`, `MultiFilePatchView-${action}-end`);
      const perf = performance.getEntriesByName(`MultiFilePatchView-${action}`)[0];
      performance.clearMarks(`MultiFilePatchView-${action}-start`);
      performance.clearMarks(`MultiFilePatchView-${action}-end`);
      performance.clearMeasures(`MultiFilePatchView-${action}`);
      (0, _reporterProxy.addEvent)(`MultiFilePatchView-${action}`, {
        "package": 'github',
        filePatchesLineCounts: this.props.multiFilePatch.getFilePatches().map(fp => fp.getPatch().getChangedLineCount()),
        duration: perf.duration
      });
    }
  }

}

exports["default"] = MultiFilePatchView;

_defineProperty(MultiFilePatchView, "propTypes", {
  // Behavior controls
  stagingStatus: _propTypes["default"].oneOf(['staged', 'unstaged']),
  isPartiallyStaged: _propTypes["default"].bool,
  itemType: _propTypes2.ItemTypePropType.isRequired,
  // Models
  repository: _propTypes["default"].object.isRequired,
  multiFilePatch: _propTypes2.MultiFilePatchPropType.isRequired,
  selectionMode: _propTypes["default"].oneOf(['hunk', 'line']).isRequired,
  selectedRows: _propTypes["default"].object.isRequired,
  hasMultipleFileSelections: _propTypes["default"].bool.isRequired,
  hasUndoHistory: _propTypes["default"].bool,
  // Review comments
  reviewCommentsLoading: _propTypes["default"].bool,
  reviewCommentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })),
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  pullRequest: _propTypes["default"].object,
  // Callbacks
  selectedRowsChanged: _propTypes["default"].func,
  // Action methods
  switchToIssueish: _propTypes["default"].func,
  diveIntoMirrorPatch: _propTypes["default"].func,
  surface: _propTypes["default"].func,
  openFile: _propTypes["default"].func,
  toggleFile: _propTypes["default"].func,
  toggleRows: _propTypes["default"].func,
  toggleModeChange: _propTypes["default"].func,
  toggleSymlinkChange: _propTypes["default"].func,
  undoLastDiscard: _propTypes["default"].func,
  discardRows: _propTypes["default"].func,
  onWillUpdatePatch: _propTypes["default"].func,
  onDidUpdatePatch: _propTypes["default"].func,
  // External refs
  refEditor: _propTypes2.RefHolderPropType,
  refInitialFocus: _propTypes2.RefHolderPropType,
  // for navigating the PR changed files tab
  onOpenFilesTab: _propTypes["default"].func,
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  // for opening the reviews dock item
  endpoint: _propTypes2.EndpointPropType,
  owner: _propTypes["default"].string,
  repo: _propTypes["default"].string,
  number: _propTypes["default"].number,
  workdirPath: _propTypes["default"].string
});

_defineProperty(MultiFilePatchView, "defaultProps", {
  onWillUpdatePatch: () => new _eventKit.Disposable(),
  onDidUpdatePatch: () => new _eventKit.Disposable(),
  reviewCommentsLoading: false,
  reviewCommentThreads: []
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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