"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueDetailView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _issueTimelineController = _interopRequireDefault(require("../controllers/issue-timeline-controller"));

var _emojiReactionsController = _interopRequireDefault(require("../controllers/emoji-reactions-controller"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _issueishBadge = _interopRequireDefault(require("../views/issueish-badge"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../views/github-dotcom-markdown"));

var _periodicRefresher = _interopRequireDefault(require("../periodic-refresher"));

var _reporterProxy = require("../reporter-proxy");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueDetailView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      refreshing: false
    });

    _defineProperty(this, "handleRefreshClick", e => {
      e.preventDefault();
      this.refresher.refreshNow(true);
    });

    _defineProperty(this, "recordOpenInBrowserEvent", () => {
      (0, _reporterProxy.addEvent)('open-issue-in-browser', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "refresh", () => {
      if (this.state.refreshing) {
        return;
      }

      this.setState({
        refreshing: true
      });
      this.props.relay.refetch({
        repoId: this.props.repository.id,
        issueishId: this.props.issue.id,
        timelineCount: 100,
        timelineCursor: null
      }, null, err => {
        if (err) {
          this.props.reportRelayError('Unable to refresh issue details', err);
        }

        this.setState({
          refreshing: false
        });
      }, {
        force: true
      });
    });
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher["default"](BareIssueDetailView, {
      interval: () => 5 * 60 * 1000,
      getCurrentId: () => this.props.issue.id,
      refresh: this.refresh,
      minimumIntervalPerId: 2 * 60 * 1000
    }); // auto-refresh disabled for now until pagination is handled
    // this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  renderIssueBody(issue) {
    return _react["default"].createElement("div", {
      className: "github-IssueishDetailView-issueBody"
    }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
      html: issue.bodyHTML || '<em>No description provided.</em>',
      switchToIssueish: this.props.switchToIssueish
    }), _react["default"].createElement(_emojiReactionsController["default"], {
      reactable: issue,
      tooltips: this.props.tooltips,
      reportRelayError: this.props.reportRelayError
    }), _react["default"].createElement(_issueTimelineController["default"], {
      issue: issue,
      switchToIssueish: this.props.switchToIssueish
    }));
  }

  render() {
    const repo = this.props.repository;
    const issue = this.props.issue;
    const author = issue.author || _helpers.GHOST_USER;
    return _react["default"].createElement("div", {
      className: "github-IssueishDetailView native-key-bindings"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-container"
    }, _react["default"].createElement("header", {
      className: "github-IssueishDetailView-header"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-avatar",
      href: author.url
    }, _react["default"].createElement("img", {
      className: "github-IssueishDetailView-avatarImage",
      src: author.avatarUrl,
      title: author.login,
      alt: author.login
    }))), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn is-flexible"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow is-fullwidth"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-title",
      href: issue.url
    }, issue.title)), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow"
    }, _react["default"].createElement(_issueishBadge["default"], {
      className: "github-IssueishDetailView-headerBadge",
      type: issue.__typename,
      state: issue.state
    }), _react["default"].createElement(_octicon["default"], {
      icon: "repo-sync",
      className: (0, _classnames["default"])('github-IssueishDetailView-headerRefreshButton', {
        refreshing: this.state.refreshing
      }),
      onClick: this.handleRefreshClick
    }), _react["default"].createElement("a", {
      className: "github-IssueishDetailView-headerLink",
      title: "open on GitHub.com",
      href: issue.url,
      onClick: this.recordOpenInBrowserEvent
    }, repo.owner.login, "/", repo.name, "#", issue.number)))), this.renderIssueBody(issue), _react["default"].createElement("footer", {
      className: "github-IssueishDetailView-footer"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-footerLink icon icon-mark-github",
      href: issue.url
    }, repo.owner.login, "/", repo.name, "#", issue.number))));
  }

}

exports.BareIssueDetailView = BareIssueDetailView;

_defineProperty(BareIssueDetailView, "propTypes", {
  // Relay response
  relay: _propTypes["default"].shape({
    refetch: _propTypes["default"].func.isRequired
  }),
  switchToIssueish: _propTypes["default"].func.isRequired,
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    name: _propTypes["default"].string.isRequired,
    owner: _propTypes["default"].shape({
      login: _propTypes["default"].string
    })
  }),
  issue: _propTypes["default"].shape({
    __typename: _propTypes["default"].string.isRequired,
    id: _propTypes["default"].string.isRequired,
    title: _propTypes["default"].string,
    url: _propTypes["default"].string.isRequired,
    bodyHTML: _propTypes["default"].string,
    number: _propTypes["default"].number,
    state: _propTypes["default"].oneOf(['OPEN', 'CLOSED']).isRequired,
    author: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired,
      avatarUrl: _propTypes["default"].string.isRequired,
      url: _propTypes["default"].string.isRequired
    }).isRequired,
    reactionGroups: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      content: _propTypes["default"].string.isRequired,
      users: _propTypes["default"].shape({
        totalCount: _propTypes["default"].number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired,
  // Atom environment
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  reportRelayError: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createRefetchContainer)(BareIssueDetailView, {
  repository: function () {
    const node = require("./__generated__/issueDetailView_repository.graphql");

    if (node.hash && node.hash !== "295a60f53b25b6fdb07a1539cda447f2") {
      console.error("The definition of 'issueDetailView_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueDetailView_repository.graphql");
  },
  issue: function () {
    const node = require("./__generated__/issueDetailView_issue.graphql");

    if (node.hash && node.hash !== "f7adc2e75c1d55df78481fd359bf7180") {
      console.error("The definition of 'issueDetailView_issue' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueDetailView_issue.graphql");
  }
}, function () {
  const node = require("./__generated__/issueDetailViewRefetchQuery.graphql");

  if (node.hash && node.hash !== "180dc18124ae95e41044932a2daf88ad") {
    console.error("The definition of 'issueDetailViewRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/issueDetailViewRefetchQuery.graphql");
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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