"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _autofocus = _interopRequireDefault(require("../autofocus"));

var _dialogView = _interopRequireDefault(require("./dialog-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class InitDialog extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "accept", () => {
      const destPath = this.destinationPath.getText();

      if (destPath.length === 0) {
        return Promise.resolve();
      }

      return this.props.request.accept(destPath);
    });

    _defineProperty(this, "setAcceptEnablement", () => {
      const enablement = !this.destinationPath.isEmpty();

      if (enablement !== this.state.acceptEnabled) {
        this.setState({
          acceptEnabled: enablement
        });
      }
    });

    this.autofocus = new _autofocus["default"]();
    this.destinationPath = new _atom.TextBuffer({
      text: this.props.request.getParams().dirPath
    });
    this.sub = this.destinationPath.onDidChange(this.setAcceptEnablement);
    this.state = {
      acceptEnabled: !this.destinationPath.isEmpty()
    };
  }

  render() {
    return _react["default"].createElement(_dialogView["default"], {
      progressMessage: "Initializing...",
      acceptEnabled: this.state.acceptEnabled,
      acceptClassName: "icon icon-repo-create",
      acceptText: "Init",
      accept: this.accept,
      cancel: this.props.request.cancel,
      autofocus: this.autofocus,
      inProgress: this.props.inProgress,
      error: this.props.error,
      workspace: this.props.workspace,
      commands: this.props.commands
    }, _react["default"].createElement("label", {
      className: "github-DialogLabel"
    }, "Initialize git repository in directory", _react["default"].createElement(_atomTextEditor["default"], {
      ref: this.autofocus.target,
      mini: true,
      readOnly: this.props.inProgress,
      preselect: true,
      buffer: this.destinationPath
    })));
  }

  componentDidMount() {
    this.autofocus.trigger();
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

}

exports["default"] = InitDialog;

_defineProperty(InitDialog, "propTypes", {
  // Model
  request: _propTypes["default"].shape({
    getParams: _propTypes["default"].func.isRequired,
    accept: _propTypes["default"].func.isRequired,
    cancel: _propTypes["default"].func.isRequired
  }).isRequired,
  inProgress: _propTypes["default"].bool,
  error: _propTypes["default"].instanceOf(Error),
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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