"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareGithubDotcomMarkdown = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _issueishLink = require("./issueish-link");

var _userMentionTooltipItem = _interopRequireDefault(require("../items/user-mention-tooltip-item"));

var _issueishTooltipItem = _interopRequireDefault(require("../items/issueish-tooltip-item"));

var _relayEnvironment = _interopRequireDefault(require("./relay-environment"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareGithubDotcomMarkdown extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "handleClick", event => {
      if (event.target.dataset.url) {
        return this.props.handleClickEvent(event, event.target.dataset.url);
      } else {
        return null;
      }
    });

    _defineProperty(this, "openLinkInNewTab", event => {
      return this.props.openIssueishLinkInNewTab(event.target.dataset.url);
    });

    _defineProperty(this, "openLinkInThisTab", event => {
      const {
        repoOwner,
        repoName,
        issueishNumber
      } = (0, _issueishLink.getDataFromGithubUrl)(event.target.dataset.url);
      this.props.switchToIssueish(repoOwner, repoName, issueishNumber);
    });

    _defineProperty(this, "openLinkInBrowser", event => {
      return this.props.openLinkInBrowser(event.target.getAttribute('href'));
    });
  }

  componentDidMount() {
    this.commandSubscriptions = atom.commands.add(_reactDom["default"].findDOMNode(this), {
      'github:open-link-in-new-tab': this.openLinkInNewTab,
      'github:open-link-in-browser': this.openLinkInBrowser,
      'github:open-link-in-this-tab': this.openLinkInThisTab
    });
    this.setupComponentHandlers();
    this.setupTooltipHandlers();
  }

  componentDidUpdate() {
    this.setupTooltipHandlers();
  }

  setupComponentHandlers() {
    this.component.addEventListener('click', this.handleClick);
    this.componentHandlers = new _eventKit.Disposable(() => {
      this.component.removeEventListener('click', this.handleClick);
    });
  }

  setupTooltipHandlers() {
    if (this.tooltipSubscriptions) {
      this.tooltipSubscriptions.dispose();
    }

    this.tooltipSubscriptions = new _eventKit.CompositeDisposable();
    this.component.querySelectorAll('.user-mention').forEach(node => {
      const item = new _userMentionTooltipItem["default"](node.textContent, this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        "class": 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
    this.component.querySelectorAll('.issue-link').forEach(node => {
      const item = new _issueishTooltipItem["default"](node.getAttribute('href'), this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        "class": 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
  }

  componentWillUnmount() {
    this.commandSubscriptions.dispose();
    this.componentHandlers.dispose();
    this.tooltipSubscriptions && this.tooltipSubscriptions.dispose();
  }

  render() {
    return _react["default"].createElement("div", {
      className: `github-DotComMarkdownHtml native-key-bindings ${this.props.className}`,
      tabIndex: "-1",
      ref: c => {
        this.component = c;
      },
      dangerouslySetInnerHTML: {
        __html: this.props.html
      }
    });
  }

}

exports.BareGithubDotcomMarkdown = BareGithubDotcomMarkdown;

_defineProperty(BareGithubDotcomMarkdown, "propTypes", {
  relayEnvironment: _propTypes["default"].object.isRequired,
  className: _propTypes["default"].string,
  html: _propTypes["default"].string.isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired,
  handleClickEvent: _propTypes["default"].func,
  openIssueishLinkInNewTab: _propTypes["default"].func,
  openLinkInBrowser: _propTypes["default"].func
});

_defineProperty(BareGithubDotcomMarkdown, "defaultProps", {
  className: '',
  handleClickEvent: _issueishLink.handleClickEvent,
  openIssueishLinkInNewTab: _issueishLink.openIssueishLinkInNewTab,
  openLinkInBrowser: _issueishLink.openLinkInBrowser
});

class GithubDotcomMarkdown extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      lastMarkdown: null,
      html: null
    });
  }

  static getDerivedStateFromProps(props, state) {
    if (props.html) {
      return {
        html: props.html
      };
    }

    if (props.markdown && props.markdown !== state.lastMarkdown) {
      return {
        html: (0, _helpers.renderMarkdown)(props.markdown),
        lastMarkdown: props.markdown
      };
    }

    return null;
  }

  render() {
    return _react["default"].createElement(_relayEnvironment["default"].Consumer, null, relayEnvironment => _react["default"].createElement(BareGithubDotcomMarkdown, _extends({
      relayEnvironment: relayEnvironment
    }, this.props, {
      html: this.state.html
    })));
  }

}

exports["default"] = GithubDotcomMarkdown;

_defineProperty(GithubDotcomMarkdown, "propTypes", {
  markdown: _propTypes["default"].string,
  html: _propTypes["default"].string
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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