"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _atom = require("atom");

var _stagingView = _interopRequireDefault(require("./staging-view"));

var _commitController = _interopRequireDefault(require("../controllers/commit-controller"));

var _recentCommitsController = _interopRequireDefault(require("../controllers/recent-commits-controller"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitTabView extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'initializeRepo', 'blur', 'advanceFocus', 'retreatFocus', 'quietlySelectItem');
    this.subscriptions = new _atom.CompositeDisposable();
    this.refCommitController = new _refHolder["default"]();
    this.refRecentCommitsController = new _refHolder["default"]();
  }

  componentDidMount() {
    this.props.refRoot.map(root => {
      return this.subscriptions.add(this.props.commands.add(root, {
        'tool-panel:unfocus': this.blur,
        'core:focus-next': this.advanceFocus,
        'core:focus-previous': this.retreatFocus
      }));
    });
  }

  render() {
    if (this.props.repository.isTooLarge()) {
      return _react["default"].createElement("div", {
        className: "github-Git is-empty",
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react["default"].createElement("div", {
        ref: "noRepoMessage",
        className: "github-Git too-many-changes"
      }, _react["default"].createElement("div", {
        className: "github-Git-LargeIcon icon icon-diff"
      }), _react["default"].createElement("h1", null, "Too many changes"), _react["default"].createElement("div", {
        className: "initialize-repo-description"
      }, "The repository at ", _react["default"].createElement("strong", null, this.props.workingDirectoryPath), " has too many changed files to display in Atom. Ensure that you have set up an appropriate ", _react["default"].createElement("code", null, ".gitignore"), " file.")));
    } else if (this.props.repository.hasDirectory() && !(0, _helpers.isValidWorkdir)(this.props.repository.getWorkingDirectoryPath())) {
      return _react["default"].createElement("div", {
        className: "github-Git is-empty",
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react["default"].createElement("div", {
        ref: "noRepoMessage",
        className: "github-Git unsupported-directory"
      }, _react["default"].createElement("div", {
        className: "github-Git-LargeIcon icon icon-alert"
      }), _react["default"].createElement("h1", null, "Unsupported directory"), _react["default"].createElement("div", {
        className: "initialize-repo-description"
      }, "Atom does not support managing Git repositories in your home or root directories.")));
    } else if (this.props.repository.showGitTabInit()) {
      const inProgress = this.props.repository.showGitTabInitInProgress();
      const message = this.props.repository.hasDirectory() ? _react["default"].createElement("span", null, "Initialize ", _react["default"].createElement("strong", null, this.props.workingDirectoryPath), " with a Git repository") : _react["default"].createElement("span", null, "Initialize a new project directory with a Git repository");
      return _react["default"].createElement("div", {
        className: "github-Git is-empty",
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react["default"].createElement("div", {
        ref: "noRepoMessage",
        className: "github-Git no-repository"
      }, _react["default"].createElement("div", {
        className: "github-Git-LargeIcon icon icon-repo"
      }), _react["default"].createElement("h1", null, "Create Repository"), _react["default"].createElement("div", {
        className: "initialize-repo-description"
      }, message), _react["default"].createElement("button", {
        onClick: this.initializeRepo,
        disabled: inProgress,
        className: "btn btn-primary"
      }, inProgress ? 'Creating repository...' : 'Create repository')));
    } else {
      const isLoading = this.props.isLoading || this.props.repository.showGitTabLoading();
      return _react["default"].createElement("div", {
        className: (0, _classnames["default"])('github-Git', {
          'is-loading': isLoading
        }),
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react["default"].createElement(_stagingView["default"], {
        ref: this.props.refStagingView.setter,
        commands: this.props.commands,
        notificationManager: this.props.notificationManager,
        workspace: this.props.workspace,
        stagedChanges: this.props.stagedChanges,
        unstagedChanges: this.props.unstagedChanges,
        mergeConflicts: this.props.mergeConflicts,
        workingDirectoryPath: this.props.workingDirectoryPath,
        resolutionProgress: this.props.resolutionProgress,
        openFiles: this.props.openFiles,
        discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
        attemptFileStageOperation: this.props.attemptFileStageOperation,
        attemptStageAllOperation: this.props.attemptStageAllOperation,
        undoLastDiscard: this.props.undoLastDiscard,
        abortMerge: this.props.abortMerge,
        resolveAsOurs: this.props.resolveAsOurs,
        resolveAsTheirs: this.props.resolveAsTheirs,
        lastCommit: this.props.lastCommit,
        isLoading: this.props.isLoading,
        hasUndoHistory: this.props.hasUndoHistory,
        isMerging: this.props.isMerging
      }), _react["default"].createElement(_commitController["default"], {
        ref: this.refCommitController.setter,
        tooltips: this.props.tooltips,
        config: this.props.config,
        stagedChangesExist: this.props.stagedChanges.length > 0,
        mergeConflictsExist: this.props.mergeConflicts.length > 0,
        prepareToCommit: this.props.prepareToCommit,
        commit: this.props.commit,
        abortMerge: this.props.abortMerge,
        currentBranch: this.props.currentBranch,
        workspace: this.props.workspace,
        commands: this.props.commands,
        notificationManager: this.props.notificationManager,
        grammars: this.props.grammars,
        mergeMessage: this.props.mergeMessage,
        isMerging: this.props.isMerging,
        isLoading: this.props.isLoading,
        lastCommit: this.props.lastCommit,
        repository: this.props.repository,
        userStore: this.props.userStore,
        selectedCoAuthors: this.props.selectedCoAuthors,
        updateSelectedCoAuthors: this.props.updateSelectedCoAuthors
      }), _react["default"].createElement(_recentCommitsController["default"], {
        ref: this.refRecentCommitsController.setter,
        commands: this.props.commands,
        commits: this.props.recentCommits,
        isLoading: this.props.isLoading,
        undoLastCommit: this.props.undoLastCommit,
        workspace: this.props.workspace,
        repository: this.props.repository
      }));
    }
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }

  initializeRepo(event) {
    event.preventDefault();
    const workdir = this.props.repository.isAbsent() ? null : this.props.repository.getWorkingDirectoryPath();
    return this.props.openInitializeDialog(workdir);
  }

  getFocus(element) {
    for (const ref of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      const focus = ref.map(sub => sub.getFocus(element)).getOr(null);

      if (focus !== null) {
        return focus;
      }
    }

    return null;
  }

  setFocus(focus) {
    for (const ref of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      if (ref.map(sub => sub.setFocus(focus)).getOr(false)) {
        return true;
      }
    }

    return false;
  }

  blur() {
    this.props.workspace.getCenter().activate();
  }

  async advanceFocus(evt) {
    const currentFocus = this.getFocus(document.activeElement);
    let nextSeen = false;

    for (const subHolder of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      const next = await subHolder.map(sub => sub.advanceFocusFrom(currentFocus)).getOr(null);

      if (next !== null && !nextSeen) {
        nextSeen = true;
        evt.stopPropagation();

        if (next !== currentFocus) {
          this.setFocus(next);
        }
      }
    }
  }

  async retreatFocus(evt) {
    const currentFocus = this.getFocus(document.activeElement);
    let previousSeen = false;

    for (const subHolder of [this.refRecentCommitsController, this.refCommitController, this.props.refStagingView]) {
      const previous = await subHolder.map(sub => sub.retreatFocusFrom(currentFocus)).getOr(null);

      if (previous !== null && !previousSeen) {
        previousSeen = true;
        evt.stopPropagation();

        if (previous !== currentFocus) {
          this.setFocus(previous);
        }
      }
    }
  }

  async focusAndSelectStagingItem(filePath, stagingStatus) {
    await this.quietlySelectItem(filePath, stagingStatus);
    this.setFocus(GitTabView.focus.STAGING);
  }

  focusAndSelectRecentCommit() {
    this.setFocus(_recentCommitsController["default"].focus.RECENT_COMMIT);
  }

  focusAndSelectCommitPreviewButton() {
    this.setFocus(GitTabView.focus.COMMIT_PREVIEW_BUTTON);
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.props.refStagingView.map(view => view.quietlySelectItem(filePath, stagingStatus)).getOr(false);
  }

  hasFocus() {
    return this.props.refRoot.map(root => root.contains(document.activeElement)).getOr(false);
  }

}

exports["default"] = GitTabView;

_defineProperty(GitTabView, "focus", _objectSpread2({}, _stagingView["default"].focus, {}, _commitController["default"].focus, {}, _recentCommitsController["default"].focus));

_defineProperty(GitTabView, "propTypes", {
  refRoot: _propTypes2.RefHolderPropType,
  refStagingView: _propTypes2.RefHolderPropType,
  repository: _propTypes["default"].object.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  lastCommit: _propTypes["default"].object.isRequired,
  currentBranch: _propTypes["default"].object,
  recentCommits: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired,
  isMerging: _propTypes["default"].bool,
  isRebasing: _propTypes["default"].bool,
  hasUndoHistory: _propTypes["default"].bool,
  unstagedChanges: _propTypes["default"].arrayOf(_propTypes["default"].object),
  stagedChanges: _propTypes["default"].arrayOf(_propTypes["default"].object),
  mergeConflicts: _propTypes["default"].arrayOf(_propTypes["default"].object),
  workingDirectoryPath: _propTypes["default"].string,
  mergeMessage: _propTypes["default"].string,
  userStore: _propTypes2.UserStorePropType.isRequired,
  selectedCoAuthors: _propTypes["default"].arrayOf(_propTypes2.AuthorPropType),
  updateSelectedCoAuthors: _propTypes["default"].func.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  grammars: _propTypes["default"].object.isRequired,
  resolutionProgress: _propTypes["default"].object.isRequired,
  notificationManager: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  project: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  openInitializeDialog: _propTypes["default"].func.isRequired,
  abortMerge: _propTypes["default"].func.isRequired,
  commit: _propTypes["default"].func.isRequired,
  undoLastCommit: _propTypes["default"].func.isRequired,
  prepareToCommit: _propTypes["default"].func.isRequired,
  resolveAsOurs: _propTypes["default"].func.isRequired,
  resolveAsTheirs: _propTypes["default"].func.isRequired,
  undoLastDiscard: _propTypes["default"].func.isRequired,
  attemptStageAllOperation: _propTypes["default"].func.isRequired,
  attemptFileStageOperation: _propTypes["default"].func.isRequired,
  discardWorkDirChangesForPaths: _propTypes["default"].func.isRequired,
  openFiles: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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