"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class FilePatchMetaView extends _react["default"].Component {
  renderMetaControls() {
    if (this.props.itemType === _commitDetailItem["default"] || this.props.itemType === _issueishDetailItem["default"]) {
      return null;
    }

    return _react["default"].createElement("div", {
      className: "github-FilePatchView-metaControls"
    }, _react["default"].createElement("button", {
      className: (0, _classnames["default"])('github-FilePatchView-metaButton', 'icon', this.props.actionIcon),
      onClick: this.props.action
    }, this.props.actionText));
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-FilePatchView-meta"
    }, _react["default"].createElement("div", {
      className: "github-FilePatchView-metaContainer"
    }, _react["default"].createElement("header", {
      className: "github-FilePatchView-metaHeader"
    }, _react["default"].createElement("h3", {
      className: "github-FilePatchView-metaTitle"
    }, this.props.title), this.renderMetaControls()), _react["default"].createElement("div", {
      className: "github-FilePatchView-metaDetails"
    }, this.props.children)));
  }

}

exports["default"] = FilePatchMetaView;

_defineProperty(FilePatchMetaView, "propTypes", {
  title: _propTypes["default"].string.isRequired,
  actionIcon: _propTypes["default"].string.isRequired,
  actionText: _propTypes["default"].string.isRequired,
  action: _propTypes["default"].func.isRequired,
  children: _propTypes["default"].element.isRequired,
  itemType: _propTypes2.ItemTypePropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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