"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ErrorView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderDescription", (description, key) => {
      if (this.props.preformatted) {
        return _react["default"].createElement("pre", {
          key: key,
          className: "github-Message-description"
        }, description);
      } else {
        return _react["default"].createElement("p", {
          key: key,
          className: "github-Message-description"
        }, description);
      }
    });
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-Message"
    }, _react["default"].createElement("div", {
      className: "github-Message-wrapper"
    }, _react["default"].createElement("h1", {
      className: "github-Message-title"
    }, this.props.title), this.props.descriptions.map(this.renderDescription), _react["default"].createElement("div", {
      className: "github-Message-action"
    }, this.props.retry && _react["default"].createElement("button", {
      className: "github-Message-button btn btn-primary",
      onClick: this.props.retry
    }, "Try Again"), this.props.logout && _react["default"].createElement("button", {
      className: "github-Message-button btn btn-logout",
      onClick: this.props.logout
    }, "Logout"))));
  }

}

exports["default"] = ErrorView;

_defineProperty(ErrorView, "propTypes", {
  title: _propTypes["default"].string,
  descriptions: _propTypes["default"].arrayOf(_propTypes["default"].string),
  preformatted: _propTypes["default"].bool,
  retry: _propTypes["default"].func,
  logout: _propTypes["default"].func
});

_defineProperty(ErrorView, "defaultProps", {
  title: 'Error',
  descriptions: ['An unknown error occurred'],
  preformatted: false
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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