"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _panel = _interopRequireDefault(require("../atom/panel"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class DialogView extends _react["default"].Component {
  render() {
    return _react["default"].createElement(_panel["default"], {
      workspace: this.props.workspace,
      location: "modal"
    }, _react["default"].createElement("div", {
      className: "github-Dialog",
      onTransitionEnd: () => this.props.autofocus.trigger()
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: ".github-Dialog"
    }, _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.props.accept
    }), _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.props.cancel
    })), this.props.prompt && _react["default"].createElement("header", {
      className: "github-DialogPrompt"
    }, this.props.prompt), _react["default"].createElement("main", {
      className: "github-DialogForm"
    }, this.props.children), _react["default"].createElement("footer", {
      className: "github-DialogFooter"
    }, _react["default"].createElement("div", {
      className: "github-DialogInfo"
    }, this.props.progressMessage && this.props.inProgress && _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("span", {
      className: "inline-block loading loading-spinner-small"
    }), _react["default"].createElement("span", {
      className: "github-DialogProgress-message"
    }, this.props.progressMessage)), this.props.error && _react["default"].createElement("ul", {
      className: "error-messages"
    }, _react["default"].createElement("li", null, this.props.error.userMessage || this.props.error.message))), _react["default"].createElement("div", {
      className: "github-DialogButtons"
    }, _react["default"].createElement("button", {
      tabIndex: this.props.cancelTabIndex,
      className: "btn github-Dialog-cancelButton",
      onClick: this.props.cancel
    }, "Cancel"), _react["default"].createElement("button", {
      tabIndex: this.props.acceptTabIndex,
      className: (0, _classnames["default"])('btn btn-primary github-Dialog-acceptButton', this.props.acceptClassName),
      onClick: this.props.accept,
      disabled: this.props.inProgress || !this.props.acceptEnabled
    }, this.props.acceptText)))));
  }

}

exports["default"] = DialogView;

_defineProperty(DialogView, "propTypes", {
  // Customization
  prompt: _propTypes["default"].string,
  progressMessage: _propTypes["default"].string,
  acceptEnabled: _propTypes["default"].bool,
  acceptTabIndex: _propTypes["default"].number,
  acceptClassName: _propTypes["default"].string,
  acceptText: _propTypes["default"].string,
  cancelTabIndex: _propTypes["default"].number,
  // Callbacks
  accept: _propTypes["default"].func.isRequired,
  cancel: _propTypes["default"].func.isRequired,
  // State
  autofocus: _propTypes["default"].shape({
    trigger: _propTypes["default"].func.isRequired
  }),
  inProgress: _propTypes["default"].bool.isRequired,
  error: _propTypes["default"].instanceOf(Error),
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  // Form content
  children: _propTypes["default"].node.isRequired
});

_defineProperty(DialogView, "defaultProps", {
  acceptTabIndex: 0,
  acceptEnabled: true,
  acceptText: 'Accept',
  cancelTabIndex: 0
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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