"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCheckRunView = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _githubDotcomMarkdown = _interopRequireDefault(require("./github-dotcom-markdown"));

var _buildStatus = require("../models/build-status");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCheckRunView extends _react["default"].Component {
  render() {
    const {
      checkRun
    } = this.props;
    const {
      icon,
      classSuffix
    } = (0, _buildStatus.buildStatusFromCheckResult)(checkRun);
    return _react["default"].createElement("li", {
      className: "github-PrStatuses-list-item github-PrStatuses-list-item--checkRun"
    }, _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-icon"
    }, _react["default"].createElement(_octicon["default"], {
      icon: icon,
      className: `github-PrStatuses--${classSuffix}`
    })), _react["default"].createElement("a", {
      className: "github-PrStatuses-list-item-name",
      href: checkRun.permalink
    }, checkRun.name), _react["default"].createElement("div", {
      className: "github-PrStatuses-list-item-context"
    }, checkRun.title && _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-title"
    }, checkRun.title), checkRun.summary && _react["default"].createElement(_githubDotcomMarkdown["default"], {
      className: "github-PrStatuses-list-item-summary",
      switchToIssueish: this.props.switchToIssueish,
      markdown: checkRun.summary
    })), checkRun.detailsUrl && _react["default"].createElement("a", {
      className: "github-PrStatuses-list-item-details-link",
      href: checkRun.detailsUrl
    }, "Details"));
  }

}

exports.BareCheckRunView = BareCheckRunView;

_defineProperty(BareCheckRunView, "propTypes", {
  // Relay
  checkRun: _propTypes["default"].shape({
    name: _propTypes["default"].string.isRequired,
    status: _propTypes["default"].oneOf(['QUEUED', 'IN_PROGRESS', 'COMPLETED', 'REQUESTED']).isRequired,
    conclusion: _propTypes["default"].oneOf(['ACTION_REQUIRED', 'TIMED_OUT', 'CANCELLED', 'FAILURE', 'SUCCESS', 'NEUTRAL']),
    title: _propTypes["default"].string,
    detailsUrl: _propTypes["default"].string
  }).isRequired,
  // Actions
  switchToIssueish: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCheckRunView, {
  checkRun: function () {
    const node = require("./__generated__/checkRunView_checkRun.graphql");

    if (node.hash && node.hash !== "7135f882a3513e65b0a52393a0cc8b40") {
      console.error("The definition of 'checkRunView_checkRun' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/checkRunView_checkRun.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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