"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Accordion extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'toggle');
    this.state = {
      expanded: true
    };
  }

  render() {
    return _react["default"].createElement("details", {
      className: "github-Accordion",
      open: this.state.expanded
    }, _react["default"].createElement("summary", {
      className: "github-Accordion-header",
      onClick: this.toggle
    }, this.renderHeader()), _react["default"].createElement("main", {
      className: "github-Accordion-content"
    }, this.renderContent()));
  }

  renderHeader() {
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("span", {
      className: "github-Accordion--leftTitle"
    }, this.props.leftTitle), this.props.rightTitle && _react["default"].createElement("span", {
      className: "github-Accordion--rightTitle"
    }, this.props.rightTitle), this.props.reviewsButton());
  }

  renderContent() {
    if (this.props.isLoading) {
      const Loading = this.props.loadingComponent;
      return _react["default"].createElement(Loading, null);
    }

    if (this.props.results.length === 0) {
      const Empty = this.props.emptyComponent;
      return _react["default"].createElement(Empty, null);
    }

    if (!this.state.expanded) {
      return null;
    }

    const More = this.props.moreComponent;
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("ul", {
      className: "github-Accordion-list"
    }, this.props.results.map((item, index) => {
      const key = item.key !== undefined ? item.key : index;
      return _react["default"].createElement("li", {
        className: "github-Accordion-listItem",
        key: key,
        onClick: () => this.props.onClickItem(item)
      }, this.props.children(item));
    })), this.props.results.length < this.props.total && _react["default"].createElement(More, null));
  }

  toggle(e) {
    e.preventDefault();
    return new Promise(resolve => {
      this.setState(prevState => ({
        expanded: !prevState.expanded
      }), resolve);
    });
  }

}

exports["default"] = Accordion;

_defineProperty(Accordion, "propTypes", {
  leftTitle: _propTypes["default"].string.isRequired,
  rightTitle: _propTypes["default"].string,
  results: _propTypes["default"].arrayOf(_propTypes["default"].any).isRequired,
  total: _propTypes["default"].number.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  loadingComponent: _propTypes["default"].func,
  emptyComponent: _propTypes["default"].func,
  moreComponent: _propTypes["default"].func,
  reviewsButton: _propTypes["default"].func,
  onClickItem: _propTypes["default"].func,
  children: _propTypes["default"].func.isRequired
});

_defineProperty(Accordion, "defaultProps", {
  loadingComponent: () => null,
  emptyComponent: () => null,
  moreComponent: () => null,
  onClickItem: () => {},
  reviewsButton: () => null
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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